/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.math.XMath;
import one.microstream.persistence.types.PersistenceFunction;
import one.microstream.persistence.types.PersistenceObjectManager;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;

public interface PersistenceRegisterer
extends PersistenceFunction {
    public long register(Object var1);

    public long[] registerAll(Object ... var1);

    public static interface Creator {
        public PersistenceRegisterer createRegisterer(PersistenceObjectManager<?> var1, PersistenceTypeHandlerManager<?> var2);
    }

    public static class Default
    implements PersistenceRegisterer {
        private final PersistenceObjectManager<?> objectManager;
        private final PersistenceTypeHandlerManager<?> typeHandlerManager;
        private final Entry[] oidsSlots;
        private final int oidsModulo;

        public Default(PersistenceObjectManager<?> objectManager, PersistenceTypeHandlerManager<?> typeManager) {
            this.objectManager = (PersistenceObjectManager)X.notNull(objectManager);
            this.typeHandlerManager = (PersistenceTypeHandlerManager)X.notNull(typeManager);
            this.oidsSlots = new Entry[1];
            this.oidsModulo = 0;
        }

        public Default(PersistenceObjectManager<?> objectManager, PersistenceTypeHandlerManager<?> typeManager, int hashRange) {
            this.objectManager = (PersistenceObjectManager)X.notNull(objectManager);
            this.typeHandlerManager = (PersistenceTypeHandlerManager)X.notNull(typeManager);
            this.oidsSlots = new Entry[XMath.pow2BoundCapped((int)hashRange)];
            this.oidsModulo = this.oidsSlots.length - 1;
        }

        @Override
        public <T> long apply(T instance) {
            if (instance == null || this.isRegisteredLocal(instance)) {
                return 0L;
            }
            PersistenceTypeHandler<?, ?> handler = this.typeHandlerManager.ensureTypeHandler(instance.getClass());
            this.registerLocal(instance);
            this.objectManager.ensureObjectId(instance);
            handler.iterateInstanceReferences(instance, this);
            return 0L;
        }

        private boolean isRegisteredLocal(Object instance) {
            Entry e = this.oidsSlots[System.identityHashCode(instance) & this.oidsModulo];
            while (e != null) {
                if (e.ref == instance) {
                    return true;
                }
                e = e.link;
            }
            return false;
        }

        private void registerLocal(Object instance) {
            int index = System.identityHashCode(instance) & this.oidsModulo;
            Entry e = this.oidsSlots[index];
            if (e == null) {
                this.oidsSlots[index] = new Entry(instance);
                return;
            }
            do {
                if (e.ref != instance) continue;
                return;
            } while ((e = e.link) != null);
            this.oidsSlots[index] = new Entry(instance, this.oidsSlots[index]);
        }

        @Override
        public long register(Object instance) {
            return this.apply(instance);
        }

        @Override
        public long[] registerAll(Object ... instances) {
            long[] oids = new long[instances.length];
            for (int i = 0; i < instances.length; ++i) {
                oids[i] = this.apply(instances[i]);
            }
            return oids;
        }

        public static class Creator
        implements one.microstream.persistence.types.PersistenceRegisterer$Creator {
            @Override
            public PersistenceRegisterer createRegisterer(PersistenceObjectManager<?> objectManager, PersistenceTypeHandlerManager<?> typeManager) {
                return new Default(objectManager, typeManager);
            }
        }

        private static final class Entry {
            final Object ref;
            Entry link;

            Entry(Object instance) {
                this.ref = instance;
                this.link = null;
            }

            Entry(Object instance, Entry link) {
                this.ref = instance;
                this.link = link;
            }
        }
    }
}

