/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.persistence.types.PersistenceFoundation;
import one.microstream.persistence.types.PersistenceObjectManager;
import one.microstream.persistence.types.PersistenceStorer;
import one.microstream.persistence.types.PersistenceStorerDeactivatable;
import one.microstream.persistence.types.PersistenceStorerDeactivatableRegistry;
import one.microstream.persistence.types.PersistenceTarget;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.util.BufferSizeProviderIncremental;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public class PersistenceStorerCreatorDeactivatable<D>
implements PersistenceStorer.Creator<D> {
    private static final Logger logger = Logging.getLogger(PersistenceStorerCreatorDeactivatable.class);
    private final PersistenceStorer.Creator<D> creator;
    private final PersistenceStorerDeactivatableRegistry storerRegistry;

    public static <D> PersistenceStorerCreatorDeactivatable<D> New(PersistenceFoundation<D, ?> connectionFoundation, PersistenceStorerDeactivatableRegistry storerRegistry) {
        return new PersistenceStorerCreatorDeactivatable<D>(connectionFoundation.getStorerCreator(), storerRegistry);
    }

    public PersistenceStorerCreatorDeactivatable(PersistenceStorer.Creator<D> creator, PersistenceStorerDeactivatableRegistry storerModeController) {
        this.creator = creator;
        this.storerRegistry = storerModeController;
    }

    @Override
    public PersistenceStorer createLazyStorer(PersistenceTypeHandlerManager<D> typeManager, PersistenceObjectManager<D> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<D> target, BufferSizeProviderIncremental bufferSizeProvider) {
        logger.debug("Creating lazy storer");
        return this.storerRegistry.register(new PersistenceStorerDeactivatable(this.creator.createLazyStorer(typeManager, objectManager, objectRetriever, target, bufferSizeProvider)));
    }

    @Override
    public PersistenceStorer createEagerStorer(PersistenceTypeHandlerManager<D> typeManager, PersistenceObjectManager<D> objectManager, ObjectSwizzling objectRetriever, PersistenceTarget<D> target, BufferSizeProviderIncremental bufferSizeProvider) {
        logger.debug("Creating eager storer");
        return this.storerRegistry.register(new PersistenceStorerDeactivatable(this.creator.createEagerStorer(typeManager, objectManager, objectRetriever, target, bufferSizeProvider)));
    }
}

