/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceRefactoringMapping;
import one.microstream.persistence.types.PersistenceRefactoringMemberIdentifierBuilder;
import one.microstream.persistence.types.PersistenceRefactoringTypeIdentifierBuilder;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeResolver;
import one.microstream.typing.KeyValue;

public interface PersistenceTypeDescriptionResolver
extends PersistenceTypeResolver {
    public KeyValue<String, String> lookup(String var1);

    public String resolveRuntimeTypeName(PersistenceTypeDescription var1);

    default public String resolveRuntimeTypeName(String descriptionTypeName) {
        KeyValue<String, String> entry = this.lookup(descriptionTypeName);
        if (entry == null) {
            return descriptionTypeName;
        }
        return (String)entry.value();
    }

    default public Class<?> resolveRuntimeType(PersistenceTypeDescription typeDescription) {
        String runtimeTypeName = this.resolveRuntimeTypeName(typeDescription);
        return this.resolveType(runtimeTypeName);
    }

    default public Class<?> tryResolveRuntimeType(PersistenceTypeDescription typeDescription) {
        String runtimeTypeName = this.resolveRuntimeTypeName(typeDescription);
        return this.tryResolveType(runtimeTypeName);
    }

    public KeyValue<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> resolveMember(PersistenceTypeDefinition var1, PersistenceTypeDefinitionMember var2, PersistenceTypeDefinition var3);

    public boolean isNewCurrentTypeMember(PersistenceTypeDefinition var1, PersistenceTypeDefinitionMember var2);

    public static PersistenceTypeDescriptionResolver New(PersistenceTypeResolver typeResolver, PersistenceRefactoringMapping refactoringMapping, XGettingEnum<? extends PersistenceRefactoringTypeIdentifierBuilder> sourceTypeIdentifierBuilders, XGettingEnum<? extends PersistenceRefactoringMemberIdentifierBuilder> sourceMemberIdentifierBuilders, XGettingEnum<? extends PersistenceRefactoringMemberIdentifierBuilder> targetMemberIdentifierBuilders) {
        return new Default(typeResolver, refactoringMapping, (XImmutableEnum<? extends PersistenceRefactoringTypeIdentifierBuilder>)sourceTypeIdentifierBuilders.immure(), (XImmutableEnum<? extends PersistenceRefactoringMemberIdentifierBuilder>)sourceMemberIdentifierBuilders.immure(), (XImmutableEnum<? extends PersistenceRefactoringMemberIdentifierBuilder>)targetMemberIdentifierBuilders.immure());
    }

    public static final class Default
    implements PersistenceTypeDescriptionResolver {
        final PersistenceTypeResolver typeResolver;
        final PersistenceRefactoringMapping refactoringMapping;
        final XImmutableEnum<? extends PersistenceRefactoringTypeIdentifierBuilder> sourceTypeIdentifierBuilders;
        final XImmutableEnum<? extends PersistenceRefactoringMemberIdentifierBuilder> sourceMemberIdentifierBuilders;
        final XImmutableEnum<? extends PersistenceRefactoringMemberIdentifierBuilder> targetMemberIdentifierBuilders;

        Default(PersistenceTypeResolver typeResolver, PersistenceRefactoringMapping refactoringMapping, XImmutableEnum<? extends PersistenceRefactoringTypeIdentifierBuilder> sourceTypeIdentifierBuilders, XImmutableEnum<? extends PersistenceRefactoringMemberIdentifierBuilder> sourceMemberIdentifierBuilders, XImmutableEnum<? extends PersistenceRefactoringMemberIdentifierBuilder> targetMemberIdentifierBuilders) {
            this.typeResolver = typeResolver;
            this.refactoringMapping = refactoringMapping;
            this.sourceTypeIdentifierBuilders = sourceTypeIdentifierBuilders;
            this.sourceMemberIdentifierBuilders = sourceMemberIdentifierBuilders;
            this.targetMemberIdentifierBuilders = targetMemberIdentifierBuilders;
        }

        @Override
        public ClassLoader getTypeResolvingClassLoader(String typeName) {
            return this.typeResolver.getTypeResolvingClassLoader(typeName);
        }

        @Override
        public String resolveRuntimeTypeName(PersistenceTypeDescription typeDescription) {
            PersistenceRefactoringMapping refactoringMapping = this.refactoringMapping;
            for (PersistenceRefactoringTypeIdentifierBuilder idBuilder : this.sourceTypeIdentifierBuilders) {
                String identifier = idBuilder.buildTypeIdentifier(typeDescription);
                KeyValue<String, String> entry = refactoringMapping.lookup(identifier);
                if (entry == null) continue;
                return (String)entry.value();
            }
            return typeDescription.typeName();
        }

        @Override
        public final KeyValue<String, String> lookup(String sourceIdentifier) {
            return this.refactoringMapping.lookup(sourceIdentifier);
        }

        @Override
        public boolean isNewCurrentTypeMember(PersistenceTypeDefinition currentTypeDefinition, PersistenceTypeDefinitionMember currentTypeMember) {
            for (PersistenceRefactoringMemberIdentifierBuilder idBuilder : this.targetMemberIdentifierBuilders) {
                String identifier = idBuilder.buildMemberIdentifier(currentTypeDefinition, currentTypeMember);
                if (!this.refactoringMapping.isNewElement(identifier)) continue;
                return true;
            }
            return false;
        }

        @Override
        public KeyValue<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> resolveMember(PersistenceTypeDefinition sourceType, PersistenceTypeDefinitionMember sourceMember, PersistenceTypeDefinition targetType) {
            PersistenceRefactoringMapping refactoringMapping = this.refactoringMapping;
            for (PersistenceRefactoringMemberIdentifierBuilder idBuilder : this.sourceMemberIdentifierBuilders) {
                String identifier = idBuilder.buildMemberIdentifier(sourceType, sourceMember);
                KeyValue<String, String> entry = refactoringMapping.lookup(identifier);
                if (entry == null) continue;
                return this.resolveTarget(sourceType, sourceMember, targetType, (String)entry.value());
            }
            return null;
        }

        private KeyValue<PersistenceTypeDefinitionMember, PersistenceTypeDefinitionMember> resolveTarget(PersistenceTypeDefinition sourceType, PersistenceTypeDefinitionMember sourceMember, PersistenceTypeDefinition targetType, String targetMemberIdentifier) {
            if (targetMemberIdentifier == null) {
                return X.KeyValue((Object)sourceMember, null);
            }
            for (PersistenceTypeDefinitionMember targetMember : targetType.allMembers()) {
                for (PersistenceRefactoringMemberIdentifierBuilder idBuilder : this.targetMemberIdentifierBuilders) {
                    String identifier = idBuilder.buildMemberIdentifier(targetType, targetMember);
                    if (!identifier.equals(targetMemberIdentifier)) continue;
                    return X.KeyValue((Object)sourceMember, (Object)targetMember);
                }
            }
            throw new PersistenceException("Unresolvable type member refactoring mapping: " + sourceType.toTypeIdentifier() + "#" + sourceMember.identifier() + " -> \"" + targetMemberIdentifier + "\" in type " + targetType.toRuntimeTypeIdentifier());
        }
    }
}

