/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.chars.ObjectStringAssembler;
import one.microstream.chars.VarString;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.internal.TypeDictionaryAppenderBuilder;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberAppender;
import one.microstream.persistence.types.PersistenceTypeDictionary;

public interface PersistenceTypeDictionaryAssembler
extends ObjectStringAssembler<PersistenceTypeDictionary> {
    public VarString assemble(VarString var1, PersistenceTypeDictionary var2);

    default public String assemble(PersistenceTypeDictionary typeDictionary) {
        return super.assemble((Object)typeDictionary);
    }

    public VarString assembleTypeDescription(VarString var1, PersistenceTypeDescription var2);

    public static PersistenceTypeDictionaryAssembler New() {
        return new Default();
    }

    public static class Default
    extends PersistenceTypeDictionary.Symbols
    implements PersistenceTypeDictionaryAssembler {
        private static final int MAX_LONG_LENGTH = 19;
        private static final char ID_PADDING_CHAR = '0';

        Default() {
        }

        protected final VarString appendPaddedId(VarString vc, long id) {
            return vc.padLeft(Long.toString(id), 19, '0');
        }

        @Override
        public VarString assemble(VarString vc, PersistenceTypeDictionary typeDictionary) {
            for (PersistenceTypeDefinition td : typeDictionary.allTypeDefinitions().values()) {
                this.assembleTypeDescription(vc, td);
            }
            return vc;
        }

        private static TypeDictionaryAppenderBuilder appenderBuilder(VarString vc) {
            return new TypeDictionaryAppenderBuilder(vc, 1);
        }

        private void appendTypeDictionaryMembers(VarString vc, XGettingSequence<? extends PersistenceTypeDescriptionMember> typeMembers) {
            if (typeMembers.isEmpty()) {
                return;
            }
            PersistenceTypeDescriptionMemberAppender appender = ((TypeDictionaryAppenderBuilder)((Object)typeMembers.iterate((Consumer)((Object)Default.appenderBuilder(vc.lf()))))).yield();
            typeMembers.iterate((Consumer)appender);
        }

        @Override
        public VarString assembleTypeDescription(VarString vc, PersistenceTypeDescription typeDescription) {
            this.appendTypeDefinitionStart(vc, typeDescription);
            this.appendTypeDictionaryMembers(vc, typeDescription.allMembers());
            this.appendTypeDefinitionEnd(vc, typeDescription);
            return vc;
        }

        protected void appendTypeDefinitionStart(VarString vc, PersistenceTypeDescription typeDescription) {
            this.appendPaddedId(vc, typeDescription.typeId()).blank().add(typeDescription.typeName()).append('{');
        }

        protected void appendTypeDefinitionEnd(VarString vc, PersistenceTypeDescription typeDescription) {
            vc.append('}').lf();
        }
    }
}

