/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XAddingSequence;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XGettingTable;
import one.microstream.collections.types.XSortableSequence;
import one.microstream.hashing.HashEqualator;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionCreator;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberCreator;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionResolver;
import one.microstream.persistence.types.PersistenceTypeDescriptionResolverProvider;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryCreator;
import one.microstream.persistence.types.PersistenceTypeDictionaryEntry;

@FunctionalInterface
public interface PersistenceTypeDictionaryBuilder {
    public PersistenceTypeDictionary buildTypeDictionary(XGettingSequence<? extends PersistenceTypeDictionaryEntry> var1);

    public static XGettingTable<Long, PersistenceTypeDictionaryEntry> ensureUniqueTypeIds(XGettingSequence<? extends PersistenceTypeDictionaryEntry> entries) {
        EqHashTable uniqueTypeIdEntries = EqHashTable.New();
        if (entries != null) {
            for (PersistenceTypeDictionaryEntry e : entries) {
                if (uniqueTypeIdEntries.add((Object)e.typeId(), (Object)e)) continue;
                throw new PersistenceException("TypeId conflict for " + e.typeId() + " " + e.typeName());
            }
            XSort.valueSort((XSortableSequence)uniqueTypeIdEntries.keys(), Long::compare);
        }
        return uniqueTypeIdEntries;
    }

    public static PersistenceTypeDictionary buildTypeDictionary(PersistenceTypeDictionaryCreator typeDictionaryCreator, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolver typeResolver, XGettingSequence<? extends PersistenceTypeDictionaryEntry> entries) {
        XGettingTable<Long, PersistenceTypeDictionaryEntry> uniqueTypeIdEntries = PersistenceTypeDictionaryBuilder.ensureUniqueTypeIds(entries);
        PersistenceTypeDefinitionMemberCreator.Default memberCreator = PersistenceTypeDefinitionMemberCreator.New((XGettingSequence<? extends PersistenceTypeDescription>)uniqueTypeIdEntries.values(), typeResolver);
        BulkList typeDefs = BulkList.New((long)uniqueTypeIdEntries.size());
        for (PersistenceTypeDescription e : uniqueTypeIdEntries.values()) {
            EqHashEnum allMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
            EqHashEnum instanceMembers = EqHashEnum.New((HashEqualator)PersistenceTypeDescriptionMember.identityHashEqualator());
            PersistenceTypeDictionaryBuilder.buildDefinitionMembers(memberCreator, e, (XAddingSequence<? super PersistenceTypeDefinitionMember>)allMembers, (XAddingSequence<? super PersistenceTypeDefinitionMember>)instanceMembers);
            String runtimeTypeName = typeResolver.resolveRuntimeTypeName(e);
            Class<?> type = runtimeTypeName == null ? null : typeResolver.tryResolveType(runtimeTypeName);
            PersistenceTypeDefinition typeDef = typeDefinitionCreator.createTypeDefinition(e.typeId(), e.typeName(), runtimeTypeName, type, (XGettingEnum<? extends PersistenceTypeDefinitionMember>)allMembers, (XGettingEnum<? extends PersistenceTypeDefinitionMember>)instanceMembers);
            typeDefs.add((Object)typeDef);
        }
        PersistenceTypeDictionary typeDictionary = typeDictionaryCreator.createTypeDictionary();
        typeDictionary.registerTypeDefinitions((Iterable<? extends PersistenceTypeDefinition>)typeDefs);
        return typeDictionary;
    }

    public static void buildDefinitionMembers(PersistenceTypeDefinitionMemberCreator memberCreator, PersistenceTypeDescription typeDescription, XAddingSequence<? super PersistenceTypeDefinitionMember> allMembers, XAddingSequence<? super PersistenceTypeDefinitionMember> instanceMembers) {
        for (PersistenceTypeDescriptionMember member : typeDescription.allMembers()) {
            PersistenceTypeDefinitionMember definitionMember = member.createDefinitionMember(memberCreator);
            if (!allMembers.add((Object)definitionMember)) {
                throw new PersistenceException("Duplicate type member entry: " + member.identifier());
            }
            if (!definitionMember.isInstanceMember()) continue;
            instanceMembers.add((Object)definitionMember);
        }
    }

    public static Default New(PersistenceTypeDictionaryCreator typeDictionaryCreator, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolverProvider typeResolverProvider) {
        return new Default((PersistenceTypeDictionaryCreator)X.notNull((Object)typeDictionaryCreator), (PersistenceTypeDefinitionCreator)X.notNull((Object)typeDefinitionCreator), (PersistenceTypeDescriptionResolverProvider)X.notNull((Object)typeResolverProvider));
    }

    public static class Default
    implements PersistenceTypeDictionaryBuilder {
        final PersistenceTypeDictionaryCreator typeDictionaryCreator;
        final PersistenceTypeDefinitionCreator typeDefinitionCreator;
        final PersistenceTypeDescriptionResolverProvider typeResolverProvider;

        Default(PersistenceTypeDictionaryCreator typeDictionaryCreator, PersistenceTypeDefinitionCreator typeDefinitionCreator, PersistenceTypeDescriptionResolverProvider typeResolverProvider) {
            this.typeDictionaryCreator = typeDictionaryCreator;
            this.typeDefinitionCreator = typeDefinitionCreator;
            this.typeResolverProvider = typeResolverProvider;
        }

        @Override
        public PersistenceTypeDictionary buildTypeDictionary(XGettingSequence<? extends PersistenceTypeDictionaryEntry> entries) {
            return PersistenceTypeDictionaryBuilder.buildTypeDictionary(this.typeDictionaryCreator, this.typeDefinitionCreator, this.typeResolverProvider.provideTypeDescriptionResolver(), entries);
        }
    }
}

