/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import one.microstream.X;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryCreator;
import one.microstream.persistence.types.PersistenceTypeDictionaryExporter;
import one.microstream.persistence.types.PersistenceTypeDictionaryProvider;
import one.microstream.persistence.types.PersistenceTypeDictionaryView;
import one.microstream.persistence.types.PersistenceTypeDictionaryViewProvider;

public interface PersistenceTypeDictionaryManager
extends PersistenceTypeDictionaryProvider {
    public PersistenceTypeDictionaryManager validateTypeDefinition(PersistenceTypeDefinition var1);

    public PersistenceTypeDictionaryManager validateTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> var1);

    public boolean registerTypeDefinition(PersistenceTypeDefinition var1);

    public boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> var1);

    public boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition var1);

    public boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> var1);

    public static void validateTypeDefinition(PersistenceTypeDictionary dictionary, PersistenceTypeDefinition typeDefinition) {
        PersistenceTypeDictionary.validateTypeId(typeDefinition);
        PersistenceTypeDefinition registered = dictionary.lookupTypeById(typeDefinition.typeId());
        if (registered != null && !PersistenceTypeDescription.equalStructure(registered, typeDefinition)) {
            throw new PersistenceException("Type Definition mismatch: " + typeDefinition);
        }
    }

    public static PersistenceTypeDictionaryManager Exporting(PersistenceTypeDictionaryProvider typeDictionaryProvider, PersistenceTypeDictionaryExporter typeDictionaryExporter) {
        return new Exporting((PersistenceTypeDictionaryProvider)X.notNull((Object)typeDictionaryProvider), (PersistenceTypeDictionaryExporter)X.notNull((Object)typeDictionaryExporter));
    }

    public static PersistenceTypeDictionaryManager Transient(PersistenceTypeDictionaryCreator typeDictionaryCreator) {
        return new Transient((PersistenceTypeDictionaryCreator)X.notNull((Object)typeDictionaryCreator));
    }

    public static PersistenceTypeDictionaryManager Immutable(PersistenceTypeDictionaryViewProvider typeDictionaryProvider) {
        return new Immutable((PersistenceTypeDictionaryViewProvider)X.notNull((Object)typeDictionaryProvider));
    }

    public static final class Immutable
    extends Abstract<PersistenceTypeDictionaryView> {
        private final PersistenceTypeDictionaryViewProvider typeDictionaryProvider;

        Immutable(PersistenceTypeDictionaryViewProvider typeDictionaryProvider) {
            this.typeDictionaryProvider = typeDictionaryProvider;
        }

        @Override
        protected PersistenceTypeDictionaryView internalProvideTypeDictionary() {
            return this.typeDictionaryProvider.provideTypeDictionary();
        }

        @Override
        public final synchronized boolean registerTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            return this.registerTypeDefinitions((Iterable<? extends PersistenceTypeDefinition>)X.Constant((Object)typeDefinition));
        }

        @Override
        public final synchronized boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            PersistenceTypeDictionaryView typeDictionary = (PersistenceTypeDictionaryView)this.ensureTypeDictionary();
            for (PersistenceTypeDefinition persistenceTypeDefinition : typeDefinitions) {
                PersistenceTypeDictionary.validateTypeId(persistenceTypeDefinition);
                PersistenceTypeDefinition registered = typeDictionary.lookupTypeById(persistenceTypeDefinition.typeId());
                if (registered != null && PersistenceTypeDescription.equalDescription(registered, persistenceTypeDefinition)) continue;
                throw new UnsupportedOperationException("Read-only TypeDictionary cannot change.");
            }
            return false;
        }

        @Override
        public final synchronized boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            return this.registerTypeDefinition(typeDefinition);
        }

        @Override
        public final synchronized boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            return this.registerTypeDefinitions(typeDefinitions);
        }
    }

    public static final class Transient
    extends Abstract<PersistenceTypeDictionary> {
        private final PersistenceTypeDictionaryCreator typeDictionaryCreator;

        Transient(PersistenceTypeDictionaryCreator typeDictionaryCreator) {
            this.typeDictionaryCreator = typeDictionaryCreator;
        }

        @Override
        protected PersistenceTypeDictionary internalProvideTypeDictionary() {
            return this.typeDictionaryCreator.createTypeDictionary();
        }
    }

    public static final class Exporting
    extends Abstract<PersistenceTypeDictionary> {
        private final PersistenceTypeDictionaryProvider typeDictionaryProvider;
        private final PersistenceTypeDictionaryExporter typeDictionaryExporter;
        private transient boolean changed;

        Exporting(PersistenceTypeDictionaryProvider typeDictionaryProvider, PersistenceTypeDictionaryExporter typeDictionaryExporter) {
            this.typeDictionaryProvider = typeDictionaryProvider;
            this.typeDictionaryExporter = typeDictionaryExporter;
        }

        private boolean hasChanged() {
            return this.changed;
        }

        private void markChanged() {
            this.changed = true;
        }

        private void resetChangeMark() {
            this.changed = false;
        }

        @Override
        protected final PersistenceTypeDictionary internalProvideTypeDictionary() {
            PersistenceTypeDictionary typeDictionary = this.typeDictionaryProvider.provideTypeDictionary();
            this.markChanged();
            return typeDictionary;
        }

        public final Exporting synchUpdateExport() {
            if (this.hasChanged()) {
                this.exportTypeDictionary();
                this.resetChangeMark();
            }
            return this;
        }

        public final synchronized Exporting exportTypeDictionary() {
            this.typeDictionaryExporter.exportTypeDictionary((PersistenceTypeDictionary)this.ensureTypeDictionary());
            return this;
        }

        @Override
        public final synchronized boolean registerTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            boolean hasChanged = super.registerTypeDefinition(typeDefinition);
            if (hasChanged) {
                this.markChanged();
                this.synchUpdateExport();
            }
            return hasChanged;
        }

        @Override
        public final synchronized boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            boolean hasChanged = super.registerTypeDefinitions(typeDefinitions);
            if (hasChanged) {
                this.markChanged();
                this.synchUpdateExport();
            }
            return hasChanged;
        }

        @Override
        public final synchronized boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            boolean hasChanged = super.registerRuntimeTypeDefinition(typeDefinition);
            if (hasChanged) {
                this.markChanged();
                this.synchUpdateExport();
            }
            return hasChanged;
        }

        @Override
        public final synchronized boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            boolean hasChanged = super.registerRuntimeTypeDefinitions(typeDefinitions);
            if (hasChanged) {
                this.markChanged();
                this.synchUpdateExport();
            }
            return hasChanged;
        }
    }

    public static abstract class Abstract<D extends PersistenceTypeDictionary>
    implements PersistenceTypeDictionaryManager {
        private transient D cachedTypeDictionary;

        protected Abstract() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final D ensureTypeDictionary() {
            if (this.cachedTypeDictionary == null) {
                Abstract abstract_ = this;
                synchronized (abstract_) {
                    if (this.cachedTypeDictionary == null) {
                        this.cachedTypeDictionary = this.internalProvideTypeDictionary();
                    }
                }
            }
            return this.cachedTypeDictionary;
        }

        protected abstract D internalProvideTypeDictionary();

        @Override
        public synchronized PersistenceTypeDictionary provideTypeDictionary() {
            return this.ensureTypeDictionary();
        }

        @Override
        public synchronized boolean registerTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            this.validateTypeDefinition(typeDefinition);
            return this.ensureTypeDictionary().registerTypeDefinition(typeDefinition);
        }

        @Override
        public synchronized boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            this.validateTypeDefinitions(typeDefinitions);
            return this.ensureTypeDictionary().registerTypeDefinitions(typeDefinitions);
        }

        @Override
        public synchronized boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            this.validateTypeDefinition(typeDefinition);
            return this.ensureTypeDictionary().registerRuntimeTypeDefinition(typeDefinition);
        }

        @Override
        public synchronized boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            this.validateTypeDefinitions(typeDefinitions);
            return this.ensureTypeDictionary().registerRuntimeTypeDefinitions(typeDefinitions);
        }

        @Override
        public synchronized PersistenceTypeDictionaryManager validateTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            PersistenceTypeDictionaryManager.validateTypeDefinition(this.ensureTypeDictionary(), typeDefinition);
            return this;
        }

        @Override
        public synchronized PersistenceTypeDictionaryManager validateTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            D typeDictionary = this.ensureTypeDictionary();
            for (PersistenceTypeDefinition persistenceTypeDefinition : typeDefinitions) {
                PersistenceTypeDictionaryManager.validateTypeDefinition(typeDictionary, persistenceTypeDefinition);
            }
            return this;
        }
    }
}

