/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import one.microstream.X;
import one.microstream.collections.HashEnum;
import one.microstream.collections.types.XAddingEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XPrependingEnum;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeNotPersistable;
import one.microstream.persistence.types.PersistenceEagerStoringFieldEvaluator;
import one.microstream.persistence.types.PersistenceFieldLengthResolver;
import one.microstream.persistence.types.PersistenceTypeAnalyzer;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeResolver;
import one.microstream.reflect.XReflect;

public interface PersistenceTypeHandlerCreator<D> {
    public <T> PersistenceTypeHandler<D, T> createTypeHandlerArray(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerProxy(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerLambda(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerEnum(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerEntity(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerAbstract(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerUnpersistable(Class<T> var1);

    public <T> PersistenceTypeHandler<D, T> createTypeHandlerGeneric(Class<T> var1) throws PersistenceExceptionTypeNotPersistable;

    public static abstract class Abstract<D>
    implements PersistenceTypeHandlerCreator<D> {
        final PersistenceTypeAnalyzer typeAnalyzer;
        final PersistenceTypeResolver typeResolver;
        final PersistenceFieldLengthResolver lengthResolver;
        final PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator;

        protected Abstract(PersistenceTypeAnalyzer typeAnalyzer, PersistenceTypeResolver typeResolver, PersistenceFieldLengthResolver lengthResolver, PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator) {
            this.typeAnalyzer = (PersistenceTypeAnalyzer)X.notNull((Object)typeAnalyzer);
            this.typeResolver = (PersistenceTypeResolver)X.notNull((Object)typeResolver);
            this.lengthResolver = (PersistenceFieldLengthResolver)X.notNull((Object)lengthResolver);
            this.eagerStoringFieldEvaluator = (PersistenceEagerStoringFieldEvaluator)X.notNull((Object)eagerStoringFieldEvaluator);
        }

        public String deriveTypeName(Class<?> type) {
            return this.typeResolver.deriveTypeName(type);
        }

        public PersistenceFieldLengthResolver lengthResolver() {
            return this.lengthResolver;
        }

        public PersistenceEagerStoringFieldEvaluator eagerStoringFieldEvaluator() {
            return this.eagerStoringFieldEvaluator;
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerArray(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            if (type.getComponentType().isPrimitive()) {
                throw new PersistenceException("Persisting primitive component type arrays requires a special-tailored " + PersistenceTypeHandler.class.getSimpleName() + " and cannot be done in a generic way.");
            }
            return this.internalCreateTypeHandlerArray(type);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerProxy(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            throw new PersistenceException("Proxy classes (subclasses of " + Proxy.class.getName() + ") are not supported.");
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerLambda(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            throw new PersistenceException("Lambdas are not supported as they cannot be resolved during loading due to insufficient reflection mechanisms provided by the (current) JVM.");
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerEnum(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            return this.internalCreateTypeHandlerEnum(type);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerEntity(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            return this.internalCreateTypeHandlerEntity(type);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerAbstract(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            return this.internalCreateTypeHandlerAbstractType(type);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerUnpersistable(Class<T> type) {
            return this.internalCreateTypeHandlerUnpersistable(type);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> createTypeHandlerGeneric(Class<T> type) throws PersistenceExceptionTypeNotPersistable {
            if (XReflect.isJavaUtilCollectionType(type)) {
                return this.internalCreateTypeHandlerJavaUtilCollection(type);
            }
            HashEnum persistableFields = HashEnum.New();
            HashEnum persisterFields = HashEnum.New();
            HashEnum problematicFields = HashEnum.New();
            this.typeAnalyzer.collectPersistableFieldsEntity(type, persistableFields, (XPrependingEnum<Field>)persisterFields, (XAddingEnum<Field>)problematicFields);
            Abstract.checkNoProblematicFields(type, (XGettingEnum<Field>)problematicFields);
            return this.internalCreateTypeHandlerGeneric(type, (XGettingEnum<Field>)persistableFields, (XGettingEnum<Field>)persisterFields);
        }

        private static void checkNoProblematicFields(Class<?> type, XGettingEnum<Field> problematicFields) {
            if (problematicFields.isEmpty()) {
                return;
            }
            throw new PersistenceException("Type \"" + type.getName() + "\" not persistable due to problematic fields " + problematicFields.toString());
        }

        protected <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerEnum(Class<T> type) {
            HashEnum persistableFields = HashEnum.New();
            HashEnum persisterFields = HashEnum.New();
            HashEnum problematicFields = HashEnum.New();
            this.typeAnalyzer.collectPersistableFieldsEnum(type, persistableFields, (XPrependingEnum<Field>)persisterFields, (XAddingEnum<Field>)problematicFields);
            Abstract.checkNoProblematicFields(type, (XGettingEnum<Field>)problematicFields);
            return this.internalCreateTypeHandlerEnum(type, (XGettingEnum<Field>)persistableFields, (XGettingEnum<Field>)persisterFields);
        }

        protected <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerJavaUtilCollection(Class<T> type) {
            HashEnum persistableFields = HashEnum.New();
            HashEnum persisterFields = HashEnum.New();
            HashEnum problematicFields = HashEnum.New();
            this.typeAnalyzer.collectPersistableFieldsCollection(type, persistableFields, (XPrependingEnum<Field>)persisterFields, (XAddingEnum<Field>)problematicFields);
            if (!problematicFields.isEmpty()) {
                this.internalCreateTypeHandlerGenericJavaUtilCollection(type);
            }
            return this.internalCreateTypeHandlerGeneric(type, (XGettingEnum<Field>)persistableFields, (XGettingEnum<Field>)persisterFields);
        }

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerEnum(Class<T> var1, XGettingEnum<Field> var2, XGettingEnum<Field> var3);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerEntity(Class<T> var1);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerAbstractType(Class<T> var1);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerUnpersistable(Class<T> var1);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerArray(Class<T> var1);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerGeneric(Class<T> var1, XGettingEnum<Field> var2, XGettingEnum<Field> var3);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerGenericStateless(Class<T> var1);

        protected abstract <T> PersistenceTypeHandler<D, T> internalCreateTypeHandlerGenericJavaUtilCollection(Class<T> var1);
    }
}

