/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.HashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XAddingEnum;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingTable;
import one.microstream.equality.Equalator;
import one.microstream.persistence.exceptions.PersistenceException;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeHandlerConsistency;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceLegacyTypeMapper;
import one.microstream.persistence.types.PersistenceRoots;
import one.microstream.persistence.types.PersistenceRootsProvider;
import one.microstream.persistence.types.PersistenceStoring;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryManager;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerProvider;
import one.microstream.persistence.types.PersistenceTypeHandlerRegistry;
import one.microstream.persistence.types.PersistenceTypeLineage;
import one.microstream.persistence.types.PersistenceTypeLink;
import one.microstream.persistence.types.PersistenceTypeManager;
import one.microstream.persistence.types.PersistenceTypeMismatchValidator;
import one.microstream.persistence.types.PersistenceUnreachableTypeHandler;
import one.microstream.persistence.types.PersistenceUnreachableTypeHandlerCreator;
import one.microstream.reference.Swizzling;
import one.microstream.reflect.XReflect;
import one.microstream.typing.KeyValue;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface PersistenceTypeHandlerManager<D>
extends PersistenceTypeManager,
PersistenceTypeHandlerRegistry<D> {
    @Override
    public <T> PersistenceTypeHandler<D, ? super T> lookupTypeHandler(T var1);

    @Override
    public <T> PersistenceTypeHandler<D, ? super T> lookupTypeHandler(Class<T> var1);

    @Override
    public PersistenceTypeHandler<D, ?> lookupTypeHandler(long var1);

    public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(T var1);

    public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> var1);

    public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(PersistenceTypeDefinition var1);

    public <T> PersistenceLegacyTypeHandler<D, ? super T> ensureLegacyTypeHandler(PersistenceTypeDefinition var1, PersistenceTypeHandler<D, ? super T> var2);

    public void ensureTypeHandlers(XGettingEnum<PersistenceTypeDefinition> var1);

    public void ensureTypeHandlersByTypeIds(XGettingEnum<Long> var1);

    public PersistenceTypeHandlerManager<D> initialize();

    public void update(PersistenceTypeDictionary var1, long var2);

    default public void update(PersistenceTypeDictionary typeDictionary) {
        this.update(typeDictionary, 0L);
    }

    public PersistenceTypeDictionary typeDictionary();

    @Override
    public long ensureTypeId(Class<?> var1);

    @Override
    public Class<?> ensureType(long var1);

    public void validateTypeHandler(PersistenceTypeHandler<D, ?> var1);

    default public void validateTypeHandlers(Iterable<? extends PersistenceTypeHandler<D, ?>> typeHandlers) {
        for (PersistenceTypeHandler<D, ?> typeHandler : typeHandlers) {
            this.validateTypeHandler(typeHandler);
        }
    }

    public void checkForPendingRootInstances();

    public void checkForPendingRootsStoring(PersistenceStoring var1);

    public void clearStorePendingRoots();

    default public String deriveEnumRootIdentifier(PersistenceTypeHandler<?, ?> typeHandler) {
        return Persistence.deriveEnumRootIdentifier(typeHandler);
    }

    default public boolean isEnumRootIdentifier(String enumRootIdentifier) {
        return Persistence.isEnumRootIdentifier(enumRootIdentifier);
    }

    default public Long parseEnumRootIdentifierTypeId(String enumRootIdentifier) {
        return Persistence.parseEnumRootIdentifierTypeId(enumRootIdentifier);
    }

    default public Object[] collectEnumConstants(PersistenceTypeHandler<?, ?> typeHandler) {
        try {
            return typeHandler.collectEnumConstants();
        }
        catch (Exception e) {
            throw new PersistenceException("Enum constants collection failed for type handler " + typeHandler.toRuntimeTypeIdentifier());
        }
    }

    public static <D> void registerEnumContantRoots(HashTable<Class<?>, PersistenceTypeHandler<D, ?>> pendingEnumConstantRootStoringHandlers, PersistenceTypeHandler<D, ?> typeHandler) {
        if (!XReflect.isDeclaredEnum(typeHandler.type())) {
            return;
        }
        pendingEnumConstantRootStoringHandlers.add(typeHandler.type(), typeHandler);
    }

    public static <D> Default<D> New(PersistenceTypeHandlerRegistry<D> typeHandlerRegistry, PersistenceTypeHandlerProvider<D> typeHandlerProvider, PersistenceTypeDictionaryManager typeDictionaryManager, PersistenceTypeMismatchValidator<D> typeMismatchValidator, PersistenceLegacyTypeMapper<D> legacyTypeMapper, PersistenceUnreachableTypeHandlerCreator<D> unreachableTypeHandlerCreator, PersistenceRootsProvider<D> rootsProvider) {
        HashTable pendingEnumConstantRootStoringHandlers = HashTable.New();
        typeHandlerProvider.iterateTypeHandlers(th -> PersistenceTypeHandlerManager.registerEnumContantRoots(pendingEnumConstantRootStoringHandlers, th));
        return new Default((PersistenceTypeHandlerRegistry)X.notNull(typeHandlerRegistry), (PersistenceTypeHandlerProvider)X.notNull(typeHandlerProvider), (PersistenceTypeDictionaryManager)X.notNull((Object)typeDictionaryManager), (PersistenceTypeMismatchValidator)X.notNull(typeMismatchValidator), (PersistenceLegacyTypeMapper)X.notNull(legacyTypeMapper), (PersistenceUnreachableTypeHandlerCreator)X.notNull(unreachableTypeHandlerCreator), (PersistenceRootsProvider)X.notNull(rootsProvider), pendingEnumConstantRootStoringHandlers);
    }

    public static final class Default<D>
    implements PersistenceTypeHandlerManager<D> {
        private static final Logger logger = Logging.getLogger(Default.class);
        final PersistenceTypeHandlerRegistry<D> typeHandlerRegistry;
        private final PersistenceTypeHandlerProvider<D> typeHandlerProvider;
        private final PersistenceTypeDictionaryManager typeDictionaryManager;
        private final PersistenceTypeMismatchValidator<D> typeMismatchValidator;
        private final PersistenceLegacyTypeMapper<D> legacyTypeMapper;
        private final PersistenceUnreachableTypeHandlerCreator<D> unreachableTypeHandlerCreator;
        private final PersistenceRootsProvider<D> rootsProvider;
        private final HashTable<Class<?>, PersistenceTypeHandler<D, ?>> pendingEnumConstantRootStoringHandlers;
        private transient PersistenceRoots pendingStoreRoot;
        private boolean initialized;

        Default(PersistenceTypeHandlerRegistry<D> typeHandlerRegistry, PersistenceTypeHandlerProvider<D> typeHandlerProvider, PersistenceTypeDictionaryManager typeDictionaryManager, PersistenceTypeMismatchValidator<D> typeMismatchValidator, PersistenceLegacyTypeMapper<D> legacyTypeMapper, PersistenceUnreachableTypeHandlerCreator<D> unreachableTypeHandlerCreator, PersistenceRootsProvider<D> rootsProvider, HashTable<Class<?>, PersistenceTypeHandler<D, ?>> pendingEnumConstantRootStoringHandlers) {
            this.typeHandlerRegistry = typeHandlerRegistry;
            this.typeHandlerProvider = typeHandlerProvider;
            this.typeDictionaryManager = typeDictionaryManager;
            this.typeMismatchValidator = typeMismatchValidator;
            this.legacyTypeMapper = legacyTypeMapper;
            this.unreachableTypeHandlerCreator = unreachableTypeHandlerCreator;
            this.rootsProvider = rootsProvider;
            this.pendingEnumConstantRootStoringHandlers = pendingEnumConstantRootStoringHandlers;
        }

        private <T> void recursiveEnsureTypeHandlers(PersistenceTypeHandler<D, T> typeHandler) {
            typeHandler.iterateMemberTypes(t -> {
                PersistenceTypeHandler fieldTypeHandler = this.ensureTypeHandler((Class)t);
                fieldTypeHandler.guaranteeSubTypeInstanceViablity();
            });
        }

        private void validateTypeHandlerTypeId(PersistenceTypeHandler<D, ?> typeHandler) {
            if (Swizzling.isProperId((long)typeHandler.typeId())) {
                return;
            }
            throw new PersistenceExceptionTypeHandlerConsistency("Unassigned TypeId " + PersistenceTypeHandler.class.getSimpleName() + " " + typeHandler.typeName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void validateTypeHandler(PersistenceTypeHandler<D, ?> typeHandler) {
            PersistenceTypeDefinition registeredTd;
            this.validateTypeHandlerTypeId(typeHandler);
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                registeredTd = this.typeDictionaryManager.provideTypeDictionary().lookupTypeByName(typeHandler.typeName());
            }
            if (registeredTd == null) {
                return;
            }
            if (typeHandler.typeId() != registeredTd.typeId()) {
                throw new PersistenceExceptionTypeConsistency("TypeId inconsistency for " + typeHandler.typeName() + ": typeDictionary type definition typeId = " + registeredTd.typeId() + ", validated type handler typeId = " + typeHandler.typeId());
            }
            Equalator memberValidator = (m1, m2) -> {
                if (m1 == null || m2 == null) {
                    throw new PersistenceExceptionTypeConsistency("Member count mismatch of type " + typeHandler.typeName());
                }
                if (m1.equalsStructure((PersistenceTypeDescriptionMember)m2)) {
                    return true;
                }
                throw new PersistenceExceptionTypeConsistency("Inconsistent member in type description for type " + typeHandler.typeName() + ": " + m1 + " != " + m2);
            };
            if (!PersistenceTypeDescriptionMember.equalMembers(registeredTd.allMembers(), typeHandler.allMembers(), (Equalator<PersistenceTypeDescriptionMember>)memberValidator)) {
                throw new PersistenceExceptionTypeConsistency("Member inconsistency for " + typeHandler.typeName());
            }
        }

        @Override
        public final <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(T instance) {
            PersistenceTypeHandler<D, T> typeHandler = this.ensureTypeHandler(XReflect.getClass(instance));
            typeHandler.guaranteeSpecificInstanceViablity();
            return typeHandler;
        }

        @Override
        public PersistenceTypeDictionary typeDictionary() {
            return this.typeDictionaryManager.provideTypeDictionary();
        }

        @Override
        public final <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(Class<T> type) {
            PersistenceTypeHandler handler = this.typeHandlerRegistry.lookupTypeHandler(type);
            if (handler != null) {
                return handler;
            }
            return this.internalEnsureTypeHandler(type);
        }

        private <T> Class<T> validateExistingType(PersistenceTypeDefinition typeDefinition) {
            Class<?> runtimeType = typeDefinition.type();
            if (runtimeType != null) {
                return runtimeType;
            }
            throw new PersistenceException("Missing runtime type for required type handler for type: " + typeDefinition.runtimeTypeName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> PersistenceTypeHandler<D, T> checkForUnreachableType(PersistenceTypeDefinition typeDef) {
            if (typeDef.runtimeTypeName() != null) {
                return null;
            }
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                PersistenceTypeHandler<D, long> alreadyRegisteredTypeHandler = this.lookupTypeHandler((T)typeDef.typeId());
                if (alreadyRegisteredTypeHandler != null) {
                    PersistenceTypeHandler<D, long> casted = alreadyRegisteredTypeHandler;
                    return casted;
                }
                PersistenceUnreachableTypeHandler newHandler = this.unreachableTypeHandlerCreator.createUnreachableTypeHandler(typeDef);
                this.registerLegacyTypeHandler(newHandler);
                return newHandler;
            }
        }

        @Override
        public <T> PersistenceTypeHandler<D, ? super T> ensureTypeHandler(PersistenceTypeDefinition typeDefinition) {
            PersistenceTypeHandler<D, T> unreachableHandler = this.checkForUnreachableType(typeDefinition);
            if (unreachableHandler != null) {
                return unreachableHandler;
            }
            Class<T> runtimeType = this.validateExistingType(typeDefinition);
            PersistenceTypeHandler<D, T> runtimeTypeHandler = this.ensureTypeHandler(runtimeType);
            if (runtimeTypeHandler.typeId() == typeDefinition.typeId()) {
                return runtimeTypeHandler;
            }
            return this.ensureLegacyTypeHandler(typeDefinition, runtimeTypeHandler);
        }

        @Override
        public <T> PersistenceLegacyTypeHandler<D, ? super T> ensureLegacyTypeHandler(PersistenceTypeDefinition legacyTypeDefinition, PersistenceTypeHandler<D, ? super T> currentTypeHandler) {
            PersistenceLegacyTypeHandler<D, T> legacyTypeHandler = this.legacyTypeMapper.ensureLegacyTypeHandler(legacyTypeDefinition, currentTypeHandler);
            this.registerLegacyTypeHandler(legacyTypeHandler);
            logger.debug("registered legacy type handler for {} with id {}", (Object)legacyTypeHandler.typeName(), (Object)legacyTypeHandler.typeId());
            return legacyTypeHandler;
        }

        @Override
        public void ensureTypeHandlersByTypeIds(XGettingEnum<Long> typeIds) {
            HashEnum resolvedTypeDefinitions = HashEnum.New();
            this.typeDictionaryManager.provideTypeDictionary().resolveTypeIds((Iterable<Long>)typeIds, resolvedTypeDefinitions);
            this.ensureTypeHandlers((XGettingEnum<PersistenceTypeDefinition>)resolvedTypeDefinitions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ensureTypeHandlers(XGettingEnum<PersistenceTypeDefinition> typeDefinitions) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                typeDefinitions.iterate(typeDefinition -> this.ensureTypeHandler((PersistenceTypeDefinition)typeDefinition));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> PersistenceTypeHandler<D, ? super T> lookupTypeHandler(Class<T> type) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.lookupTypeHandler(type);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final PersistenceTypeHandler<D, ?> lookupTypeHandler(long typeId) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.lookupTypeHandler(typeId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> PersistenceTypeHandler<D, ? super T> lookupTypeHandler(T instance) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.lookupTypeHandler(XReflect.getClass(instance));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long lookupTypeId(Class<?> type) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.lookupTypeId(type);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <T> Class<T> lookupType(long typeId) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.lookupType(typeId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateTypeMapping(long typeId, Class<?> type) throws PersistenceExceptionConsistency {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.validateTypeMapping(typeId, type);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean validateTypeMappings(Iterable<? extends PersistenceTypeLink> mappings) throws PersistenceExceptionConsistency {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.validateTypeMappings(mappings);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean registerTypes(Iterable<? extends PersistenceTypeLink> types) throws PersistenceExceptionConsistency {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerRegistry.registerTypes(types);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> PersistenceTypeHandler<D, ? super T> internalEnsureTypeHandler(Class<T> type) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                PersistenceTypeHandler typeHandler;
                if (XReflect.isEnum(type) && !XReflect.isDeclaredEnum(type)) {
                    this.ensureTypeHandler(XReflect.getDeclaredEnumClass(type));
                }
                if ((typeHandler = this.typeHandlerRegistry.lookupTypeHandler(type)) == null) {
                    typeHandler = this.typeHandlerProvider.provideTypeHandler(type);
                    this.registerTypeHandler(type, typeHandler);
                }
                return typeHandler;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> boolean registerTypeHandler(Class<T> type, PersistenceTypeHandler<D, ? super T> typeHandler) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.validateTypeHandler(typeHandler);
                if (type == typeHandler.type()) {
                    if (this.synchUnvalidatedRegisterTypeHandler(typeHandler)) {
                        this.registerEnumContantRoots(typeHandler);
                        this.recursiveEnsureTypeHandlers(typeHandler);
                        return true;
                    }
                    return false;
                }
                return this.typeHandlerRegistry.registerTypeHandler(type, typeHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long registerTypeHandlers(Iterable<? extends PersistenceTypeHandler<D, ?>> typeHandlers) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.typeHandlerRegistry.validateTypeMappings(typeHandlers);
                return this.synchUnvalidatedRegisterTypeHandlers(typeHandlers);
            }
        }

        @Override
        public final <T> boolean registerTypeHandler(PersistenceTypeHandler<D, T> typeHandler) {
            return this.registerTypeHandler(typeHandler.type(), typeHandler);
        }

        private final long synchUnvalidatedRegisterTypeHandlers(Iterable<? extends PersistenceTypeHandler<D, ?>> typeHandlers) {
            long registrationCount = this.typeHandlerRegistry.registerTypeHandlers(typeHandlers);
            if (registrationCount > 0L) {
                this.typeDictionaryManager.registerRuntimeTypeDefinitions(typeHandlers);
            }
            return registrationCount;
        }

        private final boolean synchUnvalidatedRegisterTypeHandler(PersistenceTypeHandler<D, ?> typeHandler) {
            if (this.typeHandlerRegistry.registerTypeHandler(typeHandler)) {
                this.typeDictionaryManager.registerRuntimeTypeDefinition(typeHandler);
                return true;
            }
            return false;
        }

        private void initialRegisterTypeHandlers(XGettingCollection<PersistenceTypeHandler<D, ?>> initializedTypeHandlers) {
            this.registerTypeHandlers((Iterable<? extends PersistenceTypeHandler<D, ?>>)initializedTypeHandlers);
            for (PersistenceTypeHandler typeHandler : initializedTypeHandlers) {
                this.registerEnumContantRoots(typeHandler);
            }
            for (PersistenceTypeHandler typeHandler : initializedTypeHandlers) {
                this.recursiveEnsureTypeHandlers(typeHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkForPendingRootInstances() {
            if (this.pendingEnumConstantRootStoringHandlers.isEmpty()) {
                return;
            }
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                if (this.pendingEnumConstantRootStoringHandlers.isEmpty()) {
                    return;
                }
                PersistenceRoots existingRoots = this.rootsProvider.peekRoots();
                if (existingRoots == null) {
                    return;
                }
                EqHashTable modifiedRootEntries = EqHashTable.New(existingRoots.entries());
                boolean modified = false;
                for (PersistenceTypeHandler typeHandler : this.pendingEnumConstantRootStoringHandlers.values()) {
                    String enumRootIdentifier = this.deriveEnumRootIdentifier(typeHandler);
                    Object enumRootEntry = modifiedRootEntries.get((Object)enumRootIdentifier);
                    if (enumRootEntry != null) {
                        this.validateEnumInstances(enumRootEntry, typeHandler);
                        return;
                    }
                    Object[] enumRootEntries = this.collectEnumConstants(typeHandler);
                    if (enumRootEntries == null) {
                        throw new PersistenceException("Discarded enum constants cannot be registered as roots.");
                    }
                    modifiedRootEntries.add((Object)enumRootIdentifier, (Object)enumRootEntries);
                    modified = true;
                }
                if (modified) {
                    existingRoots.reinitializeEntries((XGettingTable<String, Object>)modifiedRootEntries);
                    this.pendingStoreRoot = existingRoots;
                }
            }
        }

        private void validateEnumInstances(Object existingEntry, PersistenceTypeHandler<D, ?> typeHandler) {
            if (!(existingEntry instanceof Object[])) {
                throw new PersistenceException("Invalid root instance of type " + existingEntry.getClass().getName() + " for enum type entry " + this.deriveEnumRootIdentifier(typeHandler) + " of type " + typeHandler.type().getName());
            }
            if (!XArrays.equals((Object[])((Object[])existingEntry), (Object[])typeHandler.type().getEnumConstants())) {
                throw new PersistenceException("Root entry already exists with inconsistent enum constants for enum type entry " + this.deriveEnumRootIdentifier(typeHandler) + " of type " + typeHandler.type().getName());
            }
        }

        @Override
        public void checkForPendingRootsStoring(PersistenceStoring storingCallback) {
            if (this.pendingStoreRoot == null) {
                return;
            }
            storingCallback.store(this.pendingStoreRoot);
        }

        @Override
        public void clearStorePendingRoots() {
            this.pendingEnumConstantRootStoringHandlers.clear();
            this.pendingStoreRoot = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerEnumContantRoots(PersistenceTypeHandler<D, ?> typeHandler) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                PersistenceTypeHandlerManager.registerEnumContantRoots(this.pendingEnumConstantRootStoringHandlers, typeHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean registerLegacyTypeHandler(PersistenceLegacyTypeHandler<D, ?> legacyTypeHandler) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.validateTypeHandlerTypeId(legacyTypeHandler);
                return this.typeHandlerRegistry.registerLegacyTypeHandler(legacyTypeHandler);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long ensureTypeId(Class<?> type) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                long typeId = this.typeHandlerRegistry.lookupTypeId(type);
                if (Swizzling.isFoundId((long)typeId)) {
                    return typeId;
                }
                return this.ensureTypeHandler(type).typeId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long currentTypeId() {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                return this.typeHandlerProvider.currentTypeId();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Class<?> ensureType(long typeId) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                Class type = this.typeHandlerRegistry.lookupType(typeId);
                if (type != null) {
                    return type;
                }
                return this.ensureTypeHandler(typeId).type();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean registerType(long tid, Class<?> type) throws PersistenceExceptionConsistency {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                if (this.typeHandlerRegistry.registerType(tid, type)) {
                    this.ensureTypeHandler(type);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateTypeHandlers(C iterator) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.typeHandlerRegistry.iterateTypeHandlers(iterator);
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super PersistenceLegacyTypeHandler<D, ?>>> C iterateLegacyTypeHandlers(C iterator) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.typeHandlerRegistry.iterateLegacyTypeHandlers(iterator);
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final synchronized PersistenceTypeHandlerManager<D> initialize() {
            logger.info("Initializing type handler manager");
            if (this.initialized) {
                return this;
            }
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.synchInternalInitialize();
            }
            return this;
        }

        private void synchInternalInitialize() {
            PersistenceTypeDictionary typeDictionary = this.typeDictionaryManager.provideTypeDictionary();
            HashEnum newTypeHandlers = HashEnum.New();
            HashEnum typeRegisteredTypeHandlers = HashEnum.New();
            if (typeDictionary.isEmpty()) {
                this.synchInitializeBlank(newTypeHandlers);
            } else {
                this.synchInitializeFromDictionary(typeDictionary, (HashEnum<PersistenceTypeHandler<D, ?>>)newTypeHandlers, (XAddingEnum<PersistenceTypeHandler<D, ?>>)typeRegisteredTypeHandlers);
            }
            this.synchInitializeNewTypeHandlers((XGettingCollection<PersistenceTypeHandler<D, ?>>)newTypeHandlers, (HashEnum<PersistenceTypeHandler<D, ?>>)typeRegisteredTypeHandlers);
            this.initialRegisterTypeHandlers((XGettingCollection<PersistenceTypeHandler<D, ?>>)typeRegisteredTypeHandlers);
            this.rootsProvider.provideRoots();
            this.checkForPendingRootInstances();
            this.clearStorePendingRoots();
            this.initialized = true;
        }

        private void synchTypeRegisterInitializedTypeHandlers(XGettingEnum<PersistenceTypeHandler<D, ?>> typeUnregisteredInitializedTypeHandlers, XAddingEnum<PersistenceTypeHandler<D, ?>> typeRegisteredInitializedTypeHandlers) {
            this.typeHandlerRegistry.registerTypes((Iterable<PersistenceTypeLink>)typeUnregisteredInitializedTypeHandlers);
            typeRegisteredInitializedTypeHandlers.addAll(typeUnregisteredInitializedTypeHandlers);
        }

        private void synchInitializeBlank(HashEnum<PersistenceTypeHandler<D, ?>> newTypeHandlers) {
            this.typeHandlerProvider.iterateTypeHandlers(newTypeHandlers);
        }

        private void synchInitializeFromDictionary(PersistenceTypeDictionary typeDictionary, HashEnum<PersistenceTypeHandler<D, ?>> newTypeHandlers, XAddingEnum<PersistenceTypeHandler<D, ?>> typeRegisteredTypeHandlers) {
            HashEnum initializedMatchingTypeHandlers = HashEnum.New();
            HashEnum runtimeTypeLineages = HashEnum.New();
            this.filterRuntimeTypeLineages(typeDictionary, (HashEnum<PersistenceTypeLineage>)runtimeTypeLineages);
            HashTable matches = HashTable.New();
            for (PersistenceTypeLineage typeLineage : runtimeTypeLineages) {
                this.synchDeriveRuntimeTypeHandler(typeLineage, matches, newTypeHandlers);
            }
            this.typeMismatchValidator.validateTypeMismatches(typeDictionary, (XGettingEnum<PersistenceTypeHandler<D, ?>>)newTypeHandlers);
            this.internalUpdateCurrentHighestTypeId(typeDictionary);
            for (KeyValue match : matches) {
                long typeId = ((PersistenceTypeDefinition)match.key()).typeId();
                PersistenceTypeHandler ith = ((PersistenceTypeHandler)match.value()).initialize(typeId);
                initializedMatchingTypeHandlers.add(ith);
            }
            this.synchTypeRegisterInitializedTypeHandlers((XGettingEnum<PersistenceTypeHandler<D, ?>>)initializedMatchingTypeHandlers, typeRegisteredTypeHandlers);
        }

        private void synchInitializeNewTypeHandlers(XGettingCollection<PersistenceTypeHandler<D, ?>> newTypeHandlers, HashEnum<PersistenceTypeHandler<D, ?>> typeRegisteredTypeHandlers) {
            HashEnum initializedNewTypeHandlers = HashEnum.New();
            for (PersistenceTypeHandler newTypeHandler : newTypeHandlers) {
                PersistenceTypeHandler<D, ?> ith = this.synchEnsureInitializedTypeHandler(newTypeHandler);
                initializedNewTypeHandlers.add(ith);
            }
            this.synchTypeRegisterInitializedTypeHandlers((XGettingEnum<PersistenceTypeHandler<D, ?>>)initializedNewTypeHandlers, (XAddingEnum<PersistenceTypeHandler<D, ?>>)typeRegisteredTypeHandlers);
        }

        private PersistenceTypeHandler<D, ?> synchEnsureInitializedTypeHandler(PersistenceTypeHandler<D, ?> typeHandler) {
            if (Swizzling.isProperId((long)typeHandler.typeId())) {
                return typeHandler;
            }
            long newTypeId = this.typeHandlerProvider.ensureTypeId(typeHandler.type());
            return typeHandler.initialize(newTypeId);
        }

        private void filterRuntimeTypeLineages(PersistenceTypeDictionary typeDictionary, HashEnum<PersistenceTypeLineage> runtimeTypeLineages) {
            typeDictionary.iterateTypeLineages(td -> {
                if (td.type() != null) {
                    runtimeTypeLineages.add(td);
                }
            });
        }

        private <T> void synchDeriveRuntimeTypeHandler(PersistenceTypeLineage typeLineage, HashTable<PersistenceTypeDefinition, PersistenceTypeHandler<D, ?>> matchedTypeHandlers, HashEnum<PersistenceTypeHandler<D, ?>> unmatchableTypeHandlers) {
            Class<?> runtimeType = typeLineage.type();
            if (runtimeType == null) {
                return;
            }
            PersistenceTypeHandler<D, ?> handler = this.synchAdvanceEnsureTypeHandler(runtimeType);
            for (PersistenceTypeDefinition typeDefinition : typeLineage.entries().values()) {
                boolean isMatched = PersistenceTypeDescriptionMember.equalStructures(handler.allMembers(), typeDefinition.allMembers());
                if (!isMatched) continue;
                matchedTypeHandlers.add((Object)typeDefinition, handler);
                return;
            }
            unmatchableTypeHandlers.add(handler);
        }

        private <T> PersistenceTypeHandler<D, ? super T> synchAdvanceEnsureTypeHandler(Class<T> type) {
            PersistenceTypeHandler handler = this.typeHandlerRegistry.lookupTypeHandler(type);
            if (handler == null) {
                handler = this.typeHandlerProvider.ensureTypeHandler(type);
            }
            return handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateCurrentHighestTypeId(long highestTypeId) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.typeHandlerProvider.updateCurrentHighestTypeId(highestTypeId);
            }
        }

        final void internalUpdateCurrentHighestTypeId(PersistenceTypeDictionary typeDictionary) {
            this.internalUpdateCurrentHighestTypeId(typeDictionary.determineHighestTypeId());
        }

        final void internalUpdateCurrentHighestTypeId(PersistenceTypeDictionary typeDictionary, long highestTypeId) {
            long effectiveHighestTypeId = Math.max(typeDictionary.determineHighestTypeId(), highestTypeId);
            this.updateCurrentHighestTypeId(effectiveHighestTypeId);
        }

        final void internalUpdateCurrentHighestTypeId(long highestTypeId) {
            if (this.currentTypeId() < highestTypeId) {
                this.updateCurrentHighestTypeId(highestTypeId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(PersistenceTypeDictionary typeDictionary, long highestTypeId) {
            PersistenceTypeHandlerRegistry<D> persistenceTypeHandlerRegistry = this.typeHandlerRegistry;
            synchronized (persistenceTypeHandlerRegistry) {
                this.typeDictionaryManager.validateTypeDefinitions((Iterable<? extends PersistenceTypeDefinition>)typeDictionary.allTypeDefinitions().values());
                this.internalUpdateCurrentHighestTypeId(typeDictionary, highestTypeId);
                this.typeDictionaryManager.registerTypeDefinitions((Iterable<? extends PersistenceTypeDefinition>)typeDictionary.allTypeDefinitions().values());
            }
        }

        @Override
        public void iteratePerIds(BiConsumer<Long, ? super Class<?>> consumer) {
            this.typeHandlerRegistry.iteratePerIds(consumer);
        }
    }
}

