/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.HashMapIdObject;
import one.microstream.collections.MiniMap;
import one.microstream.persistence.exceptions.PersistenceExceptionConsistency;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeHandlerConsistencyConflictedType;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeHandlerConsistencyConflictedTypeId;
import one.microstream.persistence.types.PersistenceLegacyTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerIterable;
import one.microstream.persistence.types.PersistenceTypeHandlerLookup;
import one.microstream.persistence.types.PersistenceTypeLink;
import one.microstream.persistence.types.PersistenceTypeRegistry;
import one.microstream.reflect.XReflect;

public interface PersistenceTypeHandlerRegistry<D>
extends PersistenceTypeHandlerLookup<D>,
PersistenceTypeRegistry,
PersistenceTypeHandlerIterable<D> {
    public <T> boolean registerTypeHandler(PersistenceTypeHandler<D, T> var1);

    public long registerTypeHandlers(Iterable<? extends PersistenceTypeHandler<D, ?>> var1);

    public <T> boolean registerTypeHandler(Class<T> var1, PersistenceTypeHandler<D, ? super T> var2);

    public boolean registerLegacyTypeHandler(PersistenceLegacyTypeHandler<D, ?> var1);

    public static <D> Default<D> New(PersistenceTypeRegistry typeRegistry) {
        return new Default((PersistenceTypeRegistry)X.notNull((Object)typeRegistry));
    }

    public static final class Default<D>
    implements PersistenceTypeHandlerRegistry<D> {
        private final PersistenceTypeRegistry typeRegistry;
        private final MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> handlersByType = new MiniMap();
        private final HashMapIdObject<PersistenceTypeHandler<D, ?>> handlersByTypeId = HashMapIdObject.New();

        Default(PersistenceTypeRegistry typeRegistry) {
            this.typeRegistry = typeRegistry;
        }

        @Override
        public long lookupTypeId(Class<?> type) {
            return this.typeRegistry.lookupTypeId(type);
        }

        @Override
        public <T> Class<T> lookupType(long typeId) {
            return this.typeRegistry.lookupType(typeId);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> lookupTypeHandler(Class<T> type) {
            return (PersistenceTypeHandler)this.handlersByType.get(type);
        }

        @Override
        public PersistenceTypeHandler<D, ?> lookupTypeHandler(long typeId) {
            return (PersistenceTypeHandler)this.handlersByTypeId.get(typeId);
        }

        @Override
        public <T> PersistenceTypeHandler<D, T> lookupTypeHandler(T instance) {
            return this.lookupTypeHandler((T)XReflect.getClass(instance));
        }

        @Override
        public boolean validateTypeMapping(long typeId, Class<?> type) throws PersistenceExceptionConsistency {
            return this.typeRegistry.validateTypeMapping(typeId, type);
        }

        @Override
        public boolean validateTypeMappings(Iterable<? extends PersistenceTypeLink> mappings) throws PersistenceExceptionConsistency {
            return this.typeRegistry.validateTypeMappings(mappings);
        }

        @Override
        public boolean registerType(long tid, Class<?> type) throws PersistenceExceptionConsistency {
            return this.typeRegistry.registerType(tid, type);
        }

        @Override
        public boolean registerTypes(Iterable<? extends PersistenceTypeLink> types) throws PersistenceExceptionConsistency {
            return this.typeRegistry.registerTypes(types);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> boolean registerTypeHandler(Class<T> type, PersistenceTypeHandler<D, ? super T> typeHandler) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                if (this.synchValidateAlreadyRegisteredTypeHandler(type, typeHandler)) {
                    return true;
                }
                this.registerTypeHandler(typeHandler);
                this.synchPutTypeMapping(type, typeHandler);
                return true;
            }
        }

        private <T> boolean synchValidateAlreadyRegisteredTypeHandler(Class<T> type, PersistenceTypeHandler<D, ? super T> typeHandler) {
            PersistenceTypeHandler actualHandler = (PersistenceTypeHandler)this.handlersByType.get(type);
            if (actualHandler == null) {
                return false;
            }
            if (actualHandler == typeHandler) {
                return true;
            }
            throw new PersistenceExceptionTypeHandlerConsistencyConflictedType(type, actualHandler, typeHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> boolean registerTypeHandler(PersistenceTypeHandler<D, T> typeHandler) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                Class<T> type = typeHandler.type();
                long tid = typeHandler.typeId();
                this.typeRegistry.registerType(tid, type);
                this.synchValidateAlreadyRegisteredTypeHandler(type, typeHandler);
                if (this.synchCheckByTypeId(typeHandler)) {
                    return false;
                }
                this.synchPutFullMapping(typeHandler);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long registerTypeHandlers(Iterable<? extends PersistenceTypeHandler<D, ?>> typeHandlers) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                long registeredCount = 0L;
                for (PersistenceTypeHandler<D, ?> handler : typeHandlers) {
                    if (!this.registerTypeHandler(handler)) continue;
                    ++registeredCount;
                }
                return registeredCount;
            }
        }

        private <T> void synchPutTypeMapping(Class<T> type, PersistenceTypeHandler<D, ? super T> typeHandler) {
            this.handlersByType.put(type, typeHandler);
        }

        private <T> void synchPutFullMapping(PersistenceTypeHandler<D, T> typeHandler) {
            this.synchPutTypeMapping(typeHandler.type(), typeHandler);
            this.handlersByTypeId.put(typeHandler.typeId(), typeHandler);
        }

        private boolean synchCheckByTypeId(PersistenceTypeHandler<D, ?> typeHandler) {
            PersistenceTypeHandler actualHandler = (PersistenceTypeHandler)this.handlersByTypeId.get(typeHandler.typeId());
            if (actualHandler != null) {
                if (actualHandler != typeHandler) {
                    throw new PersistenceExceptionTypeHandlerConsistencyConflictedTypeId(typeHandler.typeId(), actualHandler, typeHandler);
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean registerLegacyTypeHandler(PersistenceLegacyTypeHandler<D, ?> legacyTypeHandler) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                if (this.synchCheckByTypeId(legacyTypeHandler)) {
                    return false;
                }
                this.handlersByTypeId.put(legacyTypeHandler.typeId(), legacyTypeHandler);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                this.handlersByType.clear();
                this.handlersByTypeId.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateTypeHandlers(C iterator) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                this.handlersByType.iterateValues(iterator);
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super PersistenceLegacyTypeHandler<D, ?>>> C iterateLegacyTypeHandlers(C iterator) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                this.handlersByTypeId.iterateValues(th -> {
                    if (th instanceof PersistenceLegacyTypeHandler) {
                        iterator.accept((PersistenceLegacyTypeHandler)th);
                    }
                });
            }
            return iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C extends Consumer<? super PersistenceTypeHandler<D, ?>>> C iterateAllTypeHandlers(C iterator) {
            MiniMap<Class<?>, PersistenceTypeHandler<D, ?>> miniMap = this.handlersByType;
            synchronized (miniMap) {
                this.handlersByTypeId.iterateValues(iterator);
            }
            return iterator;
        }

        @Override
        public void iteratePerIds(BiConsumer<Long, ? super Class<?>> consumer) {
            this.typeRegistry.iteratePerIds(consumer);
        }
    }
}

