/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.persistence.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.chars.XParsing;
import one.microstream.collections.types.XReference;
import one.microstream.exceptions.ParsingException;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceIdStrategyStringConverter;
import one.microstream.persistence.types.PersistenceTypeIdProvider;

public interface PersistenceTypeIdStrategy {
    public PersistenceTypeIdProvider createTypeIdProvider();

    public String strategyTypeNameTypeId();

    public static Transient Transient() {
        return new Transient(Persistence.defaultStartTypeId());
    }

    public static Transient Transient(long startingTypeId) {
        return new Transient(Persistence.validateTypeId(startingTypeId));
    }

    public static None None() {
        return new None();
    }

    @FunctionalInterface
    public static interface Parser<S extends PersistenceTypeIdStrategy> {
        public S parse(String var1);
    }

    @FunctionalInterface
    public static interface Assembler<S extends PersistenceTypeIdStrategy> {
        public void assembleIdStrategy(VarString var1, S var2);
    }

    public static final class None
    implements PersistenceTypeIdStrategy {
        public static String typeName() {
            return "None";
        }

        public static void assemble(VarString vs, None idStrategy) {
            vs.add(None.typeName());
        }

        public static None parse(String typeIdStrategyContent) throws ParsingException {
            PersistenceIdStrategyStringConverter.validateIdStrategyName(None.class, None.typeName(), typeIdStrategyContent);
            return PersistenceTypeIdStrategy.None();
        }

        None() {
        }

        @Override
        public String strategyTypeNameTypeId() {
            return None.typeName();
        }

        @Override
        public final PersistenceTypeIdProvider createTypeIdProvider() {
            return PersistenceTypeIdProvider.Failing();
        }
    }

    public static final class Transient
    implements PersistenceTypeIdStrategy {
        private final long startingTypeId;

        public static String typeName() {
            return "Transient";
        }

        public static void assemble(VarString vs, Transient idStrategy) {
            vs.add(Transient.typeName()).add(Transient.openingCharacter()).add(idStrategy.startingTypeId()).add(Transient.closingCharacter());
        }

        public static char openingCharacter() {
            return '(';
        }

        public static char closingCharacter() {
            return ')';
        }

        public static Transient parse(String typeIdStrategyContent) {
            PersistenceIdStrategyStringConverter.validateIdStrategyName(Transient.class, Transient.typeName(), typeIdStrategyContent);
            char[] input = XChars.readChars((String)typeIdStrategyContent);
            int iBound = input.length;
            XReference valueString = X.Reference(null);
            int i = Transient.typeName().length();
            i = XParsing.skipWhiteSpaces((char[])input, (int)i, (int)iBound);
            i = XParsing.checkCharacter((char[])input, (int)i, (char)Transient.openingCharacter(), (String)Transient.typeName());
            i = XParsing.parseToSimpleTerminator((char[])input, (int)i, (int)iBound, (char)Transient.closingCharacter(), (Consumer)valueString);
            i = XParsing.skipWhiteSpaces((char[])input, (int)i, (int)iBound);
            if (i != iBound) {
                throw new ParsingException("Invalid trailing content at index " + i);
            }
            return ((String)valueString.get()).isEmpty() ? PersistenceTypeIdStrategy.Transient() : PersistenceTypeIdStrategy.Transient(Long.parseLong((String)valueString.get()));
        }

        Transient(long startingTypeId) {
            this.startingTypeId = startingTypeId;
        }

        public final long startingTypeId() {
            return this.startingTypeId;
        }

        @Override
        public String strategyTypeNameTypeId() {
            return Transient.typeName();
        }

        @Override
        public final PersistenceTypeIdProvider createTypeIdProvider() {
            return PersistenceTypeIdProvider.Transient(this.startingTypeId);
        }
    }
}

