/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.storage.configuration.Configuration;
import one.microstream.storage.configuration.ConfigurationPropertyParser;
import one.microstream.storage.configuration.InvalidStorageConfigurationException;
import one.microstream.storage.configuration.StorageConfigurationIoException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Deprecated
@FunctionalInterface
public interface ConfigurationParser {
    default public Configuration parse(String data) {
        return this.parse(Configuration.Default(), data);
    }

    public Configuration parse(Configuration var1, String var2);

    public static ConfigurationParser Ini() {
        return ConfigurationParser.Ini(ConfigurationPropertyParser.New());
    }

    public static ConfigurationParser Ini(ConfigurationPropertyParser propertyParser) {
        return new IniConfigurationParser((ConfigurationPropertyParser)X.notNull((Object)propertyParser));
    }

    public static ConfigurationParser Xml() {
        return ConfigurationParser.Xml(ConfigurationPropertyParser.New());
    }

    public static ConfigurationParser Xml(ConfigurationPropertyParser propertyParser) {
        return new XmlConfigurationParser((ConfigurationPropertyParser)X.notNull((Object)propertyParser));
    }

    public static class IniConfigurationParser
    implements ConfigurationParser {
        private final ConfigurationPropertyParser propertyParser;

        IniConfigurationParser(ConfigurationPropertyParser propertyParser) {
            this.propertyParser = propertyParser;
        }

        @Override
        public Configuration parse(Configuration configuration, String data) {
            HashMap<String, String> properties = new HashMap<String, String>();
            String[] stringArray = data.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim()).isEmpty()) {
                    switch (line.charAt(0)) {
                        case '#': 
                        case ';': 
                        case '[': {
                            break;
                        }
                        default: {
                            int separatorIndex = line.indexOf(61);
                            if (separatorIndex == -1) break;
                            String name = line.substring(0, separatorIndex).trim();
                            String value = line.substring(separatorIndex + 1).trim();
                            properties.put(name, value);
                        }
                    }
                }
                ++n2;
            }
            this.propertyParser.parseProperties(properties, configuration);
            return configuration;
        }
    }

    public static class XmlConfigurationParser
    implements ConfigurationParser {
        private final ConfigurationPropertyParser propertyParser;

        XmlConfigurationParser(ConfigurationPropertyParser propertyParser) {
            this.propertyParser = propertyParser;
        }

        @Override
        public Configuration parse(Configuration configuration, String data) {
            try {
                HashMap<String, String> properties = new HashMap<String, String>();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                Document document = factory.newDocumentBuilder().parse(new InputSource(new StringReader(data)));
                Element documentElement = document.getDocumentElement();
                if (documentElement != null) {
                    NodeList propertyNodes = documentElement.getElementsByTagName("property");
                    int i = 0;
                    int c = propertyNodes.getLength();
                    while (i < c) {
                        Element propertyElement = (Element)propertyNodes.item(i);
                        String name = (String)XChars.notEmpty((CharSequence)propertyElement.getAttribute("name").trim());
                        String value = (String)XChars.notEmpty((CharSequence)propertyElement.getAttribute("value").trim());
                        properties.put(name, value);
                        ++i;
                    }
                }
                this.propertyParser.parseProperties(properties, configuration);
            }
            catch (ParserConfigurationException | SAXException e) {
                throw new InvalidStorageConfigurationException(e);
            }
            catch (IOException e) {
                throw new StorageConfigurationIoException(e);
            }
            return configuration;
        }
    }
}

