/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import one.microstream.X;
import one.microstream.storage.configuration.ByteSizeAssembler;
import one.microstream.storage.configuration.Configuration;
import one.microstream.storage.configuration.ConfigurationPropertyNames;
import one.microstream.storage.configuration.DurationAssembler;
import one.microstream.storage.configuration.InvalidStorageConfigurationException;

@Deprecated
public interface ConfigurationPropertyAssembler {
    public Map<String, String> assemble(Configuration var1);

    public static ConfigurationPropertyAssembler New() {
        return new Default(DurationAssembler.Default(), ByteSizeAssembler.Default());
    }

    public static ConfigurationPropertyAssembler New(DurationAssembler durationParser, ByteSizeAssembler fileSizeParser) {
        return new Default((DurationAssembler)X.notNull((Object)durationParser), (ByteSizeAssembler)X.notNull((Object)fileSizeParser));
    }

    public static class Default
    implements ConfigurationPropertyAssembler,
    ConfigurationPropertyNames {
        private final DurationAssembler durationAssembler;
        private final ByteSizeAssembler fileSizeAssembler;

        Default(DurationAssembler durationAssembler, ByteSizeAssembler fileSizeAssembler) {
            this.durationAssembler = durationAssembler;
            this.fileSizeAssembler = fileSizeAssembler;
        }

        @Override
        public Map<String, String> assemble(Configuration configuration) {
            HashMap<String, String> map = new HashMap<String, String>();
            Configuration defaults = Configuration.Default();
            this.optPutProperty(map, "baseDirectory", configuration.getBaseDirectory(), defaults.getBaseDirectory());
            this.optPutProperty(map, "deletionDirectory", configuration.getDeletionDirectory(), defaults.getDeletionDirectory());
            this.optPutProperty(map, "truncationDirectory", configuration.getTruncationDirectory(), defaults.getTruncationDirectory());
            this.optPutProperty(map, "backupDirectory", configuration.getBackupDirectory(), defaults.getBackupDirectory());
            this.optPutProperty(map, "channelDirectoryPrefix", configuration.getChannelDirectoryPrefix(), defaults.getChannelDirectoryPrefix());
            this.optPutProperty(map, "dataFilePrefix", configuration.getDataFilePrefix(), defaults.getDataFilePrefix());
            this.optPutProperty(map, "dataFileSuffix", configuration.getDataFileSuffix(), defaults.getDataFileSuffix());
            this.optPutProperty(map, "transactionFilePrefix", configuration.getTransactionFilePrefix(), defaults.getTransactionFilePrefix());
            this.optPutProperty(map, "transactionFileSuffix", configuration.getTransactionFileSuffix(), defaults.getTransactionFileSuffix());
            this.optPutProperty(map, "typeDictionaryFilename", configuration.getTypeDictionaryFilename(), defaults.getTypeDictionaryFilename());
            this.optPutProperty(map, "channelCount", configuration.getChannelCount(), defaults.getChannelCount());
            this.optPutProperty(map, "housekeepingIntervalMs", configuration.getHousekeepingIntervalMs(), defaults.getHousekeepingIntervalMs());
            this.optPutProperty(map, "housekeepingTimeBudgetNs", configuration.getHousekeepingTimeBudgetNs(), defaults.getHousekeepingTimeBudgetNs());
            this.optPutProperty(map, "entityCacheTimeoutMs", configuration.getEntityCacheTimeoutMs(), defaults.getEntityCacheTimeoutMs());
            this.optPutProperty(map, "entityCacheThreshold", configuration.getEntityCacheThreshold(), defaults.getEntityCacheThreshold());
            this.optPutProperty(map, "dataFileMinimumSize", configuration.getDataFileMinimumSize(), defaults.getDataFileMinimumSize());
            this.optPutProperty(map, "dataFileMaximumSize", configuration.getDataFileMaximumSize(), defaults.getDataFileMaximumSize());
            this.optPutProperty(map, "dataFileMinimumUseRatio", configuration.getDataFileMinimumUseRatio(), defaults.getDataFileMinimumUseRatio());
            this.optPutProperty(map, "dataFileCleanupHeadFile", configuration.getDataFileCleanupHeadFile(), defaults.getDataFileCleanupHeadFile());
            return map;
        }

        protected <T> void optPutProperty(Map<String, String> map, String key, T value, T defaultValue) {
            if (value != null && !value.equals(defaultValue)) {
                map.put(key, this.toStringValue(key, value));
            }
        }

        protected String toStringValue(String key, Object value) {
            switch (key) {
                case "deletionDirectory": 
                case "backupDirectory": 
                case "baseDirectory": 
                case "dataFileMinimumUseRatio": 
                case "truncationDirectory": 
                case "channelDirectoryPrefix": 
                case "channelCount": 
                case "transactionFilePrefix": 
                case "transactionFileSuffix": 
                case "typeDictionaryFilename": 
                case "dataFilePrefix": 
                case "dataFileCleanupHeadFile": 
                case "dataFileSuffix": {
                    return value.toString();
                }
                case "housekeepingIntervalMs": 
                case "entityCacheTimeoutMs": {
                    return this.durationAssembler.assemble(Duration.ofMillis(((Number)value).longValue()));
                }
                case "housekeepingTimeBudgetNs": {
                    return this.durationAssembler.assemble(Duration.ofNanos(((Number)value).longValue()));
                }
                case "entityCacheThreshold": 
                case "dataFileMinimumSize": 
                case "dataFileMaximumSize": {
                    return this.fileSizeAssembler.assemble(((Number)value).longValue());
                }
            }
            throw new InvalidStorageConfigurationException("Unsupported property: " + key);
        }
    }
}

