/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.util.Map;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.configuration.types.ByteSizeParser;
import one.microstream.configuration.types.DurationParser;
import one.microstream.configuration.types.DurationUnit;
import one.microstream.storage.configuration.Configuration;
import one.microstream.storage.configuration.ConfigurationPropertyNames;
import one.microstream.storage.configuration.InvalidStorageConfigurationException;

@Deprecated
@FunctionalInterface
public interface ConfigurationPropertyParser {
    public void parseProperties(Map<String, String> var1, Configuration var2);

    public static ConfigurationPropertyParser New() {
        return new Default(DurationParser.New((DurationUnit)DurationUnit.MS), DurationParser.New((DurationUnit)DurationUnit.NS), ByteSizeParser.New());
    }

    public static ConfigurationPropertyParser New(DurationParser durationParserMs, DurationParser durationParserNs, ByteSizeParser byteSizeParser) {
        return new Default((DurationParser)X.notNull((Object)durationParserMs), (DurationParser)X.notNull((Object)durationParserNs), (ByteSizeParser)X.notNull((Object)byteSizeParser));
    }

    public static class Default
    implements ConfigurationPropertyParser,
    ConfigurationPropertyNames {
        private final DurationParser durationParserMs;
        private final DurationParser durationParserNs;
        private final ByteSizeParser byteSizeParser;

        Default(DurationParser durationParserMs, DurationParser durationParserNs, ByteSizeParser byteSizeParser) {
            this.durationParserMs = durationParserMs;
            this.durationParserNs = durationParserNs;
            this.byteSizeParser = byteSizeParser;
        }

        @Override
        public void parseProperties(Map<String, String> properties, Configuration configuration) {
            properties.entrySet().forEach(kv -> this.parseProperty((String)kv.getKey(), (String)kv.getValue(), configuration));
        }

        protected void parseProperty(String name, String value, Configuration configuration) {
            X.notNull((Object)value);
            try {
                switch ((String)XChars.notEmpty((CharSequence)name)) {
                    case "baseDirectory": {
                        this.parseDirectoryPath(value, configuration::setBaseDirectory, configuration::setBaseDirectoryInUserHome);
                        break;
                    }
                    case "deletionDirectory": {
                        configuration.setDeletionDirectory((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "truncationDirectory": {
                        configuration.setTruncationDirectory((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "backupDirectory": {
                        this.parseDirectoryPath(value, configuration::setBackupDirectory, configuration::setBackupDirectoryInUserHome);
                        break;
                    }
                    case "channelCount": {
                        configuration.setChannelCount(Integer.parseInt(value));
                        break;
                    }
                    case "channelDirectoryPrefix": {
                        configuration.setChannelDirectoryPrefix((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "dataFilePrefix": {
                        configuration.setDataFilePrefix((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "dataFileSuffix": {
                        configuration.setDataFileSuffix((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "transactionFilePrefix": {
                        configuration.setTransactionFilePrefix((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "transactionFileSuffix": {
                        configuration.setTransactionFileSuffix((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "typeDictionaryFilename": {
                        configuration.setTypeDictionaryFilename((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "rescuedFileSuffix": {
                        configuration.setRescuedFileSuffix((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "lockFileName": {
                        configuration.setLockFileName((String)XChars.notEmpty((CharSequence)value));
                        break;
                    }
                    case "housekeepingIntervalMs": 
                    case "houseKeepingInterval": {
                        configuration.setHousekeepingIntervalMs(this.durationParserMs.parse(value).toMillis());
                        break;
                    }
                    case "houseKeepingNanoTimeBudget": 
                    case "housekeepingTimeBudgetNs": {
                        configuration.setHousekeepingTimeBudgetNs(this.durationParserNs.parse(value).toNanos());
                        break;
                    }
                    case "entityCacheThreshold": {
                        configuration.setEntityCacheThreshold(this.byteSizeParser.parse(value).bytes());
                        break;
                    }
                    case "entityCacheTimeout": 
                    case "entityCacheTimeoutMs": {
                        configuration.setEntityCacheTimeoutMs(this.durationParserMs.parse(value).toMillis());
                        break;
                    }
                    case "dataFileMinSize": 
                    case "dataFileMinimumSize": {
                        configuration.setDataFileMinimumSize(this.parseFileSize_int(value));
                        break;
                    }
                    case "dataFileMaxSize": 
                    case "dataFileMaximumSize": {
                        configuration.setDataFileMaximumSize(this.parseFileSize_int(value));
                        break;
                    }
                    case "dataFileMinimumUseRatio": 
                    case "dataFileDissolveRatio": {
                        configuration.setDataFileMinimumUseRatio(Double.parseDouble(value));
                        break;
                    }
                    case "dataFileCleanupHeadFile": {
                        configuration.setDataFileCleanupHeadFile(Boolean.parseBoolean(value));
                        break;
                    }
                    default: {
                        throw new InvalidStorageConfigurationException("Unsupported property: " + name);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new InvalidStorageConfigurationException("Invalid value for property " + name + ": " + value, nfe);
            }
        }

        protected void parseDirectoryPath(String value, Consumer<String> defaultPathConsumer, Consumer<String> userHomePathConsumer) {
            if (value.startsWith("~/") || value.startsWith("~\\")) {
                String directoryInUserHome = value.substring(2);
                userHomePathConsumer.accept(directoryInUserHome);
            } else {
                defaultPathConsumer.accept((String)XChars.notEmpty((CharSequence)value));
            }
        }

        protected int parseFileSize_int(String value) {
            long fileSize = this.byteSizeParser.parse(value).bytes();
            if (fileSize > Integer.MAX_VALUE) {
                throw new InvalidStorageConfigurationException("Invalid file size: " + value);
            }
            return (int)fileSize;
        }
    }
}

