/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import one.microstream.afs.nio.types.NioFileSystem;
import one.microstream.afs.types.AFileSystem;
import one.microstream.chars.XChars;
import one.microstream.io.XIO;
import one.microstream.storage.configuration.Configuration;
import one.microstream.storage.embedded.types.EmbeddedStorage;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageFileNameProvider;
import one.microstream.storage.types.StorageFileProvider;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageLiveFileProvider;

@Deprecated
@FunctionalInterface
public interface EmbeddedStorageFoundationCreator {
    public EmbeddedStorageFoundation<?> createFoundation(Configuration var1);

    public static EmbeddedStorageFoundationCreator New() {
        return new Default();
    }

    public static class Default
    implements EmbeddedStorageFoundationCreator {
        Default() {
        }

        @Override
        public EmbeddedStorageFoundation<?> createFoundation(Configuration configuration) {
            Path baseDirectory = XIO.unchecked.ensureDirectory((Path)XIO.Path((String)configuration.getBaseDirectory()));
            StorageConfiguration.Builder configBuilder = Storage.ConfigurationBuilder().setStorageFileProvider(this.createFileProvider(configuration, baseDirectory)).setChannelCountProvider(this.createChannelCountProvider(configuration)).setHousekeepingController(this.createHousekeepingController(configuration)).setDataFileEvaluator(this.createDataFileEvaluator(configuration)).setEntityCacheEvaluator(this.createEntityCacheEvaluator(configuration));
            Optional.ofNullable(configuration.getBackupDirectory()).filter(backupDirectory -> !XChars.isEmpty((CharSequence)backupDirectory)).ifPresent(backupDirectory -> {
                StorageConfiguration.Builder builder2 = configBuilder.setBackupSetup(Storage.BackupSetup((String)backupDirectory));
            });
            return EmbeddedStorage.Foundation((StorageConfiguration)configBuilder.createConfiguration());
        }

        protected StorageLiveFileProvider createFileProvider(Configuration configuration, Path baseDirectory) {
            StorageFileNameProvider fileNameProvider = StorageFileNameProvider.New((String)configuration.getChannelDirectoryPrefix(), (String)configuration.getDataFilePrefix(), (String)configuration.getDataFileSuffix(), (String)configuration.getTransactionFilePrefix(), (String)configuration.getTransactionFileSuffix(), (String)configuration.getRescuedFileSuffix(), (String)configuration.getTypeDictionaryFilename(), (String)configuration.getLockFileName());
            NioFileSystem fileSystem = NioFileSystem.New();
            StorageLiveFileProvider.Builder builder = (StorageLiveFileProvider.Builder)((StorageLiveFileProvider.Builder)Storage.FileProviderBuilder((AFileSystem)fileSystem).setDirectory(fileSystem.ensureDirectory((Object)baseDirectory))).setFileNameProvider(fileNameProvider);
            Optional.ofNullable(configuration.getDeletionDirectory()).filter(deletionDirectory -> !XChars.isEmpty((CharSequence)deletionDirectory)).ifPresent(deletionDirectory -> {
                StorageFileProvider.Builder builder2 = builder.setDeletionDirectory(fileSystem.ensureDirectory((Object)Paths.get(deletionDirectory, new String[0])));
            });
            Optional.ofNullable(configuration.getTruncationDirectory()).filter(truncationDirectory -> !XChars.isEmpty((CharSequence)truncationDirectory)).ifPresent(truncationDirectory -> {
                StorageFileProvider.Builder builder2 = builder.setTruncationDirectory(fileSystem.ensureDirectory((Object)Paths.get(truncationDirectory, new String[0])));
            });
            return builder.createFileProvider();
        }

        protected StorageChannelCountProvider createChannelCountProvider(Configuration configuration) {
            return Storage.ChannelCountProvider((int)configuration.getChannelCount());
        }

        protected StorageHousekeepingController createHousekeepingController(Configuration configuration) {
            return Storage.HousekeepingController((long)configuration.getHousekeepingIntervalMs(), (long)configuration.getHousekeepingTimeBudgetNs());
        }

        protected StorageDataFileEvaluator createDataFileEvaluator(Configuration configuration) {
            return Storage.DataFileEvaluator((int)configuration.getDataFileMinimumSize(), (int)configuration.getDataFileMaximumSize(), (double)configuration.getDataFileMinimumUseRatio(), (boolean)configuration.getDataFileCleanupHeadFile());
        }

        protected StorageEntityCacheEvaluator createEntityCacheEvaluator(Configuration configuration) {
            return Storage.EntityCacheEvaluator((long)configuration.getEntityCacheTimeoutMs(), (long)configuration.getEntityCacheThreshold());
        }
    }
}

