/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import one.microstream.X;
import one.microstream.chars.ObjectStringAssembler;
import one.microstream.chars.VarString;
import one.microstream.storage.configuration.Configuration;
import one.microstream.storage.configuration.ConfigurationPropertyAssembler;
import one.microstream.storage.configuration.StorageConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Deprecated
public interface ConfigurationAssembler
extends ObjectStringAssembler<Configuration> {
    public VarString assemble(VarString var1, Configuration var2);

    default public String assemble(Configuration configuration) {
        return super.assemble((Object)configuration);
    }

    public static ConfigurationAssembler Ini() {
        return new IniConfigurationAssembler(ConfigurationPropertyAssembler.New());
    }

    public static ConfigurationAssembler Ini(ConfigurationPropertyAssembler propertyAssembler) {
        return new IniConfigurationAssembler((ConfigurationPropertyAssembler)X.notNull((Object)propertyAssembler));
    }

    public static ConfigurationAssembler Xml() {
        return new XmlConfigurationAssembler(ConfigurationPropertyAssembler.New());
    }

    public static ConfigurationAssembler Xml(ConfigurationPropertyAssembler propertyAssembler) {
        return new XmlConfigurationAssembler((ConfigurationPropertyAssembler)X.notNull((Object)propertyAssembler));
    }

    public static class IniConfigurationAssembler
    implements ConfigurationAssembler {
        final ConfigurationPropertyAssembler propertyAssembler;

        IniConfigurationAssembler(ConfigurationPropertyAssembler propertyAssembler) {
            this.propertyAssembler = propertyAssembler;
        }

        @Override
        public VarString assemble(VarString vs, Configuration configuration) {
            Map<String, String> map = this.propertyAssembler.assemble(configuration);
            map.entrySet().forEach(e -> {
                VarString varString2 = vs.add((String)e.getKey()).add(" = ").add((String)e.getValue()).lf();
            });
            return vs;
        }
    }

    public static class XmlConfigurationAssembler
    implements ConfigurationAssembler {
        final ConfigurationPropertyAssembler propertyAssembler;

        XmlConfigurationAssembler(ConfigurationPropertyAssembler propertyAssembler) {
            this.propertyAssembler = propertyAssembler;
        }

        @Override
        public VarString assemble(VarString vs, Configuration configuration) {
            Map<String, String> map = this.propertyAssembler.assemble(configuration);
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element rootElement = document.createElement("properties");
                document.appendChild(rootElement);
                map.entrySet().forEach(e -> {
                    Element element2 = document.createElement("property");
                    element2.setAttribute("name", (String)e.getKey());
                    element2.setAttribute("value", (String)e.getValue());
                    rootElement.appendChild(element2);
                });
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                transformer.transform(new DOMSource(document), new StreamResult(new VarStringWriter(vs)));
            }
            catch (ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError e2) {
                throw new StorageConfigurationException(e2);
            }
            return vs;
        }

        static class VarStringWriter
        extends Writer {
            final VarString vs;

            VarStringWriter(VarString vs) {
                this.vs = vs;
            }

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                this.vs.add(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
            }
        }
    }
}

