/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.time.Duration;
import one.microstream.chars.ObjectStringAssembler;
import one.microstream.chars.VarString;
import one.microstream.configuration.types.DurationUnit;

@Deprecated
public interface DurationAssembler
extends ObjectStringAssembler<Duration> {
    public VarString assemble(VarString var1, Duration var2);

    default public String assemble(Duration duration) {
        return super.assemble((Object)duration);
    }

    public static DurationAssembler IsoAssembler() {
        return (vs, duration) -> vs.append((CharSequence)duration.toString());
    }

    public static DurationAssembler Default() {
        return new Default();
    }

    public static class Default
    implements DurationAssembler {
        Default() {
        }

        @Override
        public VarString assemble(VarString vs, Duration duration) {
            long value = duration.toDays();
            if (value > 0L) {
                vs.add(value).add(DurationUnit.D.name());
            } else {
                value = duration.toHours();
                if (value > 0L) {
                    vs.add(value).add(DurationUnit.H.name());
                } else {
                    value = duration.toMinutes();
                    if (value > 0L) {
                        vs.add(value).add(DurationUnit.M.name());
                    } else {
                        value = duration.getSeconds();
                        if (value > 0L) {
                            vs.add(value).add(DurationUnit.S.name());
                        } else {
                            value = duration.toMillis();
                            if (value > 0L) {
                                vs.add(value).add(DurationUnit.MS.name());
                            } else {
                                vs.add(duration.toNanos()).add(DurationUnit.MS.name());
                            }
                        }
                    }
                }
            }
            return vs;
        }
    }
}

