/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.embedded.configuration.types;

import java.io.File;
import java.time.Duration;
import one.microstream.X;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.configuration.types.ByteSize;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationValueMapperProvider;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageConfigurationPropertyNames;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageFoundationCreatorConfigurationBased;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.typing.KeyValue;

public interface EmbeddedStorageConfigurationBuilder
extends Configuration.Builder {
    public EmbeddedStorageConfigurationBuilder setStorageDirectory(String var1);

    default public EmbeddedStorageConfigurationBuilder setStorageDirectoryInUserHome(String storageDirectoryInUserHome) {
        File userHomeDir = new File(System.getProperty("user.home"));
        this.setStorageDirectory(new File(userHomeDir, storageDirectoryInUserHome).getAbsolutePath());
        return this;
    }

    public EmbeddedStorageConfigurationBuilder setDeletionDirectory(String var1);

    public EmbeddedStorageConfigurationBuilder setTruncationDirectory(String var1);

    public EmbeddedStorageConfigurationBuilder setBackupDirectory(String var1);

    default public EmbeddedStorageConfigurationBuilder setBackupDirectoryInUserHome(String backupDirectoryInUserHome) {
        File userHomeDir = new File(System.getProperty("user.home"));
        this.setBackupDirectory(new File(userHomeDir, backupDirectoryInUserHome).getAbsolutePath());
        return this;
    }

    public EmbeddedStorageConfigurationBuilder setChannelCount(int var1);

    public EmbeddedStorageConfigurationBuilder setChannelDirectoryPrefix(String var1);

    public EmbeddedStorageConfigurationBuilder setDataFilePrefix(String var1);

    public EmbeddedStorageConfigurationBuilder setDataFileSuffix(String var1);

    public EmbeddedStorageConfigurationBuilder setTransactionFilePrefix(String var1);

    public EmbeddedStorageConfigurationBuilder setTransactionFileSuffix(String var1);

    public EmbeddedStorageConfigurationBuilder setTypeDictionaryFileName(String var1);

    public EmbeddedStorageConfigurationBuilder setRescuedFileSuffix(String var1);

    public EmbeddedStorageConfigurationBuilder setLockFileName(String var1);

    public EmbeddedStorageConfigurationBuilder setHousekeepingInterval(Duration var1);

    public EmbeddedStorageConfigurationBuilder setHousekeepingTimeBudget(Duration var1);

    public EmbeddedStorageConfigurationBuilder setEntityCacheThreshold(long var1);

    public EmbeddedStorageConfigurationBuilder setEntityCacheTimeout(Duration var1);

    public EmbeddedStorageConfigurationBuilder setDataFileMinimumSize(ByteSize var1);

    public EmbeddedStorageConfigurationBuilder setDataFileMaximumSize(ByteSize var1);

    public EmbeddedStorageConfigurationBuilder setDataFileMinimumUseRatio(double var1);

    public EmbeddedStorageConfigurationBuilder setDataFileCleanupHeadFile(boolean var1);

    default public EmbeddedStorageFoundation<?> createEmbeddedStorageFoundation() {
        return EmbeddedStorageFoundationCreatorConfigurationBased.New(this.buildConfiguration()).createEmbeddedStorageFoundation();
    }

    public static EmbeddedStorageConfigurationBuilder New() {
        return new Default(Configuration.Builder());
    }

    public static EmbeddedStorageConfigurationBuilder New(Configuration.Builder delegate) {
        return new Default((Configuration.Builder)X.notNull((Object)delegate));
    }

    public static class Default
    implements EmbeddedStorageConfigurationBuilder,
    EmbeddedStorageConfigurationPropertyNames {
        private final Configuration.Builder delegate;

        Default(Configuration.Builder delegate) {
            this.delegate = delegate;
        }

        public EmbeddedStorageConfigurationBuilder valueMapperProvider(ConfigurationValueMapperProvider valueMapperProvider) {
            this.delegate.valueMapperProvider(valueMapperProvider);
            return this;
        }

        public EmbeddedStorageConfigurationBuilder set(String key, String value) {
            this.delegate.set(key, value);
            return this;
        }

        public EmbeddedStorageConfigurationBuilder setAll(XGettingCollection<KeyValue<String, String>> properties) {
            this.delegate.setAll(properties);
            return this;
        }

        public EmbeddedStorageConfigurationBuilder setAll(KeyValue<String, String> ... properties) {
            this.delegate.setAll(properties);
            return this;
        }

        public EmbeddedStorageConfigurationBuilder child(String key) {
            this.delegate.child(key);
            return this;
        }

        public Configuration buildConfiguration() {
            return this.delegate.buildConfiguration();
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setStorageDirectory(String storageDirectory) {
            return this.set("storage-directory", storageDirectory);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDeletionDirectory(String deletionDirectory) {
            return this.set("deletion-directory", deletionDirectory);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setTruncationDirectory(String truncationDirectory) {
            return this.set("truncation-directory", truncationDirectory);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setBackupDirectory(String backupDirectory) {
            return this.set("backup-directory", backupDirectory);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setChannelCount(int channelCount) {
            return this.set("channel-count", Integer.toString(channelCount));
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setChannelDirectoryPrefix(String channelDirectoryPrefix) {
            return this.set("channel-directory-prefix", channelDirectoryPrefix);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDataFilePrefix(String dataFilePrefix) {
            return this.set("data-file-prefix", dataFilePrefix);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDataFileSuffix(String dataFileSuffix) {
            return this.set("data-file-suffix", dataFileSuffix);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setTransactionFilePrefix(String transactionFilePrefix) {
            return this.set("transaction-file-prefix", transactionFilePrefix);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setTransactionFileSuffix(String transactionFileSuffix) {
            return this.set("transaction-file-suffix", transactionFileSuffix);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setTypeDictionaryFileName(String typeDictionaryFileName) {
            return this.set("type-dictionary-file-name", typeDictionaryFileName);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setRescuedFileSuffix(String rescuedFileSuffix) {
            this.set("rescued-file-suffix", rescuedFileSuffix);
            return this;
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setLockFileName(String lockFileName) {
            return this.set("lock-file-name", lockFileName);
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setHousekeepingInterval(Duration houseKeepingInterval) {
            return this.set("housekeeping-interval", houseKeepingInterval.toString());
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setHousekeepingTimeBudget(Duration housekeepingTimeBudget) {
            return this.set("housekeeping-time-budget", housekeepingTimeBudget.toString());
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setEntityCacheThreshold(long entityCacheThreshold) {
            return this.set("entity-cache-threshold", Long.toString(entityCacheThreshold));
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setEntityCacheTimeout(Duration entityCacheTimeout) {
            return this.set("entity-cache-timeout", entityCacheTimeout.toString());
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDataFileMinimumSize(ByteSize dataFileMinimumSize) {
            return this.set("data-file-minimum-size", dataFileMinimumSize.toString());
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDataFileMaximumSize(ByteSize dataFileMaximumSize) {
            return this.set("data-file-maximum-size", dataFileMaximumSize.toString());
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDataFileMinimumUseRatio(double dataFileMinimumUseRatio) {
            return this.set("data-file-minimum-use-ratio", Double.toString(dataFileMinimumUseRatio));
        }

        @Override
        public EmbeddedStorageConfigurationBuilder setDataFileCleanupHeadFile(boolean dataFileCleanupHeadFile) {
            return this.set("data-file-cleanup-head-file", Boolean.toString(dataFileCleanupHeadFile));
        }
    }
}

