/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.configuration;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.storage.configuration.ConfigurationAssembler;
import one.microstream.storage.configuration.ConfigurationLoader;
import one.microstream.storage.configuration.ConfigurationParser;
import one.microstream.storage.configuration.ConfigurationStorer;
import one.microstream.storage.configuration.EmbeddedStorageFoundationCreator;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageFileNameProvider;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageLiveFileProvider;

@Deprecated
public interface Configuration {
    public static String PathProperty() {
        return "microstream.storage.configuration.path";
    }

    public static String DefaultResourceName() {
        return "microstream-storage.properties";
    }

    @Deprecated
    public static Configuration Load() {
        return Configuration.Load(ConfigurationLoader.Defaults.defaultCharset());
    }

    @Deprecated
    public static Configuration Load(Charset charset) {
        URL url;
        Configuration configuration;
        String path = System.getProperty(Configuration.PathProperty());
        if (!XChars.isEmpty((CharSequence)path) && (configuration = Configuration.Load(path, charset)) != null) {
            return configuration;
        }
        String defaultName = Configuration.DefaultResourceName();
        ClassLoader contextClassloader = Thread.currentThread().getContextClassLoader();
        URL uRL = url = contextClassloader != null ? contextClassloader.getResource(defaultName) : Configuration.class.getResource("/" + defaultName);
        if (url != null) {
            return Configuration.LoadIni(url, charset);
        }
        File file = new File(defaultName);
        if (file.exists()) {
            return Configuration.LoadIni(file, charset);
        }
        file = new File(System.getProperty("user.home"), defaultName);
        if (file.exists()) {
            return Configuration.LoadIni(file, charset);
        }
        return null;
    }

    @Deprecated
    public static Configuration Load(String path) {
        return Configuration.Load(path, ConfigurationLoader.Defaults.defaultCharset());
    }

    @Deprecated
    public static Configuration Load(String path, Charset charset) {
        return path.toLowerCase().endsWith(".xml") ? Configuration.LoadXml(path, charset) : Configuration.LoadIni(path, charset);
    }

    public static Configuration LoadIni(String path) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.load(path));
    }

    public static Configuration LoadIni(String path, Charset charset) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.load(path, charset));
    }

    public static Configuration LoadIni(Path path) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.loadFromPath(path));
    }

    public static Configuration LoadIni(Path path, Charset charset) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.loadFromPath(path, charset));
    }

    public static Configuration LoadIni(File file) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.loadFromFile(file));
    }

    public static Configuration LoadIni(File file, Charset charset) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.loadFromFile(file, charset));
    }

    public static Configuration LoadIni(URL url) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.loadFromUrl(url));
    }

    public static Configuration LoadIni(URL url, Charset charset) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.loadFromUrl(url, charset));
    }

    public static Configuration LoadIni(InputStream inputStream) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.FromInputStream(inputStream).loadConfiguration());
    }

    public static Configuration LoadIni(InputStream inputStream, Charset charset) {
        return ConfigurationParser.Ini().parse(ConfigurationLoader.FromInputStream(inputStream, charset).loadConfiguration());
    }

    public static Configuration LoadXml(String path) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.load(path));
    }

    public static Configuration LoadXml(String path, Charset charset) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.load(path, charset));
    }

    public static Configuration LoadXml(Path path) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.loadFromPath(path));
    }

    public static Configuration LoadXml(Path path, Charset charset) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.loadFromPath(path, charset));
    }

    public static Configuration LoadXml(File file) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.loadFromFile(file));
    }

    public static Configuration LoadXml(File file, Charset charset) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.loadFromFile(file, charset));
    }

    public static Configuration LoadXml(URL url) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.loadFromUrl(url));
    }

    public static Configuration LoadXml(URL url, Charset charset) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.loadFromUrl(url, charset));
    }

    public static Configuration LoadXml(InputStream inputStream) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.FromInputStream(inputStream).loadConfiguration());
    }

    public static Configuration LoadXml(InputStream inputStream, Charset charset) {
        return ConfigurationParser.Xml().parse(ConfigurationLoader.FromInputStream(inputStream, charset).loadConfiguration());
    }

    default public void exportXml(OutputStream outputStream) {
        ConfigurationStorer.ToOutputStream(outputStream).storeConfiguration(ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(OutputStream outputStream, Charset charset) {
        ConfigurationStorer.ToOutputStream(outputStream, charset).storeConfiguration(ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(Path path) {
        ConfigurationStorer.storeToPath(path, ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(Path path, Charset charset) {
        ConfigurationStorer.storeToPath(path, charset, ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(File file) {
        ConfigurationStorer.storeToFile(file, ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(File file, Charset charset) {
        ConfigurationStorer.storeToFile(file, charset, ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(URL url) {
        ConfigurationStorer.storeToUrl(url, ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportXml(URL url, Charset charset) {
        ConfigurationStorer.storeToUrl(url, charset, ConfigurationAssembler.Xml().assemble(this));
    }

    default public void exportIni(OutputStream outputStream) {
        ConfigurationStorer.ToOutputStream(outputStream).storeConfiguration(ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(OutputStream outputStream, Charset charset) {
        ConfigurationStorer.ToOutputStream(outputStream, charset).storeConfiguration(ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(Path path) {
        ConfigurationStorer.storeToPath(path, ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(Path path, Charset charset) {
        ConfigurationStorer.storeToPath(path, charset, ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(File file) {
        ConfigurationStorer.storeToFile(file, ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(File file, Charset charset) {
        ConfigurationStorer.storeToFile(file, charset, ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(URL url) {
        ConfigurationStorer.storeToUrl(url, ConfigurationAssembler.Ini().assemble(this));
    }

    default public void exportIni(URL url, Charset charset) {
        ConfigurationStorer.storeToUrl(url, charset, ConfigurationAssembler.Ini().assemble(this));
    }

    default public EmbeddedStorageFoundation<?> createEmbeddedStorageFoundation() {
        return EmbeddedStorageFoundationCreator.New().createFoundation(this);
    }

    public Configuration setBaseDirectory(String var1);

    default public Configuration setBaseDirectoryInUserHome(String baseDirectoryInUserHome) {
        File userHomeDir = new File(System.getProperty("user.home"));
        this.setBaseDirectory(new File(userHomeDir, baseDirectoryInUserHome).getAbsolutePath());
        return this;
    }

    public String getBaseDirectory();

    public Configuration setDeletionDirectory(String var1);

    public String getDeletionDirectory();

    public Configuration setTruncationDirectory(String var1);

    public String getTruncationDirectory();

    public Configuration setBackupDirectory(String var1);

    default public Configuration setBackupDirectoryInUserHome(String backupDirectoryInUserHome) {
        File userHomeDir = new File(System.getProperty("user.home"));
        this.setBackupDirectory(new File(userHomeDir, backupDirectoryInUserHome).getAbsolutePath());
        return this;
    }

    public String getBackupDirectory();

    public Configuration setChannelCount(int var1);

    public int getChannelCount();

    public Configuration setChannelDirectoryPrefix(String var1);

    public String getChannelDirectoryPrefix();

    public Configuration setDataFilePrefix(String var1);

    public String getDataFilePrefix();

    public Configuration setDataFileSuffix(String var1);

    public String getDataFileSuffix();

    public Configuration setTransactionFilePrefix(String var1);

    public String getTransactionFilePrefix();

    public Configuration setTransactionFileSuffix(String var1);

    public String getTransactionFileSuffix();

    public Configuration setTypeDictionaryFilename(String var1);

    public String getTypeDictionaryFilename();

    public Configuration setRescuedFileSuffix(String var1);

    public String getRescuedFileSuffix();

    public Configuration setLockFileName(String var1);

    public String getLockFileName();

    default public Configuration setHouseKeepingInterval(long houseKeepingInterval) {
        return this.setHousekeepingIntervalMs(houseKeepingInterval);
    }

    public Configuration setHousekeepingIntervalMs(long var1);

    default public long getHouseKeepingInterval() {
        return this.getHousekeepingIntervalMs();
    }

    public long getHousekeepingIntervalMs();

    default public Configuration setHouseKeepingNanoTimeBudget(long houseKeepingNanoTimeBudget) {
        return this.setHousekeepingTimeBudgetNs(houseKeepingNanoTimeBudget);
    }

    public Configuration setHousekeepingTimeBudgetNs(long var1);

    default public long getHouseKeepingNanoTimeBudget() {
        return this.getHousekeepingTimeBudgetNs();
    }

    public long getHousekeepingTimeBudgetNs();

    public Configuration setEntityCacheThreshold(long var1);

    public long getEntityCacheThreshold();

    @Deprecated
    default public Configuration setEntityCacheTimeout(long entityCacheTimeout) {
        return this.setEntityCacheTimeoutMs(entityCacheTimeout);
    }

    public Configuration setEntityCacheTimeoutMs(long var1);

    @Deprecated
    default public long getEntityCacheTimeout() {
        return this.getEntityCacheTimeoutMs();
    }

    public long getEntityCacheTimeoutMs();

    @Deprecated
    default public Configuration setDataFileMinSize(int dataFileMinSize) {
        return this.setDataFileMinimumSize(dataFileMinSize);
    }

    public Configuration setDataFileMinimumSize(int var1);

    @Deprecated
    default public int getDataFileMinSize() {
        return this.getDataFileMinimumSize();
    }

    public int getDataFileMinimumSize();

    @Deprecated
    default public Configuration setDataFileMaxSize(int dataFileMaxSize) {
        return this.setDataFileMaximumSize(dataFileMaxSize);
    }

    public Configuration setDataFileMaximumSize(int var1);

    @Deprecated
    default public int getDataFileMaxSize() {
        return this.getDataFileMaximumSize();
    }

    public int getDataFileMaximumSize();

    @Deprecated
    default public Configuration setDataFileDissolveRatio(double dataFileDissolveRatio) {
        return this.setDataFileMinimumUseRatio(dataFileDissolveRatio);
    }

    public Configuration setDataFileMinimumUseRatio(double var1);

    @Deprecated
    default public double getDataFileDissolveRatio() {
        return this.getDataFileMinimumUseRatio();
    }

    public double getDataFileMinimumUseRatio();

    public Configuration setDataFileCleanupHeadFile(boolean var1);

    public boolean getDataFileCleanupHeadFile();

    public static Configuration Default() {
        return new Default();
    }

    public static class Default
    implements Configuration {
        private String baseDirectory = StorageLiveFileProvider.Defaults.defaultStorageDirectory();
        private String deletionDirectory = null;
        private String truncationDirectory = null;
        private String backupDirectory = null;
        private String channelDirectoryPrefix = StorageFileNameProvider.Defaults.defaultChannelDirectoryPrefix();
        private String dataFilePrefix = StorageFileNameProvider.Defaults.defaultDataFilePrefix();
        private String dataFileSuffix = StorageFileNameProvider.Defaults.defaultDataFileSuffix();
        private String transactionFilePrefix = StorageFileNameProvider.Defaults.defaultTransactionsFilePrefix();
        private String transactionFileSuffix = StorageFileNameProvider.Defaults.defaultTransactionsFileSuffix();
        private String typeDictionaryFilename = StorageFileNameProvider.Defaults.defaultTypeDictionaryFileName();
        private String rescuedFileSuffix = StorageFileNameProvider.Defaults.defaultRescuedFileSuffix();
        private String lockFileName = StorageFileNameProvider.Defaults.defaultLockFileName();
        private int channelCount = StorageChannelCountProvider.Defaults.defaultChannelCount();
        private long housekeepingIntervalMs = StorageHousekeepingController.Defaults.defaultHousekeepingIntervalMs();
        private long housekeepingTimeBudgetNs = StorageHousekeepingController.Defaults.defaultHousekeepingTimeBudgetNs();
        private long entityCacheTimeoutMs = StorageEntityCacheEvaluator.Defaults.defaultTimeoutMs();
        private long entityCacheThreshold = StorageEntityCacheEvaluator.Defaults.defaultCacheThreshold();
        private int dataFileMinimumSize = StorageDataFileEvaluator.Defaults.defaultFileMinimumSize();
        private int dataFileMaximumSize = StorageDataFileEvaluator.Defaults.defaultFileMaximumSize();
        private double dataFileMinimumUseRatio = StorageDataFileEvaluator.Defaults.defaultMinimumUseRatio();
        private boolean dataFileCleanupHeadFile = StorageDataFileEvaluator.Defaults.defaultResolveHeadfile();

        Default() {
        }

        @Override
        public Configuration setBaseDirectory(String baseDirectory) {
            this.baseDirectory = (String)XChars.notEmpty((CharSequence)baseDirectory);
            return this;
        }

        @Override
        public String getBaseDirectory() {
            return this.baseDirectory;
        }

        @Override
        public Configuration setDeletionDirectory(String deletionDirectory) {
            this.deletionDirectory = deletionDirectory;
            return this;
        }

        @Override
        public String getDeletionDirectory() {
            return this.deletionDirectory;
        }

        @Override
        public Configuration setTruncationDirectory(String truncationDirectory) {
            this.truncationDirectory = truncationDirectory;
            return this;
        }

        @Override
        public String getTruncationDirectory() {
            return this.truncationDirectory;
        }

        @Override
        public Configuration setBackupDirectory(String backupDirectory) {
            this.backupDirectory = backupDirectory;
            return this;
        }

        @Override
        public String getBackupDirectory() {
            return this.backupDirectory;
        }

        @Override
        public Configuration setChannelCount(int channelCount) {
            StorageChannelCountProvider.Validation.validateParameters((int)channelCount);
            this.channelCount = channelCount;
            return this;
        }

        @Override
        public int getChannelCount() {
            return this.channelCount;
        }

        @Override
        public Configuration setChannelDirectoryPrefix(String channelDirectoryPrefix) {
            this.channelDirectoryPrefix = (String)X.notNull((Object)channelDirectoryPrefix);
            return this;
        }

        @Override
        public String getChannelDirectoryPrefix() {
            return this.channelDirectoryPrefix;
        }

        @Override
        public Configuration setDataFilePrefix(String dataFilePrefix) {
            this.dataFilePrefix = (String)X.notNull((Object)dataFilePrefix);
            return this;
        }

        @Override
        public String getDataFilePrefix() {
            return this.dataFilePrefix;
        }

        @Override
        public Configuration setDataFileSuffix(String dataFileSuffix) {
            this.dataFileSuffix = (String)X.notNull((Object)dataFileSuffix);
            return this;
        }

        @Override
        public String getDataFileSuffix() {
            return this.dataFileSuffix;
        }

        @Override
        public Configuration setTransactionFilePrefix(String transactionFilePrefix) {
            this.transactionFilePrefix = (String)X.notNull((Object)transactionFilePrefix);
            return this;
        }

        @Override
        public String getTransactionFilePrefix() {
            return this.transactionFilePrefix;
        }

        @Override
        public Configuration setTransactionFileSuffix(String transactionFileSuffix) {
            this.transactionFileSuffix = (String)X.notNull((Object)transactionFileSuffix);
            return this;
        }

        @Override
        public String getTransactionFileSuffix() {
            return this.transactionFileSuffix;
        }

        @Override
        public Configuration setTypeDictionaryFilename(String typeDictionaryFilename) {
            this.typeDictionaryFilename = (String)XChars.notEmpty((CharSequence)typeDictionaryFilename);
            return this;
        }

        @Override
        public String getTypeDictionaryFilename() {
            return this.typeDictionaryFilename;
        }

        @Override
        public Configuration setRescuedFileSuffix(String rescuedFileSuffix) {
            this.rescuedFileSuffix = (String)XChars.notEmpty((CharSequence)rescuedFileSuffix);
            return this;
        }

        @Override
        public String getRescuedFileSuffix() {
            return this.rescuedFileSuffix;
        }

        @Override
        public Configuration setLockFileName(String lockFileName) {
            this.lockFileName = lockFileName;
            return this;
        }

        @Override
        public String getLockFileName() {
            return this.lockFileName;
        }

        @Override
        public Configuration setHousekeepingIntervalMs(long housekeepingIntervalMs) {
            StorageHousekeepingController.Validation.validateParameters((long)housekeepingIntervalMs, (long)StorageHousekeepingController.Defaults.defaultHousekeepingTimeBudgetNs());
            this.housekeepingIntervalMs = housekeepingIntervalMs;
            return this;
        }

        @Override
        public long getHousekeepingIntervalMs() {
            return this.housekeepingIntervalMs;
        }

        @Override
        public Configuration setHousekeepingTimeBudgetNs(long housekeepingNanoTimeBudgetNs) {
            StorageHousekeepingController.Validation.validateParameters((long)StorageHousekeepingController.Defaults.defaultHousekeepingIntervalMs(), (long)housekeepingNanoTimeBudgetNs);
            this.housekeepingTimeBudgetNs = housekeepingNanoTimeBudgetNs;
            return this;
        }

        @Override
        public long getHousekeepingTimeBudgetNs() {
            return this.housekeepingTimeBudgetNs;
        }

        @Override
        public Configuration setEntityCacheThreshold(long entityCacheThreshold) {
            StorageEntityCacheEvaluator.Validation.validateParameters((long)StorageEntityCacheEvaluator.Defaults.defaultTimeoutMs(), (long)entityCacheThreshold);
            this.entityCacheThreshold = entityCacheThreshold;
            return this;
        }

        @Override
        public long getEntityCacheThreshold() {
            return this.entityCacheThreshold;
        }

        @Override
        public Configuration setEntityCacheTimeoutMs(long entityCacheTimeoutMs) {
            StorageEntityCacheEvaluator.Validation.validateParameters((long)entityCacheTimeoutMs, (long)StorageEntityCacheEvaluator.Defaults.defaultCacheThreshold());
            this.entityCacheTimeoutMs = entityCacheTimeoutMs;
            return this;
        }

        @Override
        public long getEntityCacheTimeoutMs() {
            return this.entityCacheTimeoutMs;
        }

        @Override
        public Configuration setDataFileMinimumSize(int dataFileMinimumSize) {
            StorageDataFileEvaluator.Validation.validateParameters((int)dataFileMinimumSize, (int)StorageDataFileEvaluator.Validation.maximumFileSize(), (double)StorageDataFileEvaluator.Defaults.defaultMinimumUseRatio());
            this.dataFileMinimumSize = dataFileMinimumSize;
            return this;
        }

        @Override
        public int getDataFileMinimumSize() {
            return this.dataFileMinimumSize;
        }

        @Override
        public Configuration setDataFileMaximumSize(int dataFileMaximumSize) {
            StorageDataFileEvaluator.Validation.validateParameters((int)StorageDataFileEvaluator.Validation.minimumFileSize(), (int)dataFileMaximumSize, (double)StorageDataFileEvaluator.Defaults.defaultMinimumUseRatio());
            this.dataFileMaximumSize = dataFileMaximumSize;
            return this;
        }

        @Override
        public int getDataFileMaximumSize() {
            return this.dataFileMaximumSize;
        }

        @Override
        public Configuration setDataFileMinimumUseRatio(double dataFileMinimumUseRatio) {
            StorageDataFileEvaluator.Validation.validateParameters((int)StorageDataFileEvaluator.Defaults.defaultFileMinimumSize(), (int)StorageDataFileEvaluator.Defaults.defaultFileMaximumSize(), (double)dataFileMinimumUseRatio);
            this.dataFileMinimumUseRatio = dataFileMinimumUseRatio;
            return this;
        }

        @Override
        public double getDataFileMinimumUseRatio() {
            return this.dataFileMinimumUseRatio;
        }

        @Override
        public Configuration setDataFileCleanupHeadFile(boolean dataFileCleanupHeadFile) {
            this.dataFileCleanupHeadFile = dataFileCleanupHeadFile;
            return this;
        }

        @Override
        public boolean getDataFileCleanupHeadFile() {
            return this.dataFileCleanupHeadFile;
        }
    }
}

