/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.embedded.configuration.types;

import java.nio.file.Paths;
import java.time.Duration;
import java.util.function.Supplier;
import one.microstream.X;
import one.microstream.afs.nio.types.NioFileSystem;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFileSystem;
import one.microstream.chars.XChars;
import one.microstream.configuration.exceptions.ConfigurationException;
import one.microstream.configuration.types.ByteSize;
import one.microstream.configuration.types.Configuration;
import one.microstream.configuration.types.ConfigurationBasedCreator;
import one.microstream.storage.embedded.configuration.types.EmbeddedStorageConfigurationPropertyNames;
import one.microstream.storage.embedded.types.EmbeddedStorage;
import one.microstream.storage.embedded.types.EmbeddedStorageFoundation;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageChannelCountProvider;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageFileNameProvider;
import one.microstream.storage.types.StorageHousekeepingController;
import one.microstream.storage.types.StorageLiveFileProvider;

public interface EmbeddedStorageFoundationCreatorConfigurationBased
extends EmbeddedStorageFoundation.Creator {
    public static EmbeddedStorageFoundationCreatorConfigurationBased New(Configuration configuration) {
        return new Default((Configuration)X.notNull((Object)configuration));
    }

    public static class Default
    implements EmbeddedStorageFoundationCreatorConfigurationBased,
    EmbeddedStorageConfigurationPropertyNames {
        private final Configuration configuration;

        Default(Configuration configuration) {
            this.configuration = configuration;
        }

        public EmbeddedStorageFoundation<?> createEmbeddedStorageFoundation() {
            try {
                return this.internalCreateEmbeddedStorageFoundation();
            }
            catch (ConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ConfigurationException(this.configuration, (Throwable)e);
            }
        }

        private EmbeddedStorageFoundation<?> internalCreateEmbeddedStorageFoundation() {
            AFileSystem fileSystem = this.createFileSystem("storage-filesystem", NioFileSystem::New);
            StorageConfiguration.Builder configBuilder = Storage.ConfigurationBuilder().setStorageFileProvider(this.createFileProvider(fileSystem)).setChannelCountProvider(this.createChannelCountProvider()).setHousekeepingController(this.createHousekeepingController()).setDataFileEvaluator(this.createDataFileEvaluator()).setEntityCacheEvaluator(this.createEntityCacheEvaluator());
            this.configuration.opt("backup-directory").filter(backupDirectory -> !XChars.isEmpty((CharSequence)backupDirectory)).map(this::createDirectoryPath).ifPresent(backupDirectory -> {
                AFileSystem backupFileSystem = this.createFileSystem("backup-filesystem", () -> fileSystem);
                configBuilder.setBackupSetup(Storage.BackupSetup((ADirectory)backupFileSystem.ensureDirectoryPath(new String[]{backupDirectory})));
            });
            return EmbeddedStorage.Foundation((StorageConfiguration)configBuilder.createConfiguration());
        }

        private AFileSystem createFileSystem(String configurationKey, Supplier<AFileSystem> defaultFileSystemSupplier) {
            Configuration configuration = this.configuration.child(configurationKey);
            if (configuration != null) {
                for (ConfigurationBasedCreator creator : ConfigurationBasedCreator.registeredCreators(AFileSystem.class)) {
                    AFileSystem fileSystem = (AFileSystem)creator.create(configuration);
                    if (fileSystem == null) continue;
                    return fileSystem;
                }
            }
            return defaultFileSystemSupplier.get();
        }

        private StorageLiveFileProvider createFileProvider(AFileSystem fileSystem) {
            ADirectory baseDirectory = fileSystem.ensureDirectoryPath(new String[]{this.createDirectoryPath(this.configuration.opt("storage-directory").orElse(StorageLiveFileProvider.Defaults.defaultStorageDirectory()))});
            StorageFileNameProvider fileNameProvider = StorageFileNameProvider.New((String)this.configuration.opt("channel-directory-prefix").orElse(StorageFileNameProvider.Defaults.defaultChannelDirectoryPrefix()), (String)this.configuration.opt("data-file-prefix").orElse(StorageFileNameProvider.Defaults.defaultDataFilePrefix()), (String)this.configuration.opt("data-file-suffix").orElse(StorageFileNameProvider.Defaults.defaultDataFileSuffix()), (String)this.configuration.opt("transaction-file-prefix").orElse(StorageFileNameProvider.Defaults.defaultTransactionsFilePrefix()), (String)this.configuration.opt("transaction-file-suffix").orElse(StorageFileNameProvider.Defaults.defaultTransactionsFileSuffix()), (String)this.configuration.opt("rescued-file-suffix").orElse(StorageFileNameProvider.Defaults.defaultRescuedFileSuffix()), (String)this.configuration.opt("type-dictionary-file-name").orElse(StorageFileNameProvider.Defaults.defaultTypeDictionaryFileName()), (String)this.configuration.opt("lock-file-name").orElse(StorageFileNameProvider.Defaults.defaultLockFileName()));
            StorageLiveFileProvider.Builder builder = (StorageLiveFileProvider.Builder)((StorageLiveFileProvider.Builder)Storage.FileProviderBuilder((AFileSystem)fileSystem).setDirectory(baseDirectory)).setFileNameProvider(fileNameProvider);
            this.configuration.opt("deletion-directory").filter(deletionDirectory -> !XChars.isEmpty((CharSequence)deletionDirectory)).ifPresent(deletionDirectory -> builder.setDeletionDirectory(fileSystem.ensureDirectoryPath(new String[]{deletionDirectory})));
            this.configuration.opt("truncation-directory").filter(truncationDirectory -> !XChars.isEmpty((CharSequence)truncationDirectory)).ifPresent(truncationDirectory -> builder.setTruncationDirectory(fileSystem.ensureDirectoryPath(new String[]{truncationDirectory})));
            return builder.createFileProvider();
        }

        private StorageChannelCountProvider createChannelCountProvider() {
            return Storage.ChannelCountProvider((int)this.configuration.optInteger("channel-count").orElse(StorageChannelCountProvider.Defaults.defaultChannelCount()));
        }

        private StorageHousekeepingController createHousekeepingController() {
            return Storage.HousekeepingController((long)this.configuration.opt("housekeeping-interval", Duration.class).map(Duration::toMillis).orElse(StorageHousekeepingController.Defaults.defaultHousekeepingIntervalMs()), (long)this.configuration.opt("housekeeping-time-budget", Duration.class).map(Duration::toNanos).orElse(StorageHousekeepingController.Defaults.defaultHousekeepingTimeBudgetNs()));
        }

        private StorageDataFileEvaluator createDataFileEvaluator() {
            return Storage.DataFileEvaluator((int)this.configuration.opt("data-file-minimum-size", ByteSize.class).map(byteSize -> (int)byteSize.bytes()).orElse(StorageDataFileEvaluator.Defaults.defaultFileMinimumSize()), (int)this.configuration.opt("data-file-maximum-size", ByteSize.class).map(byteSize -> (int)byteSize.bytes()).orElse(StorageDataFileEvaluator.Defaults.defaultFileMaximumSize()), (double)this.configuration.optDouble("data-file-minimum-use-ratio").orElse(StorageDataFileEvaluator.Defaults.defaultMinimumUseRatio()), (boolean)this.configuration.optBoolean("data-file-cleanup-head-file").orElse(StorageDataFileEvaluator.Defaults.defaultResolveHeadfile()));
        }

        private StorageEntityCacheEvaluator createEntityCacheEvaluator() {
            return Storage.EntityCacheEvaluator((long)this.configuration.opt("entity-cache-timeout", Duration.class).map(Duration::toMillis).orElse(StorageEntityCacheEvaluator.Defaults.defaultTimeoutMs()), (long)this.configuration.optLong("entity-cache-threshold").orElse(StorageEntityCacheEvaluator.Defaults.defaultCacheThreshold()));
        }

        private String createDirectoryPath(String path) {
            return path.startsWith("~/") || path.startsWith("~\\") ? Paths.get(System.getProperty("user.home"), path.substring(2)).toString() : path;
        }
    }
}

