/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.embedded.types;

import java.util.function.Supplier;
import one.microstream.X;
import one.microstream.afs.types.WriteController;
import one.microstream.exceptions.MissingFoundationPartException;
import one.microstream.persistence.binary.types.BinaryChannelCountProvider;
import one.microstream.persistence.binary.types.BinaryLoader;
import one.microstream.persistence.binary.types.BinaryPersistenceFoundation;
import one.microstream.persistence.binary.types.BinaryStorer;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.storage.embedded.types.EmbeddedStorageBinarySource;
import one.microstream.storage.embedded.types.EmbeddedStorageBinaryTarget;
import one.microstream.storage.types.StorageConnection;
import one.microstream.storage.types.StorageRequestAcceptor;
import one.microstream.storage.types.StorageSystem;
import one.microstream.storage.types.StorageWriteController;

public interface EmbeddedStorageConnectionFoundation<F extends EmbeddedStorageConnectionFoundation<?>>
extends BinaryPersistenceFoundation<F> {
    public Supplier<? extends StorageSystem> storageSystemSupplier();

    public StorageSystem getStorageSystem();

    public StorageWriteController writeController();

    public StorageWriteController getWriteController();

    public F setStorageSystem(StorageSystem var1);

    public F setStorageSystemSupplier(Supplier<? extends StorageSystem> var1);

    public F setWriteController(StorageWriteController var1);

    public StorageConnection createStorageConnection();

    public static EmbeddedStorageConnectionFoundation<?> New() {
        return new Default();
    }

    public static class Default<F extends Default<?>>
    extends BinaryPersistenceFoundation.Default<F>
    implements EmbeddedStorageConnectionFoundation<F> {
        private StorageSystem storageSystem;
        private Supplier<? extends StorageSystem> storageSystemSupplier;
        private StorageWriteController writeController;
        private transient StorageRequestAcceptor storageRequestAcceptor;

        protected Default() {
        }

        @Override
        public Supplier<? extends StorageSystem> storageSystemSupplier() {
            return this.storageSystemSupplier;
        }

        @Override
        public StorageWriteController writeController() {
            return this.writeController;
        }

        @Override
        public StorageWriteController getWriteController() {
            if (this.writeController == null) {
                this.writeController = (StorageWriteController)this.dispatch(this.ensureWriteController());
            }
            return this.writeController;
        }

        @Override
        public StorageSystem getStorageSystem() {
            if (this.storageSystem == null) {
                this.storageSystem = (StorageSystem)this.dispatch(this.ensureStorageSystem());
            }
            return this.storageSystem;
        }

        @Override
        public F setStorageSystem(StorageSystem storageSystem) {
            this.storageSystem = storageSystem;
            return (F)((Default)this.$());
        }

        @Override
        public F setStorageSystemSupplier(Supplier<? extends StorageSystem> storageSystemSupplier) {
            this.storageSystemSupplier = storageSystemSupplier;
            return (F)((Default)this.$());
        }

        @Override
        public F setWriteController(StorageWriteController writeController) {
            this.writeController = writeController;
            return (F)((Default)this.$());
        }

        protected final void internalSetStorageSystem(StorageSystem storageSystem) {
            this.storageSystem = storageSystem;
        }

        protected StorageSystem ensureStorageSystem() {
            if (this.storageSystemSupplier != null) {
                return (StorageSystem)X.notNull((Object)this.storageSystemSupplier.get());
            }
            throw new MissingFoundationPartException(StorageSystem.class);
        }

        protected StorageWriteController ensureWriteController() {
            return StorageWriteController.Wrap((WriteController)this.getStorageSystem().fileSystem());
        }

        protected BinaryLoader.Creator ensureBuilderCreator() {
            return new BinaryLoader.CreatorChannelHashing((BinaryChannelCountProvider)this.getStorageSystem().operationController().channelCountProvider(), this.isByteOrderMismatch());
        }

        protected BinaryStorer.Creator ensureStorerCreator() {
            return BinaryStorer.Creator((BinaryChannelCountProvider)this.getStorageSystem().channelCountProvider(), (boolean)this.isByteOrderMismatch());
        }

        protected EmbeddedStorageBinarySource ensurePersistenceSource() {
            return new EmbeddedStorageBinarySource.Default(this.internalGetStorageRequestAcceptor());
        }

        protected EmbeddedStorageBinaryTarget ensurePersistenceTarget() {
            return EmbeddedStorageBinaryTarget.New(this.internalGetStorageRequestAcceptor(), this.getWriteController());
        }

        protected StorageRequestAcceptor internalGetStorageRequestAcceptor() {
            if (this.storageRequestAcceptor == null) {
                this.storageRequestAcceptor = this.storageSystem.createRequestAcceptor();
            }
            return this.storageRequestAcceptor;
        }

        @Override
        public synchronized StorageConnection createStorageConnection() {
            this.storageRequestAcceptor = null;
            this.internalGetStorageRequestAcceptor();
            return StorageConnection.New((PersistenceManager)super.createPersistenceManager(), (StorageRequestAcceptor)this.storageRequestAcceptor);
        }
    }
}

