/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.embedded.types;

import java.util.Arrays;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.XSort;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceManager;
import one.microstream.persistence.types.PersistenceRootReference;
import one.microstream.persistence.types.PersistenceRoots;
import one.microstream.persistence.types.PersistenceRootsProvider;
import one.microstream.persistence.types.PersistenceRootsView;
import one.microstream.persistence.types.PersistenceTypeDictionaryExporter;
import one.microstream.persistence.types.Storer;
import one.microstream.persistence.types.Unpersistable;
import one.microstream.reference.LazyReferenceManager;
import one.microstream.reference.Reference;
import one.microstream.reference.Swizzling;
import one.microstream.storage.embedded.types.EmbeddedStorageConnectionFoundation;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.types.Database;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageConnection;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityTypeExportFileProvider;
import one.microstream.storage.types.StorageEntityTypeExportStatistics;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageKillable;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageManager;
import one.microstream.storage.types.StorageRawFileStatistics;
import one.microstream.storage.types.StorageSystem;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.typing.KeyValue;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface EmbeddedStorageManager
extends StorageManager {
    public EmbeddedStorageManager start();

    public static Default New(Database database, StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation, PersistenceRootsProvider<?> rootsProvider) {
        return new Default((Database)X.notNull((Object)database), (StorageConfiguration)X.notNull((Object)configuration), (EmbeddedStorageConnectionFoundation)X.notNull(connectionFoundation), (PersistenceRootsProvider)X.notNull(rootsProvider));
    }

    public static final class Default
    implements EmbeddedStorageManager,
    Unpersistable,
    LazyReferenceManager.Controller {
        private static final Logger logger = Logging.getLogger(Default.class);
        private final Database database;
        private final StorageConfiguration configuration;
        private final StorageSystem storageSystem;
        private final EmbeddedStorageConnectionFoundation<?> connectionFoundation;
        private final PersistenceRootsProvider<?> rootsProvider;
        private StorageConnection singletonConnection;

        Default(Database database, StorageConfiguration configuration, EmbeddedStorageConnectionFoundation<?> connectionFoundation, PersistenceRootsProvider<?> rootsProvider) {
            this.database = database;
            this.configuration = configuration;
            this.storageSystem = connectionFoundation.getStorageSystem();
            this.connectionFoundation = connectionFoundation;
            this.rootsProvider = rootsProvider;
        }

        private synchronized StorageConnection singletonConnection() {
            if (this.singletonConnection == null) {
                this.singletonConnection = this.createConnection();
            }
            return this.singletonConnection;
        }

        public final Database database() {
            return this.database;
        }

        public final Object root() {
            return this.rootReference().get();
        }

        public final Object setRoot(Object newRoot) {
            this.rootReference().setRoot(newRoot);
            return newRoot;
        }

        final PersistenceRootReference rootReference() {
            return this.rootsProvider.provideRoots().rootReference();
        }

        public long storeRoot() {
            PersistenceRootReference rootReference = this.rootReference();
            Object root = rootReference.get();
            if (root == null) {
                this.store(rootReference);
                return Swizzling.nullId();
            }
            return this.storeAll(new Object[]{rootReference, root})[1];
        }

        public final PersistenceRootsView viewRoots() {
            return this.rootsProvider.provideRoots();
        }

        public PersistenceManager<Binary> persistenceManager() {
            return this.singletonConnection().persistenceManager();
        }

        public final Storer createStorer() {
            return this.singletonConnection().createStorer();
        }

        public boolean mayRun() {
            return this.isRunning();
        }

        private void ensureActiveLazyReferenceManager(LazyReferenceManager lazyReferenceManager, boolean lazyReferenceManagerIsRunning) {
            lazyReferenceManager.addController((LazyReferenceManager.Controller)this);
            if (lazyReferenceManagerIsRunning) {
                return;
            }
            lazyReferenceManager.start();
        }

        private void rollbackLazyReferenceManager(LazyReferenceManager lazyReferenceManager) {
            lazyReferenceManager.removeController((LazyReferenceManager.Controller)this);
        }

        @Override
        public final Default start() {
            logger.info("Starting embedded storage manager");
            LazyReferenceManager lazyReferenceManager = LazyReferenceManager.get();
            boolean lazyReferenceManagerIsRunning = lazyReferenceManager.isRunning();
            this.storageSystem.start();
            try {
                this.ensureRequiredTypeHandlers();
                this.initialize();
                logger.info("Embedded storage manager initialized");
                this.ensureActiveLazyReferenceManager(lazyReferenceManager, lazyReferenceManagerIsRunning);
            }
            catch (Throwable t) {
                try {
                    this.rollbackLazyReferenceManager(lazyReferenceManager);
                    if (this.storageSystem instanceof StorageKillable) {
                        ((StorageKillable)this.storageSystem).killStorage(t);
                    } else {
                        this.storageSystem.shutdown();
                    }
                }
                catch (Throwable t1) {
                    t1.addSuppressed(t);
                    throw t1;
                }
                throw t;
            }
            return this;
        }

        static final boolean isEqualRootEntry(KeyValue<String, Object> e1, KeyValue<String, Object> e2) {
            if (!((String)e1.key()).equals(e2.key())) {
                return false;
            }
            if (Persistence.isEnumRootIdentifier((String)((String)e1.key()))) {
                return Arrays.equals((Object[])e1.value(), (Object[])e2.value());
            }
            return e1.value() == e2.value();
        }

        private static EqHashTable<String, Object> normalize(XGettingTable<String, Object> entries) {
            EqHashTable preparedEntries = EqHashTable.New(entries);
            preparedEntries.keys().sort(XSort::compare);
            return preparedEntries;
        }

        private void synchronizeRoots(PersistenceRoots loadedRoots) {
            EqHashTable<String, Object> definedEntries;
            EqHashTable<String, Object> loadedEntries = Default.normalize((XGettingTable<String, Object>)loadedRoots.entries());
            boolean match = loadedEntries.equalsContent(definedEntries = Default.normalize((XGettingTable<String, Object>)this.rootsProvider.provideRoots().entries()), Default::isEqualRootEntry);
            if (!match) {
                loadedRoots.updateEntries(definedEntries);
            }
            this.rootsProvider.updateRuntimeRoots(loadedRoots);
        }

        private void ensureRequiredTypeHandlers() {
            StorageIdAnalysis idAnalysis = this.storageSystem.initializationIdAnalysis();
            XGettingEnum occuringTypeIds = idAnalysis.occuringTypeIds();
            this.connectionFoundation.getTypeHandlerManager().ensureTypeHandlersByTypeIds(occuringTypeIds);
        }

        private PersistenceRoots loadExistingRoots(StorageConnection initConnection) {
            return initConnection.persistenceManager().createLoader().loadRoots();
        }

        private PersistenceRoots validateEmptyDatabaseAndReturnDefinedRoots(StorageConnection initConnection) {
            StorageRawFileStatistics statistics = initConnection.createStorageStatistics();
            if (statistics.liveDataLength() != 0L) {
                throw new StorageExceptionConsistency("No roots found for existing data.");
            }
            return this.rootsProvider.provideRoots();
        }

        private void initialize() {
            try {
                StorageConnection initConnection = this.createConnection();
                PersistenceRoots loadedRoots = this.loadExistingRoots(initConnection);
                if (loadedRoots == null) {
                    loadedRoots = this.validateEmptyDatabaseAndReturnDefinedRoots(initConnection);
                } else {
                    this.synchronizeRoots(loadedRoots);
                    if (!loadedRoots.hasChanged()) {
                        return;
                    }
                }
                logger.debug("Storing required root objects and constants");
                initConnection.store((Object)loadedRoots);
            }
            catch (Exception e) {
                logger.error("Exception occured while initializing embedded storage manager", (Throwable)e);
                throw e;
            }
        }

        public final boolean shutdown() {
            LazyReferenceManager.get().removeController((LazyReferenceManager.Controller)this);
            return this.storageSystem.shutdown();
        }

        public final boolean isAcceptingTasks() {
            return this.storageSystem.isAcceptingTasks();
        }

        public final boolean isRunning() {
            return this.storageSystem.isRunning();
        }

        public final boolean isActive() {
            return this.storageSystem.isActive();
        }

        public final boolean isStartingUp() {
            return this.storageSystem.isStartingUp();
        }

        public final boolean isShuttingDown() {
            return this.storageSystem.isShuttingDown();
        }

        public final void checkAcceptingTasks() {
            this.storageSystem.checkAcceptingTasks();
        }

        public final StorageConfiguration configuration() {
            return this.configuration;
        }

        public final StorageTypeDictionary typeDictionary() {
            return this.storageSystem.typeDictionary();
        }

        public final StorageConnection createConnection() {
            return this.connectionFoundation.createStorageConnection();
        }

        public final long initializationTime() {
            return this.storageSystem.initializationTime();
        }

        public final long operationModeTime() {
            return this.storageSystem.operationModeTime();
        }

        public final void issueFullGarbageCollection() {
            this.singletonConnection().issueFullGarbageCollection();
        }

        public final boolean issueGarbageCollection(long nanoTimeBudget) {
            return this.singletonConnection().issueGarbageCollection(nanoTimeBudget);
        }

        public final void issueFullFileCheck() {
            this.singletonConnection().issueFullFileCheck();
        }

        public final boolean issueFileCheck(long nanoTimeBudget) {
            return this.singletonConnection().issueFileCheck(nanoTimeBudget);
        }

        public final void issueFullCacheCheck() {
            this.singletonConnection().issueFullCacheCheck();
        }

        public final void issueFullCacheCheck(StorageEntityCacheEvaluator entityEvaluator) {
            this.singletonConnection().issueFullCacheCheck(entityEvaluator);
        }

        public final boolean issueCacheCheck(long nanoTimeBudget) {
            return this.singletonConnection().issueCacheCheck(nanoTimeBudget);
        }

        public final boolean issueCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) {
            return this.singletonConnection().issueCacheCheck(nanoTimeBudget, entityEvaluator);
        }

        public final void issueFullBackup(StorageLiveFileProvider targetFileProvider, PersistenceTypeDictionaryExporter typeDictionaryExporter) {
            this.singletonConnection().issueFullBackup(targetFileProvider, typeDictionaryExporter);
        }

        public final StorageRawFileStatistics createStorageStatistics() {
            return this.singletonConnection().createStorageStatistics();
        }

        public final void exportChannels(StorageLiveFileProvider fileProvider, boolean performGarbageCollection) {
            this.singletonConnection().exportChannels(fileProvider, performGarbageCollection);
        }

        public final StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) {
            return this.singletonConnection().exportTypes(exportFileProvider, isExportType);
        }

        public final void importFiles(XGettingEnum<AFile> importFiles) {
            this.singletonConnection().importFiles(importFiles);
        }

        @Deprecated
        public final Reference<Object> defaultRoot() {
            return this.rootReference();
        }
    }
}

