/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.embedded.types;

import one.microstream.collections.ArrayView;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.exceptions.PersistenceExceptionTransfer;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.persistence.types.PersistenceSource;
import one.microstream.storage.types.StorageRequestAcceptor;

public interface EmbeddedStorageBinarySource
extends PersistenceSource<Binary> {
    public XGettingCollection<? extends Binary> read() throws PersistenceExceptionTransfer;

    public XGettingCollection<? extends Binary> readByObjectIds(PersistenceIdSet[] var1) throws PersistenceExceptionTransfer;

    public static final class Default
    implements EmbeddedStorageBinarySource {
        private final StorageRequestAcceptor requestAcceptor;

        public Default(StorageRequestAcceptor requestAcceptor) {
            this.requestAcceptor = requestAcceptor;
        }

        @Override
        public XGettingCollection<? extends Binary> read() throws PersistenceExceptionTransfer {
            try {
                return new ArrayView((Object[])new Binary[]{this.requestAcceptor.recallRoots()});
            }
            catch (InterruptedException e) {
                throw new PersistenceExceptionTransfer((Throwable)e);
            }
        }

        @Override
        public XGettingCollection<? extends Binary> readByObjectIds(PersistenceIdSet[] oids) throws PersistenceExceptionTransfer {
            try {
                return new ArrayView((Object[])new Binary[]{this.requestAcceptor.queryByObjectIds(oids)});
            }
            catch (InterruptedException e) {
                throw new PersistenceExceptionTransfer((Throwable)e);
            }
        }
    }
}

