/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.embedded.types;

import java.util.function.Consumer;
import java.util.function.Supplier;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceLiveStorerRegistry;
import one.microstream.persistence.types.PersistenceObjectIdProvider;
import one.microstream.persistence.types.PersistenceRefactoringMappingProvider;
import one.microstream.persistence.types.PersistenceRootResolverProvider;
import one.microstream.persistence.types.PersistenceRootsProvider;
import one.microstream.persistence.types.PersistenceTypeDefinitionRegistrationObserver;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeEvaluator;
import one.microstream.persistence.types.PersistenceTypeHandler;
import one.microstream.persistence.types.PersistenceTypeHandlerManager;
import one.microstream.persistence.types.PersistenceTypeHandlerRegistration;
import one.microstream.persistence.types.PersistenceTypeManager;
import one.microstream.persistence.types.Persister;
import one.microstream.reference.Reference;
import one.microstream.storage.embedded.types.EmbeddedStorage;
import one.microstream.storage.embedded.types.EmbeddedStorageConnectionFoundation;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import one.microstream.storage.embedded.types.EmbeddedStorageObjectRegistryCallback;
import one.microstream.storage.embedded.types.EmbeddedStorageRootTypeIdProvider;
import one.microstream.storage.types.Database;
import one.microstream.storage.types.Databases;
import one.microstream.storage.types.StorageChannelsCreator;
import one.microstream.storage.types.StorageConfiguration;
import one.microstream.storage.types.StorageDataChunkValidator;
import one.microstream.storage.types.StorageFoundation;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageManager;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageRequestAcceptor;
import one.microstream.storage.types.StorageRequestTaskCreator;
import one.microstream.storage.types.StorageRootTypeIdProvider;
import one.microstream.storage.types.StorageSystem;
import one.microstream.storage.types.StorageTaskBroker;
import one.microstream.storage.types.StorageTimestampProvider;
import one.microstream.storage.types.StorageTypeDictionary;
import one.microstream.storage.types.StorageWriteController;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface EmbeddedStorageFoundation<F extends EmbeddedStorageFoundation<?>>
extends StorageFoundation<F>,
PersistenceTypeHandlerRegistration.Executor<Binary> {
    public EmbeddedStorageConnectionFoundation<?> getConnectionFoundation();

    public Databases getDatabases();

    public String getDataBaseName();

    public PersistenceRootResolverProvider getRootResolverProvider();

    public PersistenceTypeEvaluator getTypeEvaluatorPersistable();

    public F onConnectionFoundation(Consumer<? super EmbeddedStorageConnectionFoundation<?>> var1);

    public F onThis(Consumer<? super EmbeddedStorageFoundation<?>> var1);

    default public EmbeddedStorageManager createEmbeddedStorageManager() {
        return this.createEmbeddedStorageManager(null);
    }

    public EmbeddedStorageManager createEmbeddedStorageManager(Object var1);

    default public EmbeddedStorageManager start() {
        return this.start(null);
    }

    default public EmbeddedStorageManager start(Object explicitRoot) {
        EmbeddedStorageManager esm = this.createEmbeddedStorageManager(explicitRoot);
        esm.start();
        return esm;
    }

    public F setConnectionFoundation(EmbeddedStorageConnectionFoundation<?> var1);

    public F setDatabases(Databases var1);

    public F setDataBaseName(String var1);

    public F setRoot(Object var1);

    public F setRootSupplier(Supplier<?> var1);

    public F setRootResolverProvider(PersistenceRootResolverProvider var1);

    public F setTypeEvaluatorPersistable(PersistenceTypeEvaluator var1);

    public F setRefactoringMappingProvider(PersistenceRefactoringMappingProvider var1);

    public F registerTypeHandler(PersistenceTypeHandler<Binary, ?> var1);

    public F registerTypeHandlers(Iterable<? extends PersistenceTypeHandler<Binary, ?>> var1);

    public static EmbeddedStorageFoundation<?> New() {
        return new Default();
    }

    public static class Default<F extends Default<?>>
    extends StorageFoundation.Default<F>
    implements EmbeddedStorageFoundation<F> {
        private static final Logger logger = Logging.getLogger(Default.class);
        private EmbeddedStorageConnectionFoundation<?> connectionFoundation;
        private PersistenceTypeEvaluator typeEvaluatorPersistable;
        private Databases databases;
        private String dataBaseName;

        Default() {
        }

        @Override
        public F onConnectionFoundation(Consumer<? super EmbeddedStorageConnectionFoundation<?>> logic) {
            EmbeddedStorageConnectionFoundation<?> escf = this.getConnectionFoundation();
            logic.accept(escf);
            return (F)((Default)this.$());
        }

        @Override
        public F onThis(Consumer<? super EmbeddedStorageFoundation<?>> logic) {
            logic.accept(this);
            return (F)((Default)this.$());
        }

        @Override
        public F setRoot(Object root) {
            this.getConnectionFoundation().getRootResolverProvider().setRoot(root);
            return (F)((Default)this.$());
        }

        @Override
        public F setRootSupplier(Supplier<?> rootSupplier) {
            this.getConnectionFoundation().getRootResolverProvider().registerRootSupplier(rootSupplier);
            return (F)((Default)this.$());
        }

        @Override
        public F setRootResolverProvider(PersistenceRootResolverProvider rootResolverProvider) {
            this.getConnectionFoundation().setRootResolverProvider(rootResolverProvider);
            return (F)((Default)this.$());
        }

        protected EmbeddedStorageConnectionFoundation<?> ensureConnectionFoundation() {
            StorageConfiguration configuration = this.getConfiguration();
            PersistenceTypeEvaluator typeEvaluator = this.getTypeEvaluatorPersistable();
            return EmbeddedStorage.ConnectionFoundation(configuration, typeEvaluator);
        }

        protected Databases ensureDatabases() {
            return Databases.get();
        }

        protected String ensureDatabaseName() {
            StorageConfiguration config = this.getConfiguration();
            StorageLiveFileProvider fileProvider = config.fileProvider();
            String defaultName = Persistence.engineName() + "@" + fileProvider.getStorageLocationIdentifier();
            return defaultName;
        }

        protected EmbeddedStorageRootTypeIdProvider ensureRootTypeIdProvider() {
            EmbeddedStorageConnectionFoundation<?> escf = this.getConnectionFoundation();
            PersistenceRootsProvider rootsProvider = escf.getRootsProvider();
            return EmbeddedStorageRootTypeIdProvider.New(rootsProvider.provideRoots().getClass());
        }

        @Override
        public EmbeddedStorageConnectionFoundation<?> getConnectionFoundation() {
            if (this.connectionFoundation == null) {
                this.setConnectionFoundation((EmbeddedStorageConnectionFoundation)this.dispatch(this.ensureConnectionFoundation()));
            }
            return this.connectionFoundation;
        }

        @Override
        public Databases getDatabases() {
            if (this.databases == null) {
                this.databases = (Databases)this.dispatch(this.ensureDatabases());
            }
            return this.databases;
        }

        @Override
        public String getDataBaseName() {
            if (this.dataBaseName == null) {
                this.dataBaseName = (String)this.dispatch(this.ensureDatabaseName());
            }
            return this.dataBaseName;
        }

        @Override
        public PersistenceRootResolverProvider getRootResolverProvider() {
            return this.getConnectionFoundation().getRootResolverProvider();
        }

        @Override
        public PersistenceTypeEvaluator getTypeEvaluatorPersistable() {
            if (this.typeEvaluatorPersistable == null) {
                this.typeEvaluatorPersistable = (PersistenceTypeEvaluator)this.dispatch(this.ensureTypeEvaluatorPersistable());
            }
            return this.typeEvaluatorPersistable;
        }

        public F setConfiguration(StorageConfiguration configuration) {
            super.setConfiguration(configuration);
            return (F)((Default)this.$());
        }

        public F setRequestAcceptorCreator(StorageRequestAcceptor.Creator requestAcceptorCreator) {
            super.setRequestAcceptorCreator(requestAcceptorCreator);
            return (F)((Default)this.$());
        }

        public F setTaskBrokerCreator(StorageTaskBroker.Creator taskBrokerCreator) {
            super.setTaskBrokerCreator(taskBrokerCreator);
            return (F)((Default)this.$());
        }

        public F setDataChunkValidatorProvider(StorageDataChunkValidator.Provider dataChunkValidatorProvider) {
            super.setDataChunkValidatorProvider(dataChunkValidatorProvider);
            return (F)((Default)this.$());
        }

        public F setChannelCreator(StorageChannelsCreator channelCreator) {
            super.setChannelCreator(channelCreator);
            return (F)((Default)this.$());
        }

        public F setTaskCreator(StorageRequestTaskCreator taskCreator) {
            super.setTaskCreator(taskCreator);
            return (F)((Default)this.$());
        }

        public F setTypeDictionary(StorageTypeDictionary typeDictionary) {
            super.setTypeDictionary(typeDictionary);
            return (F)((Default)this.$());
        }

        public F setRootTypeIdProvider(StorageRootTypeIdProvider rootTypeIdProvider) {
            super.setRootTypeIdProvider(rootTypeIdProvider);
            return (F)((Default)this.$());
        }

        @Override
        public F setConnectionFoundation(EmbeddedStorageConnectionFoundation<?> connectionFoundation) {
            this.connectionFoundation = connectionFoundation;
            this.connectionFoundation.setStorageSystemSupplier(() -> this.createStorageSystem());
            StorageWriteController writeController = this.writeController();
            if (writeController != null) {
                this.connectionFoundation.setWriteController(writeController);
            }
            return (F)((Default)this.$());
        }

        @Override
        public F setDatabases(Databases databases) {
            this.databases = databases;
            return (F)((Default)this.$());
        }

        @Override
        public F setDataBaseName(String dataBaseName) {
            this.dataBaseName = dataBaseName;
            return (F)((Default)this.$());
        }

        @Override
        public F setRefactoringMappingProvider(PersistenceRefactoringMappingProvider refactoringMappingProvider) {
            this.getConnectionFoundation().setRefactoringMappingProvider(refactoringMappingProvider);
            return (F)((Default)this.$());
        }

        public F setTimestampProvider(StorageTimestampProvider timestampProvider) {
            super.setTimestampProvider(timestampProvider);
            return (F)((Default)this.$());
        }

        @Override
        public F setTypeEvaluatorPersistable(PersistenceTypeEvaluator typeEvaluatorPersistable) {
            this.typeEvaluatorPersistable = typeEvaluatorPersistable;
            return (F)((Default)this.$());
        }

        public F setWriteController(StorageWriteController writeController) {
            super.setWriteController(writeController);
            if (this.connectionFoundation != null) {
                this.connectionFoundation.setWriteController(writeController);
            }
            return (F)((Default)this.$());
        }

        private void initializeEmbeddedStorageRootTypeIdProvider(StorageRootTypeIdProvider rootTypeIdProvider, PersistenceTypeManager typeIdLookup) {
            if (rootTypeIdProvider instanceof EmbeddedStorageRootTypeIdProvider) {
                ((EmbeddedStorageRootTypeIdProvider)rootTypeIdProvider).initialize(typeIdLookup);
            }
        }

        protected StorageObjectIdRangeEvaluator ensureObjectIdRangeEvaluator() {
            PersistenceObjectIdProvider oip = this.getConnectionFoundation().getObjectIdProvider();
            return (min, max) -> {
                if (max > oip.currentObjectId()) {
                    oip.updateCurrentObjectId(max);
                }
            };
        }

        protected EmbeddedStorageObjectRegistryCallback ensureObjectIdsSelector() {
            return this.getConnectionFoundation().getObjectRegistryCallback();
        }

        public void executeTypeHandlerRegistration(PersistenceTypeHandlerRegistration<Binary> typeHandlerRegistration) {
            this.getConnectionFoundation().executeTypeHandlerRegistration(typeHandlerRegistration);
        }

        @Override
        public F registerTypeHandler(PersistenceTypeHandler<Binary, ?> typeHandler) {
            this.getConnectionFoundation().registerCustomTypeHandler(typeHandler);
            return (F)((Default)this.$());
        }

        @Override
        public F registerTypeHandlers(Iterable<? extends PersistenceTypeHandler<Binary, ?>> typeHandlers) {
            this.getConnectionFoundation().registerCustomTypeHandlers(typeHandlers);
            return (F)((Default)this.$());
        }

        protected Database ensureDatabase() {
            String databaseName = this.getDataBaseName();
            Databases databases = this.getDatabases();
            Database database = databases.ensureStoragelessDatabase(databaseName);
            return database;
        }

        protected PersistenceTypeEvaluator ensureTypeEvaluatorPersistable() {
            return Persistence::isPersistable;
        }

        protected Reference<PersistenceLiveStorerRegistry> ensureLiveStorerRegistryReference() {
            return Reference.New(null);
        }

        public StorageSystem createStorageSystem() {
            return super.createStorageSystem();
        }

        @Override
        public synchronized EmbeddedStorageManager createEmbeddedStorageManager(Object root) {
            logger.info("Creating embedded storage manager");
            Database database = this.ensureDatabase();
            EmbeddedStorageConnectionFoundation<?> ecf = this.getConnectionFoundation();
            ecf.setLiveStorerRegistryReference((Reference<PersistenceLiveStorerRegistry>)this.getLiveStorerRegistryReference());
            if (root != null) {
                ecf.getRootResolverProvider().setRoot(root);
            }
            PersistenceRootsProvider prp = ecf.getRootsProvider();
            PersistenceTypeHandlerManager thm = ecf.getTypeHandlerManager();
            thm.initialize();
            StorageSystem stm = ecf.getStorageSystem();
            Default.initializeTypeDictionary(stm, ecf);
            this.setLiveObjectIdChecker(ecf.getObjectRegistryCallback());
            this.initializeEmbeddedStorageRootTypeIdProvider(this.getRootTypeIdProvider(), (PersistenceTypeManager)thm);
            EmbeddedStorageManager.Default esm = EmbeddedStorageManager.New(database, stm.configuration(), ecf, prp);
            database.setStorage((StorageManager)esm);
            ecf.setPersister((Persister)database);
            return esm;
        }

        private static void initializeTypeDictionary(StorageSystem stm, EmbeddedStorageConnectionFoundation<?> ecf) {
            StorageTypeDictionary std = stm.typeDictionary();
            PersistenceTypeDictionary ptd = ecf.getTypeDictionaryProvider().provideTypeDictionary();
            std.initialize(ptd);
            ptd.setTypeDescriptionRegistrationObserver((PersistenceTypeDefinitionRegistrationObserver)std);
        }
    }

    public static interface Creator {
        public EmbeddedStorageFoundation<?> createEmbeddedStorageFoundation();
    }
}

