/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.reference.Swizzling;
import one.microstream.storage.restadapter.types.EmbeddedStorageRestAdapter;
import one.microstream.storage.restadapter.types.ObjectReferenceWrapper;

public class ObjectDescription {
    private long objectId;
    private Object[] values;
    private Object primitiveInstance;
    private PersistenceTypeDefinition persistenceTypeDefinition;
    private long length;
    private ObjectDescription[] references;
    private Long[] variableLength;

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public Object[] getValues() {
        return this.values;
    }

    public void setValues(Object[] values) {
        this.values = values;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long variableSize) {
        this.length = variableSize;
    }

    public void setVariableLength(Long[] objects) {
        this.variableLength = objects;
    }

    public Long[] getVariableLength() {
        return this.variableLength;
    }

    public ObjectDescription[] getReferences() {
        return this.references;
    }

    public void setReferences(ObjectDescription[] references) {
        this.references = references;
    }

    public Object getPrimitiveInstance() {
        return this.primitiveInstance;
    }

    public void setPrimitiveInstance(Object primitiveInstance) {
        this.primitiveInstance = primitiveInstance;
    }

    public PersistenceTypeDefinition getPersistenceTypeDefinition() {
        return this.persistenceTypeDefinition;
    }

    public void setPersistenceTypeDefinition(PersistenceTypeDefinition persistenceTypeDefinition) {
        this.persistenceTypeDefinition = persistenceTypeDefinition;
    }

    public boolean hasPrimitiveObjectInstance() {
        return this.primitiveInstance != null;
    }

    public void resolveReferences(long fixedOffset, long fixedLength, long variableOffset, long variableLength, EmbeddedStorageRestAdapter storageRestAdapter) {
        int variableIndex;
        ArrayList resolvedReferences = new ArrayList();
        Arrays.stream(this.values).skip(fixedOffset).limit(fixedLength).filter(ObjectReferenceWrapper.class::isInstance).map(ObjectReferenceWrapper.class::cast).map(wrapper -> this.resolveReference((ObjectReferenceWrapper)wrapper, storageRestAdapter)).forEach(resolvedReferences::add);
        if (variableLength > 0L && (variableIndex = (int)this.length) < this.values.length) {
            Arrays.stream((Object[])this.values[variableIndex]).skip(variableOffset).limit(variableLength).flatMap(this::flatMapToWrappers).map(wrapper -> this.resolveReference((ObjectReferenceWrapper)wrapper, storageRestAdapter)).forEach(resolvedReferences::add);
        }
        this.references = resolvedReferences.toArray(new ObjectDescription[resolvedReferences.size()]);
    }

    private Stream<ObjectReferenceWrapper> flatMapToWrappers(Object data) {
        if (data instanceof ObjectReferenceWrapper) {
            return Stream.of((ObjectReferenceWrapper)data);
        }
        if (data instanceof Object[]) {
            return Arrays.stream((Object[])data).flatMap(this::flatMapToWrappers);
        }
        return Stream.empty();
    }

    private ObjectDescription resolveReference(ObjectReferenceWrapper wrapper, EmbeddedStorageRestAdapter storageRestAdapter) {
        long oid = wrapper.getObjectId();
        return oid == Swizzling.nullId() ? null : storageRestAdapter.getStorageObject(oid);
    }
}

