/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import java.util.ArrayList;
import java.util.List;
import one.microstream.X;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.PersistenceObjectRegistry;
import one.microstream.persistence.types.PersistenceRootsView;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryAssembler;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.restadapter.exceptions.StorageRestAdapterException;
import one.microstream.storage.restadapter.types.ObjectDescription;
import one.microstream.storage.restadapter.types.ViewerBinaryPersistenceManager;
import one.microstream.storage.restadapter.types.ViewerRootDescription;
import one.microstream.storage.types.StorageManager;
import one.microstream.storage.types.StorageRawFileStatistics;

public interface EmbeddedStorageRestAdapter {
    public ObjectDescription getStorageObject(long var1);

    public ObjectDescription getConstant(long var1);

    public List<ViewerRootDescription> getRoots();

    public ViewerRootDescription getRoot();

    public String getTypeDictionary();

    public StorageRawFileStatistics getFileStatistics();

    public static EmbeddedStorageRestAdapter New(StorageManager storage) {
        X.notNull((Object)storage);
        return new Default(ViewerBinaryPersistenceManager.New(storage), storage);
    }

    public static class Default
    implements EmbeddedStorageRestAdapter {
        private final ViewerBinaryPersistenceManager viewerPersistenceManager;
        private final StorageManager storageManager;

        Default(ViewerBinaryPersistenceManager viewerPersistenceManager, StorageManager storageManager) {
            this.viewerPersistenceManager = viewerPersistenceManager;
            this.storageManager = storageManager;
        }

        @Override
        public ObjectDescription getStorageObject(long objectId) {
            Persistence.IdType idType = Persistence.IdType.determineFromValue((long)objectId);
            if (idType == Persistence.IdType.CID) {
                return this.getConstant(objectId);
            }
            try {
                return this.viewerPersistenceManager.getStorageObject(objectId);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof StorageException) {
                    throw new StorageRestAdapterException(e.getCause().getMessage());
                }
                throw e;
            }
        }

        @Override
        public ObjectDescription getConstant(long objectId) {
            return this.viewerPersistenceManager.getStorageConstant(objectId);
        }

        @Override
        public List<ViewerRootDescription> getRoots() {
            PersistenceObjectRegistry registry = this.storageManager.persistenceManager().objectRegistry();
            PersistenceRootsView roots = this.storageManager.viewRoots();
            ArrayList<ViewerRootDescription> rootDescriptions = new ArrayList<ViewerRootDescription>();
            roots.iterateEntries((id, root) -> rootDescriptions.add(new ViewerRootDescription((String)id, registry.lookupObjectId(root))));
            return rootDescriptions;
        }

        @Override
        public ViewerRootDescription getRoot() {
            PersistenceObjectRegistry registry = this.storageManager.persistenceManager().objectRegistry();
            PersistenceRootsView roots = this.storageManager.viewRoots();
            Object defaultRoot = roots.rootReference().get();
            if (defaultRoot != null) {
                return new ViewerRootDescription(PersistenceRootsView.rootIdentifier(), registry.lookupObjectId(defaultRoot));
            }
            return new ViewerRootDescription(PersistenceRootsView.rootIdentifier(), 0L);
        }

        @Override
        public String getTypeDictionary() {
            PersistenceTypeDictionaryAssembler assembler = PersistenceTypeDictionaryAssembler.New();
            return assembler.assemble((PersistenceTypeDictionary)this.storageManager.typeDictionary());
        }

        @Override
        public StorageRawFileStatistics getFileStatistics() {
            return this.storageManager.createStorageStatistics();
        }
    }
}

