/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import java.util.ServiceLoader;
import one.microstream.collections.EqHashTable;
import one.microstream.storage.restadapter.types.StorageViewDataConverter;
import one.microstream.storage.restadapter.types.StorageViewDataConverterProvider;

public interface StorageViewDataConverterRegistry
extends StorageViewDataConverterProvider {
    @Override
    public StorageViewDataConverter getConverter(String var1);

    public boolean addConverter(StorageViewDataConverter var1, String var2);

    public static StorageViewDataConverterRegistry New() {
        Default registry = new Default();
        ServiceLoader<StorageViewDataConverter> serviceLoader = ServiceLoader.load(StorageViewDataConverter.class);
        for (StorageViewDataConverter converter : serviceLoader) {
            for (String format : converter.getFormatStrings()) {
                registry.addConverter(converter, format);
            }
        }
        return registry;
    }

    public static class Default
    implements StorageViewDataConverterRegistry {
        private final EqHashTable<String, StorageViewDataConverter> converters = EqHashTable.New();

        Default() {
        }

        @Override
        public StorageViewDataConverter getConverter(String format) {
            return (StorageViewDataConverter)this.converters.get((Object)format);
        }

        @Override
        public boolean addConverter(StorageViewDataConverter converter, String format) {
            return this.converters.add((Object)format, (Object)converter);
        }
    }
}

