/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import java.util.ArrayList;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.storage.restadapter.types.ObjectDescription;
import one.microstream.storage.restadapter.types.ValueReaderArrayOfLists;
import one.microstream.storage.restadapter.types.ValueReaderPrimitive;
import one.microstream.storage.restadapter.types.ValueReaderPrimitiveByteList;
import one.microstream.storage.restadapter.types.ValueReaderPrimitiveCharList;
import one.microstream.storage.restadapter.types.ValueReaderPrimitiveList;
import one.microstream.storage.restadapter.types.ValueReaderReference;
import one.microstream.storage.restadapter.types.ValueReaderReferenceList;
import one.microstream.storage.restadapter.types.ValueReaderStringList;

public interface ValueReader {
    public Object readValue(Binary var1, long var2);

    public long getBinarySize(Binary var1, long var2);

    default public long getVariableLength(Binary binary, long offset) {
        return -1L;
    }

    public static ValueReader[] deriveValueReaders(PersistenceTypeDefinition td) {
        XGettingEnum members = td.instanceMembers();
        ValueReader[] valueReaders = new ValueReader[members.intSize()];
        int i = 0;
        for (PersistenceTypeDefinitionMember member : td.instanceMembers()) {
            valueReaders[i++] = ValueReader.deriveValueReader(member);
        }
        return valueReaders;
    }

    public static ValueReader deriveValueReader(PersistenceTypeDefinitionMember member) {
        if (member.isPrimitive()) {
            return new ValueReaderPrimitive(member);
        }
        if (member.isReference()) {
            return new ValueReaderReference();
        }
        if (member.isVariableLength()) {
            return ValueReader.deriveVariableLengthValueReader(member);
        }
        throw new NotImplementedYetError();
    }

    public static ValueReader deriveVariableLengthValueReader(PersistenceTypeDefinitionMember member) {
        if (member.typeName().contentEquals(PersistenceTypeDictionary.Symbols.typeChars())) {
            return new ValueReaderPrimitiveCharList(member);
        }
        if (member.typeName().contentEquals(PersistenceTypeDictionary.Symbols.typeBytes())) {
            return new ValueReaderPrimitiveByteList(member);
        }
        if (member.typeName().contentEquals(PersistenceTypeDictionary.Symbols.typeComplex())) {
            return ValueReader.deriveComplexVariableLengthValueReader(member);
        }
        throw new NotImplementedYetError();
    }

    public static ValueReader deriveComplexVariableLengthValueReader(PersistenceTypeDefinitionMember member) {
        PersistenceTypeDescriptionMemberFieldGenericComplex memberComplex = (PersistenceTypeDescriptionMemberFieldGenericComplex)member;
        XGettingSequence members = memberComplex.members();
        if (members.size() == 1L) {
            PersistenceTypeDescriptionMemberFieldGeneric listMember = (PersistenceTypeDescriptionMemberFieldGeneric)members.first();
            if (listMember.isReference()) {
                return new ValueReaderReferenceList(member);
            }
            if (listMember.isPrimitive()) {
                return new ValueReaderPrimitiveList((PersistenceTypeDefinitionMember)listMember);
            }
            if (listMember.typeName().contentEquals(PersistenceTypeDictionary.Symbols.typeChars())) {
                return new ValueReaderStringList((PersistenceTypeDefinitionMember)listMember);
            }
            if (listMember.typeName().contentEquals(PersistenceTypeDictionary.Symbols.typeBytes())) {
                return new ValueReaderPrimitiveByteList((PersistenceTypeDefinitionMember)listMember);
            }
        } else {
            return new ValueReaderArrayOfLists(member);
        }
        throw new NotImplementedYetError();
    }

    public static void readObjectValues(Binary binary, ValueReader[] valueReaders, long[] valueOffsets, ObjectDescription objectDescription) {
        Object[] objectValues = new Object[valueReaders.length];
        ArrayList<Long> variableLength = new ArrayList<Long>();
        long offset = 0L;
        for (int i = 0; i < objectValues.length; ++i) {
            objectValues[i] = valueReaders[i].readValue(binary, offset);
            long size = valueReaders[i].getBinarySize(binary, offset);
            long variableSize = valueReaders[i].getVariableLength(binary, offset);
            offset += size;
            if (variableSize <= -1L) continue;
            variableLength.add(variableSize);
        }
        objectDescription.setLength(objectValues.length - variableLength.size());
        objectDescription.setVariableLength(variableLength.size() > 0 ? variableLength.toArray(new Long[0]) : null);
        objectDescription.setValues(objectValues);
    }
}

