/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.persistence.types.PersistenceTypeDefinitionMemberFieldGenericComplex;
import one.microstream.storage.restadapter.types.ValueReader;
import one.microstream.storage.restadapter.types.ValueReaderVariableLength;

public class ValueReaderArrayOfLists
extends ValueReaderVariableLength {
    private final ValueReader[] readers;

    public ValueReaderArrayOfLists(PersistenceTypeDefinitionMember typeDefinition) {
        super(typeDefinition);
        PersistenceTypeDefinitionMemberFieldGenericComplex.Default instance = (PersistenceTypeDefinitionMemberFieldGenericComplex.Default)typeDefinition;
        XGettingSequence instanceMembers = instance.members();
        this.readers = new ValueReader[instanceMembers.intSize()];
        for (int i = 0; i < instanceMembers.intSize(); ++i) {
            this.readers[i] = ValueReader.deriveValueReader((PersistenceTypeDefinitionMember)instanceMembers.at((long)i));
        }
    }

    @Override
    public Object readValue(Binary binary, long offset) {
        long listOffset = Binary.toBinaryListElementsOffset((long)offset);
        int elementCount = (int)binary.getBinaryListElementCountUnvalidating(offset);
        Object[] lists = new Object[elementCount];
        for (int j = 0; j < elementCount; ++j) {
            Object[] objectValues = new Object[this.readers.length];
            for (int i = 0; i < this.readers.length; ++i) {
                objectValues[i] = this.readers[i].readValue(binary, listOffset);
                long size = this.readers[i].getBinarySize(binary, listOffset);
                listOffset += size;
            }
            lists[j] = objectValues;
        }
        return lists;
    }
}

