/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restadapter.types;

import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceTypeDefinitionMember;
import one.microstream.storage.restadapter.types.ObjectReferenceWrapper;
import one.microstream.storage.restadapter.types.ValueReaderVariableLength;
import one.microstream.storage.restadapter.types.ViewerBinaryPrimitivesReader;

public class ValueReaderReferenceList
extends ValueReaderVariableLength {
    public ValueReaderReferenceList(PersistenceTypeDefinitionMember typeDefinition) {
        super(typeDefinition);
    }

    @Override
    public Object readValue(Binary binary, long offset) {
        long listOffset = Binary.toBinaryListElementsOffset((long)offset);
        int elementCount = (int)binary.getBinaryListElementCountUnvalidating(offset);
        Object[] references = new Object[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            references[i] = new ObjectReferenceWrapper(ViewerBinaryPrimitivesReader.readReference(binary, listOffset));
            listOffset += (long)Binary.objectIdByteLength();
        }
        return references;
    }

    @Override
    public long getBinarySize(Binary binary, long offset) {
        return binary.getBinaryListTotalByteLength(offset);
    }
}

