/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

public interface ObjectRequest {
    public long objectId();

    public Long valueLength();

    public Long fixedOffset();

    public Long fixedLength();

    public Long variableOffset();

    public Long variableLength();

    public Boolean references();

    public static ObjectRequest New(long objectId) {
        return new Default(objectId, null, null, null, null, null, null);
    }

    public static Builder Builder(long objectId) {
        return new Builder.Default(objectId);
    }

    public static class Default
    implements ObjectRequest {
        private final long objectId;
        private final Long valueLength;
        private final Long fixedOffset;
        private final Long fixedLength;
        private final Long variableOffset;
        private final Long variableLength;
        private final Boolean references;

        Default(long objectId, Long valueLength, Long fixedOffset, Long fixedLength, Long variableOffset, Long variableLength, Boolean references) {
            this.objectId = objectId;
            this.valueLength = valueLength;
            this.fixedOffset = fixedOffset;
            this.fixedLength = fixedLength;
            this.variableOffset = variableOffset;
            this.variableLength = variableLength;
            this.references = references;
        }

        @Override
        public long objectId() {
            return this.objectId;
        }

        @Override
        public Long valueLength() {
            return this.valueLength;
        }

        @Override
        public Long fixedOffset() {
            return this.fixedOffset;
        }

        @Override
        public Long fixedLength() {
            return this.fixedLength;
        }

        @Override
        public Long variableOffset() {
            return this.variableOffset;
        }

        @Override
        public Long variableLength() {
            return this.variableLength;
        }

        @Override
        public Boolean references() {
            return this.references;
        }
    }

    public static interface Builder {
        public Builder valueLength(Long var1);

        default public Builder fixedRange(long offset, long length) {
            return this.fixedOffset(offset).fixedLength(length);
        }

        public Builder fixedOffset(Long var1);

        public Builder fixedLength(Long var1);

        default public Builder variableRange(long offset, long length) {
            return this.variableOffset(offset).variableLength(length);
        }

        public Builder variableOffset(Long var1);

        public Builder variableLength(Long var1);

        default public Builder withReferences() {
            return this.references(true);
        }

        default public Builder withoutReferences() {
            return this.references(false);
        }

        public Builder references(Boolean var1);

        public ObjectRequest build();

        public static class Default
        implements Builder {
            private final long objectId;
            private Long valueLength;
            private Long fixedOffset;
            private Long fixedLength;
            private Long variableOffset;
            private Long variableLength;
            private Boolean references;

            Default(long objectId) {
                this.objectId = objectId;
            }

            @Override
            public Builder valueLength(Long valueLength) {
                this.valueLength = valueLength;
                return this;
            }

            @Override
            public Builder fixedOffset(Long fixedOffset) {
                this.fixedOffset = fixedOffset;
                return this;
            }

            @Override
            public Builder fixedLength(Long fixedLength) {
                this.fixedLength = fixedLength;
                return this;
            }

            @Override
            public Builder variableOffset(Long variableOffset) {
                this.variableOffset = variableOffset;
                return this;
            }

            @Override
            public Builder variableLength(Long variableLength) {
                this.variableLength = variableLength;
                return this;
            }

            @Override
            public Builder references(Boolean references) {
                this.references = references;
                return this;
            }

            @Override
            public ObjectRequest build() {
                return new one.microstream.storage.restclient.types.ObjectRequest$Default(this.objectId, this.valueLength, this.fixedOffset, this.fixedLength, this.variableOffset, this.variableLength, this.references);
            }
        }
    }
}

