/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDescriptionMember;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGeneric;
import one.microstream.persistence.types.PersistenceTypeDescriptionMemberFieldGenericComplex;
import one.microstream.storage.restadapter.types.ViewerObjectDescription;
import one.microstream.storage.restadapter.types.ViewerRootDescription;
import one.microstream.storage.restclient.exceptions.StorageViewExceptionMissingTypeDescription;
import one.microstream.storage.restclient.types.ObjectRequest;
import one.microstream.storage.restclient.types.StorageRestClient;
import one.microstream.storage.restclient.types.StorageViewComplexRangeEntry;
import one.microstream.storage.restclient.types.StorageViewConfiguration;
import one.microstream.storage.restclient.types.StorageViewElement;
import one.microstream.storage.restclient.types.StorageViewObject;
import one.microstream.storage.restclient.types.StorageViewRange;
import one.microstream.storage.restclient.types.StorageViewValue;
import one.microstream.storage.restclient.types.ValueRenderer;

public interface StorageView {
    public StorageViewElement root();

    public static StorageView New(StorageViewConfiguration configuration, StorageRestClient client) {
        return new Default(configuration, client);
    }

    public static class Default
    implements StorageView {
        private final StorageViewConfiguration configuration;
        private final StorageRestClient client;
        private Map<Long, PersistenceTypeDescription> typeDictionary;

        Default(StorageViewConfiguration configuration, StorageRestClient client) {
            this.configuration = configuration;
            this.client = client;
        }

        @Override
        public StorageViewElement root() {
            ViewerRootDescription rootDesc = this.client.requestRoot();
            if (rootDesc.getObjectId() > 0L) {
                ViewerObjectDescription objectDesc = this.client.requestObject(this.objectRequestBuilder(rootDesc.getObjectId()).build());
                return this.createElement(null, rootDesc.getName(), objectDesc);
            }
            return new StorageViewValue.Default(null, null, rootDesc.getName(), "NOT YET DEFINED", null);
        }

        List<StorageViewElement> members(StorageViewObject parent) {
            int varLength;
            int index;
            long objectId = parent.objectId();
            ArrayList<StorageViewElement> members = new ArrayList<StorageViewElement>();
            ViewerObjectDescription objectDesc = this.client.requestObject(this.objectRequestBuilder(objectId).withReferences().variableLength(0L).build());
            XGettingSequence<? extends PersistenceTypeDescriptionMember> typeMembers = this.getTypeMembers(objectDesc);
            Iterator<ViewerObjectDescription> references = Arrays.asList(objectDesc.getReferences()).iterator();
            Object[] data = objectDesc.getData();
            int length = Integer.parseInt(objectDesc.getLength());
            for (index = 0; index < length; ++index) {
                PersistenceTypeDescriptionMember typeMember = (PersistenceTypeDescriptionMember)typeMembers.at((long)index);
                members.add(this.createElement(parent, typeMember.name(), references, typeMember, data[index]));
            }
            String[] varLengthArray = objectDesc.getVariableLength();
            int n = varLength = varLengthArray != null && varLengthArray.length == 1 ? Integer.parseInt(varLengthArray[0]) : 0;
            if (varLength > 0) {
                if (members.isEmpty()) {
                    members.addAll(this.variableMembers(parent, objectId, 0L, varLength));
                } else {
                    PersistenceTypeDescriptionMember typeMember = (PersistenceTypeDescriptionMember)typeMembers.at((long)index);
                    members.add(new StorageViewRange.Default(this, parent, typeMember.name(), objectId, 0L, varLength));
                }
            }
            return members;
        }

        List<StorageViewElement> variableMembers(StorageViewElement parent, long objectId, long offset, long length) {
            long range = this.configuration.elementRangeMaximumLength();
            if (length > range) {
                return this.ranges(parent, objectId, offset, length, range, range);
            }
            ArrayList<StorageViewElement> members = new ArrayList<StorageViewElement>();
            ViewerObjectDescription objectDesc = this.client.requestObject(this.objectRequestBuilder(objectId).withReferences().fixedLength(0L).variableRange(offset, length).build());
            XGettingSequence<? extends PersistenceTypeDescriptionMember> typeMembers = this.getTypeMembers(objectDesc);
            long memberOffset = Long.parseLong(objectDesc.getLength());
            PersistenceTypeDescriptionMemberFieldGenericComplex varMember = (PersistenceTypeDescriptionMemberFieldGenericComplex)typeMembers.at(memberOffset);
            Iterator<ViewerObjectDescription> references = Arrays.asList(objectDesc.getReferences()).iterator();
            List<Object> dataList = Default.asList(objectDesc.getData()[0]);
            XGettingSequence elemMembers = varMember.members();
            if (elemMembers.size() == 1L) {
                PersistenceTypeDescriptionMemberFieldGeneric elemMember = (PersistenceTypeDescriptionMemberFieldGeneric)elemMembers.get();
                if (elemMember.isReference()) {
                    long index = offset;
                    for (Object dataElem : dataList) {
                        members.add(this.createElement(parent, "[" + index++ + "]", references, (PersistenceTypeDescriptionMember)elemMember, dataElem));
                    }
                } else {
                    long index = offset;
                    for (Object dataElem : dataList) {
                        members.add(new StorageViewValue.Default(this, parent, "[" + index++ + "]", this.value(String.valueOf(dataElem), null, elemMember.typeName()), elemMember.typeName()));
                    }
                }
            } else {
                long index = offset;
                for (Object dataElem : dataList) {
                    ArrayList<StorageViewElement> memberMembers = new ArrayList<StorageViewElement>();
                    int subIndex = 0;
                    List<Object> dataElemList = Default.asList(dataElem);
                    for (PersistenceTypeDescriptionMemberFieldGeneric elemMember : elemMembers) {
                        Object subDataElem = dataElemList.get(subIndex++);
                        if (elemMember.isReference()) {
                            memberMembers.add(this.createElement(parent, elemMember.name(), references, (PersistenceTypeDescriptionMember)elemMember, subDataElem));
                            continue;
                        }
                        memberMembers.add(new StorageViewValue.Default(this, parent, elemMember.name(), this.value(String.valueOf(subDataElem), null, elemMember.typeName()), elemMember.typeName()));
                    }
                    members.add(new StorageViewComplexRangeEntry.Default(this, parent, "[" + index++ + "]", "", memberMembers));
                }
            }
            return members;
        }

        private static List<Object> asList(Object listOrArray) {
            return listOrArray instanceof List ? (List<Object>)listOrArray : Arrays.asList((Object[])listOrArray);
        }

        private List<StorageViewElement> ranges(StorageViewElement parent, long objectId, long offset, long length, long range, long maxRange) {
            long nextRange = range * maxRange;
            if (length > nextRange) {
                return this.ranges(parent, objectId, offset, length, nextRange, maxRange);
            }
            ArrayList<StorageViewElement> ranges = new ArrayList<StorageViewElement>(X.checkArrayRange((long)(length / range + 1L)));
            for (long i = 0L; i < length; i += range) {
                long rangeOffset = i + offset;
                long rangeLength = Math.min(range, length - i);
                long rangeEnd = rangeOffset + rangeLength - 1L;
                String name = "[" + rangeOffset + ".." + rangeEnd + "]";
                ranges.add(new StorageViewRange.Default(this, parent, name, objectId, rangeOffset, rangeLength));
            }
            return ranges;
        }

        private StorageViewElement createElement(StorageViewElement parent, String name, Iterator<ViewerObjectDescription> references, PersistenceTypeDescriptionMember member, Object data) {
            ViewerObjectDescription reference;
            if (references.hasNext() && (reference = references.next()) != null) {
                return this.createElement(parent, name, reference);
            }
            String dataString = member.isReference() ? "null" : this.value(String.valueOf(data), null, member.typeName());
            return new StorageViewValue.Default(this, parent, name, dataString, member.typeName());
        }

        private StorageViewElement createElement(StorageViewElement parent, String name, ViewerObjectDescription reference) {
            PersistenceTypeDescription typeDescription = this.getTypeDescription(reference);
            if (reference.getSimplified()) {
                String value = this.value(String.valueOf(reference.getData()[0]), reference, typeDescription.typeName());
                return new StorageViewObject.Simple(this, parent, name, value, typeDescription, Long.parseLong(reference.getObjectId()));
            }
            return new StorageViewObject.Complex(this, parent, name, null, typeDescription, Long.parseLong(reference.getObjectId()));
        }

        private String value(String value, ViewerObjectDescription reference, String typeName) {
            ValueRenderer valueRenderer = this.configuration.provideValueRenderer(typeName);
            return valueRenderer != null ? (String)valueRenderer.apply(value, reference) : value;
        }

        private XGettingSequence<? extends PersistenceTypeDescriptionMember> getTypeMembers(ViewerObjectDescription objectDesc) {
            return this.getTypeMembers(this.getTypeDescription(objectDesc));
        }

        private XGettingSequence<? extends PersistenceTypeDescriptionMember> getTypeMembers(PersistenceTypeDescription typeDesc) {
            return (XGettingSequence)typeDesc.allMembers().filterTo((Consumer)BulkList.New(), m -> !m.isEnumConstant());
        }

        private PersistenceTypeDescription getTypeDescription(ViewerObjectDescription obj) {
            PersistenceTypeDescription typeDescription;
            long typeId = Long.parseLong(obj.getTypeId());
            if (this.typeDictionary == null || (typeDescription = this.typeDictionary.get(typeId)) == null) {
                this.typeDictionary = this.client.requestTypeDictionary();
            }
            if ((typeDescription = this.typeDictionary.get(typeId)) == null) {
                throw new StorageViewExceptionMissingTypeDescription(typeId);
            }
            return typeDescription;
        }

        private ObjectRequest.Builder objectRequestBuilder(long objectId) {
            return ObjectRequest.Builder(objectId).valueLength(this.configuration.maxValueLength());
        }
    }
}

