/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

import one.microstream.storage.restclient.types.ValueRenderer;

public interface StorageViewConfiguration
extends ValueRenderer.Provider {
    public long elementRangeMaximumLength();

    public long maxValueLength();

    public static StorageViewConfiguration Default() {
        return new Default(100L, 10000L, ValueRenderer.DefaultProvider());
    }

    public static StorageViewConfiguration New(long elementRangeMaximumLength, long maxValueLength, ValueRenderer.Provider valueRendererProvider) {
        return new Default(elementRangeMaximumLength, maxValueLength, valueRendererProvider);
    }

    public static class Default
    implements StorageViewConfiguration {
        private final long elementRangeMaximumLength;
        private final long maxValueLength;
        private final ValueRenderer.Provider valueRendererProvider;

        Default(long elementRangeMaximumLength, long maxValueLength, ValueRenderer.Provider valueRendererProvider) {
            this.elementRangeMaximumLength = elementRangeMaximumLength;
            this.maxValueLength = maxValueLength;
            this.valueRendererProvider = valueRendererProvider;
        }

        @Override
        public long elementRangeMaximumLength() {
            return this.elementRangeMaximumLength;
        }

        @Override
        public long maxValueLength() {
            return this.maxValueLength;
        }

        @Override
        public ValueRenderer provideValueRenderer(String typeName) {
            return this.valueRendererProvider.provideValueRenderer(typeName);
        }
    }
}

