/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

import java.util.List;
import one.microstream.chars.VarString;
import one.microstream.storage.restclient.types.StorageView;

public interface StorageViewElement {
    public StorageView view();

    public StorageViewElement parent();

    default public <T extends StorageViewElement> T parentOfType(Class<T> parentType) {
        StorageViewElement parent = this;
        while ((parent = parent.parent()) != null) {
            if (!parentType.isInstance(parent)) continue;
            return (T)((StorageViewElement)parentType.cast(parent));
        }
        return null;
    }

    public String name();

    public String value();

    public String simpleTypeName();

    public String qualifiedTypeName();

    public boolean hasMembers();

    public List<StorageViewElement> members(boolean var1);

    public static abstract class Abstract
    implements StorageViewElement {
        private final StorageView.Default view;
        private final StorageViewElement parent;
        private final String name;
        private final String value;
        private final String typeName;

        Abstract(StorageView.Default view, StorageViewElement parent, String name, String value, String typeName) {
            this.view = view;
            this.parent = parent;
            this.name = name;
            this.value = value;
            this.typeName = typeName;
        }

        @Override
        public StorageView.Default view() {
            return this.view;
        }

        @Override
        public StorageViewElement parent() {
            return this.parent;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String simpleTypeName() {
            String qualifiedTypeName = this.qualifiedTypeName();
            int i = qualifiedTypeName.lastIndexOf(46);
            return i == -1 ? qualifiedTypeName : qualifiedTypeName.substring(i + 1);
        }

        @Override
        public String qualifiedTypeName() {
            String typeName = this.typeName;
            return typeName == null ? "" : (typeName.startsWith("[") ? Abstract.qualifiedName(typeName) : typeName);
        }

        private static String qualifiedName(String binaryName) {
            switch (binaryName.charAt(0)) {
                case '[': {
                    return Abstract.qualifiedName(binaryName.substring(1)).concat("[]");
                }
                case 'L': {
                    return binaryName.substring(1, binaryName.length() - 1);
                }
                case 'B': {
                    return "byte";
                }
                case 'C': {
                    return "char";
                }
                case 'D': {
                    return "double";
                }
                case 'F': {
                    return "float";
                }
                case 'I': {
                    return "int";
                }
                case 'J': {
                    return "long";
                }
                case 'S': {
                    return "short";
                }
                case 'Z': {
                    return "boolean";
                }
            }
            return binaryName;
        }

        public String toString() {
            String name = this.name;
            if (name != null && name.length() > 0) {
                String typeName;
                VarString vs = VarString.New();
                vs.add(name);
                String value = this.value;
                if (value != null && value.length() > 0) {
                    vs.add(" = ").add(value);
                }
                if ((typeName = this.simpleTypeName()) != null && typeName.length() > 0) {
                    vs.add(" (").add(typeName).add(")");
                }
                return vs.toString();
            }
            return super.toString();
        }
    }
}

