/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

import java.util.List;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.storage.restclient.types.StorageView;
import one.microstream.storage.restclient.types.StorageViewElement;
import one.microstream.storage.restclient.types.StorageViewValue;

public interface StorageViewObject
extends StorageViewValue {
    public PersistenceTypeDescription typeDescription();

    public long objectId();

    public static class Complex
    extends Simple {
        private List<StorageViewElement> members;

        Complex(StorageView.Default view, StorageViewElement parent, String name, String data, PersistenceTypeDescription typeDescription, long objectId) {
            super(view, parent, name, data, typeDescription, objectId);
        }

        @Override
        public boolean hasMembers() {
            return this.typeDescription.allMembers().size() > 0L;
        }

        @Override
        public List<StorageViewElement> members(boolean forceRefresh) {
            if (this.members == null || forceRefresh) {
                this.members = this.view().members(this);
            }
            return this.members;
        }
    }

    public static class Simple
    extends StorageViewValue.Default
    implements StorageViewObject {
        final PersistenceTypeDescription typeDescription;
        final long objectId;

        Simple(StorageView.Default view, StorageViewElement parent, String name, String value, PersistenceTypeDescription typeDescription, long objectId) {
            super(view, parent, name, value, typeDescription.typeName());
            this.typeDescription = typeDescription;
            this.objectId = objectId;
        }

        @Override
        public PersistenceTypeDescription typeDescription() {
            return this.typeDescription;
        }

        @Override
        public long objectId() {
            return this.objectId;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.objectId;
        }
    }
}

