/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

import java.util.List;
import one.microstream.storage.restclient.types.StorageView;
import one.microstream.storage.restclient.types.StorageViewElement;

public interface StorageViewRange
extends StorageViewElement {
    public long offset();

    public long length();

    public static class Default
    extends StorageViewElement.Abstract
    implements StorageViewRange {
        private final long objectId;
        private final long offset;
        private final long length;
        private List<StorageViewElement> members;

        Default(StorageView.Default view, StorageViewElement parent, String name, long objectId, long offset, long length) {
            super(view, parent, name, null, null);
            this.objectId = objectId;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean hasMembers() {
            return true;
        }

        @Override
        public List<StorageViewElement> members(boolean forceRefresh) {
            if (this.members == null || forceRefresh) {
                this.members = this.view().variableMembers(this, this.objectId, this.offset, this.length);
            }
            return this.members;
        }
    }
}

