/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.restclient.types;

import java.util.function.BiFunction;
import one.microstream.chars.VarString;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingTable;
import one.microstream.storage.restadapter.types.ViewerObjectDescription;

public interface ValueRenderer
extends BiFunction<String, ViewerObjectDescription, String> {
    public static Provider DefaultProvider() {
        ValueRenderer stringLiteralRenderer = ValueRenderer.StringLiteral();
        ValueRenderer characterLiteralRenderer = ValueRenderer.CharacterLiteral();
        EqHashTable valueRenderers = EqHashTable.New();
        valueRenderers.put((Object)String.class.getName(), (Object)stringLiteralRenderer);
        valueRenderers.put((Object)StringBuffer.class.getName(), (Object)stringLiteralRenderer);
        valueRenderers.put((Object)StringBuilder.class.getName(), (Object)stringLiteralRenderer);
        valueRenderers.put((Object)VarString.class.getName(), (Object)stringLiteralRenderer);
        valueRenderers.put((Object)Character.TYPE.getName(), (Object)characterLiteralRenderer);
        return new Provider.Default((XGettingTable<String, ValueRenderer>)valueRenderers.immure(), ValueRenderer.Default());
    }

    public static ValueRenderer Default() {
        return (value, reference) -> value;
    }

    public static ValueRenderer StringLiteral() {
        return (value, reference) -> {
            VarString vs = VarString.New((int)(value.length() + 2)).add('\"');
            int len = value.length();
            block9: for (int i = 0; i < len; ++i) {
                char ch = value.charAt(i);
                switch (ch) {
                    case '\b': {
                        vs.add("\\b");
                        continue block9;
                    }
                    case '\t': {
                        vs.add("\\t");
                        continue block9;
                    }
                    case '\n': {
                        vs.add("\\n");
                        continue block9;
                    }
                    case '\f': {
                        vs.add("\\f");
                        continue block9;
                    }
                    case '\r': {
                        vs.add("\\r");
                        continue block9;
                    }
                    case '\"': {
                        vs.add("\\\"");
                        continue block9;
                    }
                    case '\\': {
                        vs.add("\\\\");
                        continue block9;
                    }
                    default: {
                        vs.add(ch);
                    }
                }
            }
            return vs.add('\"').toString();
        };
    }

    public static ValueRenderer CharacterLiteral() {
        return (value, reference) -> {
            VarString vs = VarString.New((int)4).add('\'');
            char ch = value.charAt(0);
            switch (ch) {
                case '\b': {
                    vs.add("\\b");
                    break;
                }
                case '\t': {
                    vs.add("\\t");
                    break;
                }
                case '\n': {
                    vs.add("\\n");
                    break;
                }
                case '\f': {
                    vs.add("\\f");
                    break;
                }
                case '\r': {
                    vs.add("\\r");
                    break;
                }
                case '\'': {
                    vs.add("\\'");
                    break;
                }
                case '\\': {
                    vs.add("\\\\");
                    break;
                }
                default: {
                    vs.add(ch);
                }
            }
            return vs.add('\'').toString();
        };
    }

    public static interface Provider {
        public ValueRenderer provideValueRenderer(String var1);

        public static class Default
        implements Provider {
            private final XGettingTable<String, ValueRenderer> valueRenderers;
            private final ValueRenderer defaultRenderer;

            Default(XGettingTable<String, ValueRenderer> valueRenderers, ValueRenderer defaultRenderer) {
                this.valueRenderers = valueRenderers;
                this.defaultRenderer = defaultRenderer;
            }

            @Override
            public ValueRenderer provideValueRenderer(String typeName) {
                ValueRenderer renderer = (ValueRenderer)this.valueRenderers.get((Object)typeName);
                return renderer != null ? renderer : this.defaultRenderer;
            }
        }
    }
}

