/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.storage.types.StorageBackupFileProvider;
import one.microstream.storage.types.StorageBackupHandler;
import one.microstream.storage.types.StorageBackupItemQueue;
import one.microstream.storage.types.StorageDataFileValidator;
import one.microstream.storage.types.StorageFileWriter;
import one.microstream.storage.types.StorageFileWriterBackupping;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageWriteController;

public interface StorageBackupSetup {
    public StorageBackupFileProvider backupFileProvider();

    public StorageFileWriter.Provider setupWriterProvider(StorageFileWriter.Provider var1);

    public StorageBackupHandler setupHandler(StorageOperationController var1, StorageWriteController var2, StorageDataFileValidator var3);

    public static StorageBackupSetup New(ADirectory backupDirectory) {
        StorageBackupFileProvider backupFileProvider = ((StorageBackupFileProvider.Builder)StorageBackupFileProvider.Builder(backupDirectory.fileSystem()).setDirectory(backupDirectory)).createFileProvider();
        return StorageBackupSetup.New(backupFileProvider);
    }

    public static StorageBackupSetup New(StorageBackupFileProvider backupFileProvider) {
        return new Default((StorageBackupFileProvider)X.notNull((Object)backupFileProvider), StorageBackupItemQueue.New());
    }

    public static final class Default
    implements StorageBackupSetup {
        private final StorageBackupFileProvider backupFileProvider;
        private final StorageBackupItemQueue itemQueue;

        Default(StorageBackupFileProvider backupFileProvider, StorageBackupItemQueue itemQueue) {
            this.backupFileProvider = backupFileProvider;
            this.itemQueue = itemQueue;
        }

        @Override
        public final StorageBackupFileProvider backupFileProvider() {
            return this.backupFileProvider;
        }

        @Override
        public StorageFileWriter.Provider setupWriterProvider(StorageFileWriter.Provider writerProvider) {
            return StorageFileWriterBackupping.Provider(this.itemQueue, writerProvider);
        }

        @Override
        public StorageBackupHandler setupHandler(StorageOperationController operationController, StorageWriteController writeController, StorageDataFileValidator validator) {
            int channelCount = operationController.channelCountProvider().getChannelCount();
            return StorageBackupHandler.New(this, channelCount, this.itemQueue, operationController, writeController, validator);
        }
    }
}

