/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.afs.types.ADirectory;
import one.microstream.storage.types.StorageFileNameProvider;

public interface StorageDirectoryStructureProvider {
    public ADirectory provideChannelDirectory(ADirectory var1, int var2, StorageFileNameProvider var3);

    public static StorageDirectoryStructureProvider New() {
        return new Default();
    }

    public static final class Default
    implements StorageDirectoryStructureProvider {
        static final Default DEFAULT = new Default();

        Default() {
        }

        @Override
        public final ADirectory provideChannelDirectory(ADirectory storageRootDirectory, int channelIndex, StorageFileNameProvider fileNameProvider) {
            String channelDirectoryName = fileNameProvider.provideChannelDirectoryName(channelIndex);
            ADirectory channelDirectory = storageRootDirectory.ensureDirectory(channelDirectoryName);
            channelDirectory.ensureExists();
            return channelDirectory;
        }
    }

    public static interface Defaults {
        public static StorageDirectoryStructureProvider defaultDirectoryStructureProvider() {
            return Default.DEFAULT;
        }
    }
}

