/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.nio.ByteBuffer;
import one.microstream.X;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.functional.ThrowingProcedure;
import one.microstream.math.XMath;
import one.microstream.memory.XMemory;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.binary.types.ChunksBuffer;
import one.microstream.persistence.binary.types.MemoryRangeReader;
import one.microstream.persistence.types.Persistence;
import one.microstream.persistence.types.Unpersistable;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.exceptions.StorageExceptionGarbageCollector;
import one.microstream.storage.exceptions.StorageExceptionInitialization;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelResetablePart;
import one.microstream.storage.types.StorageEntity;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityMarkMonitor;
import one.microstream.storage.types.StorageEntityType;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageEventLogger;
import one.microstream.storage.types.StorageFileManager;
import one.microstream.storage.types.StorageGCZombieOidHandler;
import one.microstream.storage.types.StorageIdAnalysis;
import one.microstream.storage.types.StorageLiveDataFile;
import one.microstream.storage.types.StorageObjectIdMarkQueue;
import one.microstream.storage.types.StorageReferenceMarker;
import one.microstream.storage.types.StorageRootOidSelector;
import one.microstream.storage.types.StorageTypeDictionary;

public interface StorageEntityCache<E extends StorageEntity>
extends StorageChannelResetablePart {
    public StorageTypeDictionary typeDictionary();

    public StorageEntityType<E> lookupType(long var1);

    public boolean incrementalEntityCacheCheck(long var1);

    public boolean incrementalGarbageCollection(long var1, StorageChannel var3);

    public boolean issuedGarbageCollection(long var1, StorageChannel var3);

    public boolean issuedEntityCacheCheck(long var1, StorageEntityCacheEvaluator var3);

    public void copyRoots(ChunksBuffer var1);

    public long cacheSize();

    public long clearCache();

    @Override
    public void reset();

    public static final class Default
    implements StorageEntityCache<StorageEntity.Default>,
    Unpersistable {
        private static boolean experimentalGcEnabled = false;
        private final int channelIndex;
        private final int channelHashModulo;
        private final int channelHashShift;
        private final long rootTypeId;
        private final long markingWaitTimeMs;
        final StorageEntityCacheEvaluator entityCacheEvaluator;
        private final StorageTypeDictionary typeDictionary;
        private final long[] markingOidBuffer;
        private final StorageGCZombieOidHandler zombieOidHandler;
        private final StorageRootOidSelector rootOidSelector;
        private final RootEntityRootOidSelectionIterator rootEntityIterator;
        private final StorageEventLogger eventLogger;
        private StorageFileManager.Default fileManager;
        private final StorageEntityMarkMonitor markMonitor;
        private final StorageObjectIdMarkQueue oidMarkQueue;
        private final StorageReferenceMarker referenceMarker;
        private StorageEntity.Default liveCursor;
        private long usedCacheSize;
        private boolean hasUpdatePendingSweep;
        private long sweepGeneration;
        private long lastSweepStart;
        private long lastSweepEnd;
        private StorageEntity.Default[] oidHashTable;
        private int oidModulo;
        private long oidSize;
        private StorageEntityType.Default[] tidHashTable;
        private int tidModulo;
        private int tidSize;
        private final StorageEntityType.Default typeHead;
        private StorageEntityType.Default typeTail;
        private StorageEntityType.Default rootType;
        private static final long MAX_INT_BOUND = 0x80000000L;

        @Deprecated
        public static void setGarbageCollectionEnabled(boolean enabled) {
            experimentalGcEnabled = enabled;
        }

        Default(int channelIndex, int channelCount, StorageEntityCacheEvaluator cacheEvaluator, StorageTypeDictionary typeDictionary, StorageEntityMarkMonitor markMonitor, StorageGCZombieOidHandler zombieOidHandler, StorageRootOidSelector rootOidSelector, long rootTypeId, StorageObjectIdMarkQueue oidMarkQueue, StorageEventLogger eventLogger, long markingWaitTimeMs, int markingBufferLength) {
            this.channelIndex = XMath.notNegative((int)channelIndex);
            this.channelHashShift = XMath.log2pow2((int)channelCount);
            this.entityCacheEvaluator = (StorageEntityCacheEvaluator)X.notNull((Object)cacheEvaluator);
            this.typeDictionary = (StorageTypeDictionary)X.notNull((Object)typeDictionary);
            this.markMonitor = (StorageEntityMarkMonitor)X.notNull((Object)markMonitor);
            this.zombieOidHandler = (StorageGCZombieOidHandler)X.notNull((Object)zombieOidHandler);
            this.rootOidSelector = (StorageRootOidSelector)X.notNull((Object)rootOidSelector);
            this.rootTypeId = rootTypeId;
            this.oidMarkQueue = (StorageObjectIdMarkQueue)X.notNull((Object)oidMarkQueue);
            this.eventLogger = eventLogger;
            this.markingWaitTimeMs = XMath.positive((long)markingWaitTimeMs);
            this.channelHashModulo = channelCount - 1;
            this.markingOidBuffer = new long[markingBufferLength];
            this.rootEntityIterator = new RootEntityRootOidSelectionIterator(rootOidSelector);
            this.typeHead = new StorageEntityType.Default(this.channelIndex);
            this.reset();
            this.referenceMarker = markMonitor.provideReferenceMarker(this);
        }

        final long sweepGeneration() {
            return this.sweepGeneration;
        }

        final long lastSweepStart() {
            return this.lastSweepStart;
        }

        final long lastSweepEnd() {
            return this.lastSweepEnd;
        }

        final void initializeStorageManager(StorageFileManager.Default fileManager) {
            if (this.fileManager != null && this.fileManager != fileManager) {
                throw new StorageExceptionInitialization("File manager already initialized.");
            }
            this.fileManager = fileManager;
        }

        @Override
        public final synchronized void reset() {
            this.clearCache();
            this.markMonitor.reset();
            this.oidHashTable = new StorageEntity.Default[1];
            this.oidModulo = this.oidHashTable.length - 1;
            this.oidSize = 0L;
            this.tidHashTable = new StorageEntityType.Default[1];
            this.tidModulo = this.tidHashTable.length - 1;
            this.tidSize = 0;
            this.typeTail = this.typeHead;
            this.typeHead.next = null;
            this.resetLiveCursor();
            this.usedCacheSize = 0L;
            this.rootType = this.getType(this.rootTypeId);
        }

        private void resetLiveCursor() {
            this.liveCursor = null;
        }

        private void enlargeOidHashTable() {
            StorageEntity.Default[] defaultArray;
            int newModulo;
            if (XMath.isGreaterThanOrEqualHighestPowerOf2((int)this.oidHashTable.length)) {
                newModulo = Integer.MAX_VALUE;
                defaultArray = new StorageEntity.Default[Integer.MAX_VALUE];
            } else {
                newModulo = (this.oidModulo + 1 << 1) - 1;
                defaultArray = new StorageEntity.Default[newModulo + 1];
            }
            StorageEntity.Default[] newSlots = defaultArray;
            Default.rebuildOidHashSlots(this.oidHashTable, newSlots, this.channelHashShift, newModulo);
            this.oidHashTable = newSlots;
            this.oidModulo = newModulo;
        }

        private static void rebuildOidHashSlots(StorageEntity.Default[] oldSlots, StorageEntity.Default[] newSlots, int bitShiftCount, int newModulo) {
            StorageEntity.Default[] defaultArray = oldSlots;
            int n = oldSlots.length;
            int n2 = 0;
            while (n2 < n) {
                StorageEntity.Default entry = defaultArray[n2];
                while (entry != null) {
                    StorageEntity.Default next = entry.hashNext;
                    entry.hashNext = newSlots[Default.oidHashIndex(entry.objectId(), bitShiftCount, newModulo)];
                    newSlots[Default.oidHashIndex((long)entry.objectId(), (int)bitShiftCount, (int)newModulo)] = entry;
                    entry = next;
                }
                ++n2;
            }
        }

        private void checkOidHashTableConsolidation() {
            if ((long)(this.oidHashTable.length >>> 1) < this.oidSize) {
                return;
            }
            int newModulo = XMath.pow2BoundMaxed((int)((int)this.oidSize)) - 1;
            StorageEntity.Default[] newSlots = new StorageEntity.Default[newModulo + 1];
            Default.rebuildOidHashSlots(this.oidHashTable, newSlots, this.channelHashShift, newModulo);
            this.oidHashTable = newSlots;
            this.oidModulo = newModulo;
        }

        private void rebuildTidHashTable() {
            int newModulo = (this.tidModulo + 1 << 1) - 1;
            StorageEntityType.Default[] newSlots = new StorageEntityType.Default[newModulo + 1];
            StorageEntityType.Default[] defaultArray = this.tidHashTable;
            int n = this.tidHashTable.length;
            int n2 = 0;
            while (n2 < n) {
                StorageEntityType.Default entries = defaultArray[n2];
                while (entries != null) {
                    StorageEntityType.Default next = entries.hashNext;
                    entries.hashNext = newSlots[Default.tidHashIndex(entries.typeId, newModulo)];
                    newSlots[Default.tidHashIndex((long)entries.typeId, (int)newModulo)] = entries;
                    entries = next;
                }
                ++n2;
            }
            this.tidHashTable = newSlots;
            this.tidModulo = newModulo;
        }

        final StorageEntityType.Default getType(long typeId) {
            StorageEntityType.Default type = this.lookupType(typeId);
            if (type != null) {
                return type;
            }
            return this.addNewType(typeId);
        }

        private StorageEntityType.Default addNewType(long typeId) {
            StorageEntityType.Default type;
            if (this.tidSize >= this.tidModulo) {
                this.rebuildTidHashTable();
            }
            StorageEntityTypeHandler typeHandler = this.typeDictionary.lookupTypeHandlerChecked(typeId);
            int hashIndex = Default.tidHashIndex(typeId, this.tidModulo);
            this.typeTail.next = this.tidHashTable[hashIndex] = (type = new StorageEntityType.Default(this.channelIndex, typeHandler, this.tidHashTable[hashIndex], this.typeHead));
            this.typeTail = this.tidHashTable[hashIndex];
            ++this.tidSize;
            return type;
        }

        static final int hash(long value, int modulo) {
            return (int)(value & (long)modulo);
        }

        static final int hashNormalized(long value, int bitShiftCount, int modulo) {
            return (int)(value >>> bitShiftCount & (long)modulo);
        }

        static final int tidHashIndex(long tid, int tidModulo) {
            return Default.hash(tid, tidModulo);
        }

        static final int oidHashIndex(long objectId, int bitShiftCount, int oidModulo) {
            return Default.hashNormalized(objectId, bitShiftCount, oidModulo);
        }

        static final int oidChannelIndex(long objectId, int channelHashModulo) {
            return Default.hash(objectId, channelHashModulo);
        }

        private int oidHashIndex(long objectId) {
            return Default.oidHashIndex(objectId, this.channelHashShift, this.oidModulo);
        }

        private int oidChannelIndex(long objectId) {
            return Default.oidChannelIndex(objectId, this.channelHashModulo);
        }

        private StorageEntity.Default getOidHashChainHead(long objectId) {
            return this.oidHashTable[this.oidHashIndex(objectId)];
        }

        private void setOidHashChainHead(long objectId, StorageEntity.Default head) {
            this.oidHashTable[this.oidHashIndex((long)objectId)] = head;
        }

        /*
         * Unable to fully structure code
         */
        final void unregisterEntity(StorageEntity.Default item) {
            block1: {
                entry = this.getOidHashChainHead(item.objectId());
                if (entry != item) ** GOTO lbl6
                this.setOidHashChainHead(item.objectId(), item.hashNext);
                break block1;
lbl-1000:
                // 1 sources

                {
                    entry = entry.hashNext;
lbl6:
                    // 2 sources

                    ** while (entry.hashNext != item)
                }
lbl7:
                // 1 sources

                entry.hashNext = item.hashNext;
            }
        }

        public final StorageEntity.Default getEntry(long objectId) {
            StorageEntity.Default e = this.getOidHashChainHead(objectId);
            while (e != null) {
                if (e.objectId() == objectId) {
                    return e;
                }
                e = e.hashNext;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void registerPendingStoreUpdate() {
            StorageEntityMarkMonitor storageEntityMarkMonitor = this.markMonitor;
            synchronized (storageEntityMarkMonitor) {
                this.markMonitor.signalPendingStoreUpdate(this);
                this.markMonitor.resetCompletion();
            }
        }

        final long queryRootObjectId() {
            this.rootOidSelector.reset();
            this.rootType.iterateEntities(this.rootEntityIterator);
            return this.rootOidSelector.yield();
        }

        private void ensureNoCachedData(StorageEntity.Default entry) {
            if (entry.isLive()) {
                this.modifyUsedCacheSize(-entry.clearCache());
            }
        }

        private void validateObjectId(long objectId) {
            Persistence.validateObjectId((long)objectId);
            if (this.oidChannelIndex(objectId) != this.channelIndex) {
                throw new StorageExceptionConsistency("Invalid objectId " + objectId + " for hash channel " + this.channelIndex);
            }
        }

        final StorageIdAnalysis validateEntities() {
            long maxTid = 0L;
            long maxOid = 0L;
            long maxCid = 0L;
            EqHashEnum occuringTypeIds = EqHashEnum.New();
            StorageEntityType.Default[] defaultArray = this.tidHashTable;
            int n = this.tidHashTable.length;
            int n2 = 0;
            while (n2 < n) {
                StorageEntityType.Default type = defaultArray[n2];
                while (type != null) {
                    Long typeMaxCid;
                    Long typeMaxOid;
                    if (!type.isEmpty()) {
                        occuringTypeIds.add((Object)type.typeId);
                    }
                    StorageIdAnalysis idAnalysis = type.validateEntities();
                    type = type.hashNext;
                    Long typeMaxTid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.TID);
                    if (typeMaxTid != null && typeMaxTid >= maxTid) {
                        maxTid = typeMaxTid;
                    }
                    if ((typeMaxOid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.OID)) != null && typeMaxOid >= maxOid) {
                        maxOid = typeMaxOid;
                    }
                    if ((typeMaxCid = (Long)idAnalysis.highestIdsPerType().get((Object)Persistence.IdType.CID)) == null || typeMaxCid < maxCid) continue;
                    maxCid = typeMaxCid;
                }
                ++n2;
            }
            return StorageIdAnalysis.New(maxTid, maxOid, maxCid, (XGettingEnum<Long>)occuringTypeIds);
        }

        final StorageEntityType.Default validateEntity(long length, long typeId, long objcId) {
            StorageEntityType.Default type;
            StorageEntity.Default entry = this.getEntry(objcId);
            if (entry != null) {
                type = entry.typeInFile.type;
                if (type.typeId != typeId) {
                    throw new StorageExceptionConsistency("Object Id already assigned to an entity of another type. Existing: " + objcId + ", type " + type.typeId + ". " + "Subject: " + objcId + ", type " + typeId + ".");
                }
            } else {
                this.validateObjectId(objcId);
                type = this.getType(typeId);
            }
            type.typeHandler().validateEntityGuaranteedType(length, objcId);
            return type;
        }

        final StorageEntity.Default putEntity(long objectId, StorageEntityType.Default type) {
            StorageEntity.Default entry = this.getEntry(objectId);
            if (entry != null) {
                this.resetExistingEntityForUpdate(entry);
                return entry;
            }
            return this.createEntity(objectId, type);
        }

        final StorageEntity.Default putEntity(long entityAddress) {
            StorageEntity.Default entry = this.getEntry(Binary.getEntityObjectIdRawValue((long)entityAddress));
            if (entry != null) {
                this.resetExistingEntityForUpdate(entry);
                return entry;
            }
            try {
                return this.createEntity(Binary.getEntityObjectIdRawValue((long)entityAddress), this.getType(Binary.getEntityTypeIdRawValue((long)entityAddress)));
            }
            catch (Exception e) {
                throw new StorageException("Exception while creating entity [" + Binary.getEntityLengthRawValue((long)entityAddress) + "][" + Binary.getEntityTypeIdRawValue((long)entityAddress) + "][" + Binary.getEntityObjectIdRawValue((long)entityAddress) + "]", e);
            }
        }

        final StorageEntity.Default initialCreateEntity(long entityAddress) {
            StorageEntity.Default entity = this.createEntity(Binary.getEntityObjectIdRawValue((long)entityAddress), this.getType(Binary.getEntityTypeIdRawValue((long)entityAddress)));
            return entity;
        }

        private void resetExistingEntityForUpdate(StorageEntity.Default entry) {
            this.ensureNoCachedData(entry);
            entry.detachFromFile();
        }

        private void markEntityForChangedData(StorageEntity.Default entry) {
            if (this.hasUpdatePendingSweep) {
                if (entry.isGcBlack()) {
                    return;
                }
                entry.markBlack();
                return;
            }
            if (entry.hasReferences()) {
                entry.markGray();
                this.markMonitor.enqueue(this.oidMarkQueue, entry.objectId());
                return;
            }
            entry.markBlack();
        }

        public final long entityCount() {
            return this.oidSize;
        }

        private StorageEntity.Default createEntity(long objectId, StorageEntityType.Default type) {
            if (this.oidSize >= (long)this.oidModulo && this.oidModulo < Integer.MAX_VALUE) {
                this.enlargeOidHashTable();
            }
            StorageEntity.Default entity = StorageEntity.Default.New(objectId, type.dummy, this.getOidHashChainHead(objectId), type.hasReferences(), type.simpleReferenceDataCount());
            this.setOidHashChainHead(objectId, entity);
            type.add(entity);
            ++this.oidSize;
            entity.touch();
            return entity;
        }

        final void deleteEntity(StorageEntity.Default entity, StorageEntityType.Default type, StorageEntity.Default previousInType) {
            this.unregisterEntity(entity);
            entity.detachFromFile();
            type.remove(entity, previousInType);
            this.ensureNoCachedData(entity);
            entity.setDeleted();
        }

        private void checkForCacheClear(StorageEntity.Default entry, long evalTime) {
            if (this.entityCacheEvaluator.clearEntityCache(this.usedCacheSize, evalTime, entry)) {
                this.ensureNoCachedData(entry);
            } else {
                entry.touch();
            }
        }

        private void advanceMarking(int oidsCount) {
            this.referenceMarker.tryFlush();
            this.markMonitor.advanceMarking(this.oidMarkQueue, oidsCount);
        }

        private boolean incrementalMark(long nanoTimeBudgetBound) {
            long evalTime = System.currentTimeMillis();
            StorageReferenceMarker referenceMarker = this.referenceMarker;
            StorageObjectIdMarkQueue oidMarkQueue = this.oidMarkQueue;
            long[] oidsBuffer = this.markingOidBuffer;
            int oidsMarkAmount = 0;
            int oidsMarkIndex = 0;
            do {
                StorageEntity.Default entry;
                if (oidsMarkIndex >= oidsMarkAmount) {
                    this.advanceMarking(oidsMarkIndex);
                    oidsMarkIndex = 0;
                    oidsMarkAmount = oidMarkQueue.getNext(oidsBuffer);
                    if (oidsMarkAmount == 0) {
                        return true;
                    }
                }
                if ((entry = this.getEntry(oidsBuffer[oidsMarkIndex++])) == null) {
                    if (this.zombieOidHandler.handleZombieOid(oidsBuffer[oidsMarkIndex - 1])) continue;
                    this.eventLogger.logGarbageCollectorEncounteredZombieObjectId(oidsBuffer[oidsMarkIndex - 1]);
                    continue;
                }
                if (entry.isGcBlack()) continue;
                if (entry.iterateReferenceIds(referenceMarker)) {
                    this.checkForCacheClear(entry, evalTime);
                }
                entry.markBlack();
            } while (System.nanoTime() < nanoTimeBudgetBound);
            if (oidsMarkIndex > 0) {
                this.advanceMarking(oidsMarkIndex);
            }
            return false;
        }

        private void sweep() {
            StorageEntityType.Default typeHead;
            this.lastSweepStart = System.currentTimeMillis();
            StorageEntityType.Default sweepType = typeHead = this.typeHead;
            while ((sweepType = sweepType.next) != typeHead) {
                StorageEntity.Default item;
                StorageEntity.Default last = sweepType.head;
                while ((item = last.typeNext) != null) {
                    if (item.isGcMarked()) {
                        last = item;
                        last.markWhite();
                        continue;
                    }
                    this.deleteEntity(item, sweepType, last);
                }
            }
            this.lastSweepEnd = System.currentTimeMillis();
            ++this.sweepGeneration;
            this.fileManager.restartFileCleanupCursor();
            long channelRootOid = this.queryRootObjectId();
            this.markMonitor.completeSweep(this, this.rootOidSelector, channelRootOid);
        }

        static final int validateStoragePosition(StorageEntity.Default entity, long storageOffset) {
            if (storageOffset < 0x80000000L) {
                return (int)storageOffset;
            }
            throw new StorageException("Storage position for entity " + entity.objectId() + " exceeds the technical int value limit of " + Integer.MAX_VALUE + "." + " This happens when a single store grows too big." + " This limitation will be removed in a future version.");
        }

        final void internalPutEntities(ByteBuffer chunk, long chunkStoragePosition, StorageLiveDataFile.Default file) {
            long chunkStartAddress = XMemory.getDirectByteBufferAddress((ByteBuffer)chunk);
            long chunkLength = chunk.limit();
            long storageBackset = chunkStoragePosition - chunkStartAddress;
            long chunkBoundAddress = chunkStartAddress + chunkLength;
            long adr = chunkStartAddress;
            while (adr < chunkBoundAddress) {
                StorageEntity.Default entity = this.putEntity(adr);
                this.markEntityForChangedData(entity);
                entity.updateStorageInformation(X.checkArrayRange((long)Binary.getEntityLengthRawValue((long)adr)), Default.validateStoragePosition(entity, storageBackset + adr));
                file.appendEntry(entity);
                adr += Binary.getEntityLengthRawValue((long)adr);
            }
        }

        final void modifyUsedCacheSize(long cacheChange) {
            this.usedCacheSize += cacheChange;
        }

        @Override
        public int channelIndex() {
            return this.channelIndex;
        }

        @Override
        public final long cacheSize() {
            return this.usedCacheSize;
        }

        @Override
        public final long clearCache() {
            if (this.usedCacheSize == 0L) {
                return 0L;
            }
            long currentUsedCacheSize = this.usedCacheSize;
            this.internalCacheCheck(Long.MAX_VALUE, (s, t, e) -> true);
            return currentUsedCacheSize;
        }

        @Override
        public final StorageTypeDictionary typeDictionary() {
            return this.typeDictionary;
        }

        public void postStorePutEntities(ByteBuffer[] chunks, long[] chunksStoragePositions, StorageLiveDataFile.Default dataFile) throws InterruptedException {
            this.hasUpdatePendingSweep = this.markMonitor.isPendingSweep(this);
            this.markMonitor.resetCompletion();
            int i = 0;
            while (i < chunks.length) {
                this.internalPutEntities(chunks[i], chunksStoragePositions[i], dataFile);
                ++i;
            }
            this.clearPendingStoreUpdate();
        }

        final void clearPendingStoreUpdate() {
            this.hasUpdatePendingSweep = false;
            this.markMonitor.clearPendingStoreUpdate(this);
        }

        public final StorageEntityType.Default lookupType(long typeId) {
            StorageEntityType.Default typeEntry = this.tidHashTable[Default.tidHashIndex(typeId, this.tidModulo)];
            while (typeEntry != null) {
                if (typeEntry.typeId == typeId) {
                    return typeEntry;
                }
                typeEntry = typeEntry.hashNext;
            }
            return null;
        }

        @Override
        public void copyRoots(ChunksBuffer dataCollector) {
            this.rootType.iterateEntities(e -> e.copyCachedData((MemoryRangeReader)dataCollector));
        }

        @Override
        public final boolean incrementalEntityCacheCheck(long nanoTimeBudgetBound) {
            return this.internalCacheCheck(nanoTimeBudgetBound, this.entityCacheEvaluator);
        }

        private boolean internalCacheCheck(long nanoTimeBudgetBound, StorageEntityCacheEvaluator evaluator) {
            StorageEntity.Default cursor;
            if (this.usedCacheSize == 0L) {
                return true;
            }
            long evaluationTime = System.currentTimeMillis();
            if (this.liveCursor == null || !this.liveCursor.isProper() || this.liveCursor.isDeleted()) {
                cursor = this.fileManager.getFirstEntity();
                if (cursor == null) {
                    return true;
                }
            } else {
                cursor = this.liveCursor;
            }
            StorageLiveDataFile.Default file = cursor.typeInFile.file;
            StorageEntity.Default tail = file.tail;
            StorageEntity.Default entity = cursor;
            do {
                if (entity == tail) {
                    file = file.next;
                    tail = file.tail;
                    entity = file.head.fileNext;
                    continue;
                }
                if (this.entityRequiresCacheClearing(entity, evaluator, evaluationTime)) {
                    this.ensureNoCachedData(entity);
                    if (this.usedCacheSize == 0L) break;
                }
                entity = entity.fileNext;
            } while (entity != cursor && System.nanoTime() < nanoTimeBudgetBound);
            return this.quitLiveCheck(entity);
        }

        private boolean quitLiveCheck(StorageEntity.Default entity) {
            if (this.usedCacheSize == 0L) {
                this.resetLiveCursor();
                this.eventLogger.logLiveCheckComplete(this);
                return true;
            }
            this.liveCursor = entity;
            return false;
        }

        private boolean entityRequiresCacheClearing(StorageEntity.Default entity, StorageEntityCacheEvaluator evaluator, long evalTime) {
            if (!entity.isLive()) {
                return false;
            }
            return evaluator.clearEntityCache(this.usedCacheSize, evalTime, entity);
        }

        static final StorageEntity.Default getNextLiveEntity(StorageEntity.Default entity) {
            while (entity != null && !entity.isLive()) {
                entity = entity.typeNext;
            }
            return entity;
        }

        @Override
        public boolean issuedEntityCacheCheck(long nanoTimeBudgetBound, StorageEntityCacheEvaluator entityEvaluator) {
            return this.internalCacheCheck(nanoTimeBudgetBound, (StorageEntityCacheEvaluator)X.coalesce((Object)entityEvaluator, (Object)this.entityCacheEvaluator));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public final boolean issuedGarbageCollection(long nanoTimeBudgetBound, StorageChannel channel) {
            if (Default.experimentalGcEnabled) ** GOTO lbl24
            return true;
lbl-1000:
            // 1 sources

            {
                if (this.incrementalGarbageCollection(nanoTimeBudgetBound, channel)) ** GOTO lbl23
                return false;
lbl-1000:
                // 1 sources

                {
                    if (this.markMonitor.isComplete(this)) {
                        return true;
                    }
                    if (this.markMonitor.isMarkingComplete()) continue block5;
                    this.referenceMarker.tryFlush();
                    var4_3 = this.oidMarkQueue;
                    synchronized (var4_3) {
                        if (this.oidMarkQueue.hasElements()) {
                            continue block5;
                        }
                        try {
                            this.oidMarkQueue.wait(this.markingWaitTimeMs);
                        }
                        catch (InterruptedException e) {
                            break block5;
                        }
                    }
lbl23:
                    // 2 sources

                    ** while (System.nanoTime() < nanoTimeBudgetBound)
                }
lbl24:
                // 4 sources

                ** while (System.nanoTime() < nanoTimeBudgetBound)
            }
lbl25:
            // 2 sources

            return this.markMonitor.isComplete(this);
        }

        @Override
        public final boolean incrementalGarbageCollection(long nanoTimeBudgetBound, StorageChannel channel) {
            if (!experimentalGcEnabled) {
                return true;
            }
            try {
                return this.internalIncrementalGarbageCollection(nanoTimeBudgetBound, channel);
            }
            catch (Exception e) {
                throw new StorageExceptionGarbageCollector("Exception in channel #" + this.channelIndex(), e);
            }
        }

        private boolean checkForGcCompletion() {
            if (this.markMonitor.isComplete(this)) {
                this.checkOidHashTableConsolidation();
                return true;
            }
            return false;
        }

        private final boolean internalIncrementalGarbageCollection(long nanoTimeBudgetBound, StorageChannel channel) {
            if (this.checkForGcCompletion()) {
                return true;
            }
            if (this.markMonitor.needsSweep(this)) {
                this.sweep();
                if (this.checkForGcCompletion()) {
                    return true;
                }
                if (System.nanoTime() >= nanoTimeBudgetBound) {
                    return false;
                }
            }
            return this.incrementalMark(nanoTimeBudgetBound);
        }

        static final class RootEntityRootOidSelectionIterator
        implements ThrowingProcedure<StorageEntity.Default, RuntimeException> {
            final StorageRootOidSelector rootOidSelector;

            public RootEntityRootOidSelectionIterator(StorageRootOidSelector rootOidSelector) {
                this.rootOidSelector = rootOidSelector;
            }

            public void accept(StorageEntity.Default e) throws RuntimeException {
                this.rootOidSelector.accept(e.objectId());
            }
        }
    }
}

