/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.meta.XDebug;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageHashChannelPart;

public interface StorageEventLogger {
    default public void logChannelProcessingDisabled(StorageChannel channel) {
    }

    default public void logChannelStoppedWorking(StorageChannel channel) {
    }

    default public void logDisruption(StorageChannel channel, Throwable t) {
    }

    default public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
    }

    default public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
    }

    default public void logGarbageCollectorNotNeeded() {
    }

    default public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
    }

    default public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
    }

    default public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
    }

    public static StorageEventLogger NoOp() {
        return new NoOp();
    }

    public static StorageEventLogger Debug() {
        return new Debug(Debug::printString);
    }

    public static StorageEventLogger Debug(Consumer<? super String> messageConsumer) {
        return new Debug((Consumer)X.notNull(messageConsumer));
    }

    public static class Debug
    implements StorageEventLogger {
        private final Consumer<? super String> messageConsumer;

        public static void printString(String s) {
            XDebug.println((String)s, (int)4);
        }

        public static String toChannelIdentifier(StorageChannel channel) {
            return Debug.toChannelPartIdentifier(channel);
        }

        public static String toChannelIdentifier(StorageEntityCache<?> entityCache) {
            return Debug.toChannelPartIdentifier(entityCache);
        }

        public static String toChannelPartIdentifier(StorageHashChannelPart channelPart) {
            return "StorageChannel#" + channelPart.channelIndex();
        }

        Debug(Consumer<? super String> messageConsumer) {
            this.messageConsumer = (Consumer)X.notNull(messageConsumer);
        }

        public void log(String s) {
            this.messageConsumer.accept(s);
        }

        @Override
        public void logChannelProcessingDisabled(StorageChannel channel) {
            this.log(String.valueOf(Debug.toChannelIdentifier(channel)) + " processing disabled.");
        }

        @Override
        public void logChannelStoppedWorking(StorageChannel channel) {
            this.log(String.valueOf(Debug.toChannelIdentifier(channel)) + " stopped working.");
        }

        @Override
        public void logDisruption(StorageChannel channel, Throwable t) {
            this.log(String.valueOf(Debug.toChannelIdentifier(channel)) + " encountered exception " + t);
        }

        @Override
        public void logLiveCheckComplete(StorageEntityCache<?> entityCache) {
            this.log(String.valueOf(Debug.toChannelIdentifier(entityCache)) + " completed live check.");
        }

        @Override
        public void logGarbageCollectorSweepingComplete(StorageEntityCache<?> entityCache) {
            this.log(String.valueOf(Debug.toChannelIdentifier(entityCache)) + " completed sweeping.");
        }

        @Override
        public void logGarbageCollectorEncounteredZombieObjectId(long objectId) {
            this.log("GC marking encountered zombie ObjectId " + objectId);
        }

        @Override
        public void logGarbageCollectorNotNeeded() {
            this.log("not needed.");
        }

        @Override
        public void logGarbageCollectorCompletedHotPhase(long gcHotGeneration, long lastGcHotCompletion) {
            this.log("Completed GC Hot Phase #" + gcHotGeneration + " @ " + lastGcHotCompletion);
        }

        @Override
        public void logGarbageCollectorCompleted(long gcColdGeneration, long lastGcColdCompletion) {
            this.log("Storage-GC completed #" + gcColdGeneration + " @ " + lastGcColdCompletion);
        }
    }

    public static final class NoOp
    implements StorageEventLogger {
        NoOp() {
        }
    }
}

