/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageChannel;

@FunctionalInterface
public interface StorageExceptionHandler {
    public void handleException(Throwable var1, StorageChannel var2);

    public static void defaultHandleException(Throwable exception, StorageChannel channel) {
        if (exception instanceof StorageException) {
            throw (StorageException)((Object)exception);
        }
        throw new StorageException(exception);
    }

    public static StorageExceptionHandler New() {
        return new Default();
    }

    public static final class Default
    implements StorageExceptionHandler {
        Default() {
        }

        @Override
        public void handleException(Throwable exception, StorageChannel channel) {
            StorageExceptionHandler.defaultHandleException(exception, channel);
        }
    }
}

