/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.ADirectory;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AFileSystem;
import one.microstream.persistence.internal.PersistenceTypeDictionaryFileHandler;
import one.microstream.storage.types.Storage;
import one.microstream.storage.types.StorageDirectoryStructureProvider;
import one.microstream.storage.types.StorageFileNameProvider;
import one.microstream.storage.types.StorageFileProvider;

public interface StorageLiveFileProvider
extends StorageFileProvider {
    public String getStorageLocationIdentifier();

    public AFile provideDataFile(int var1, long var2);

    public AFile provideTransactionsFile(int var1);

    public AFile provideLockFile();

    public static StorageLiveFileProvider New() {
        return Storage.FileProviderBuilder().createFileProvider();
    }

    public static StorageLiveFileProvider New(ADirectory storageDirectory) {
        return ((Builder)Storage.FileProviderBuilder(storageDirectory.fileSystem()).setDirectory(storageDirectory)).createFileProvider();
    }

    public static Default New(ADirectory baseDirectory, ADirectory deletionDirectory, ADirectory truncationDirectory, StorageDirectoryStructureProvider structureProvider, StorageFileNameProvider fileNameProvider, PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator) {
        return new Default((ADirectory)X.notNull((Object)baseDirectory), (ADirectory)X.mayNull((Object)deletionDirectory), (ADirectory)X.mayNull((Object)truncationDirectory), (StorageDirectoryStructureProvider)X.notNull((Object)structureProvider), (StorageFileNameProvider)X.notNull((Object)fileNameProvider), (PersistenceTypeDictionaryFileHandler.Creator)X.notNull((Object)fileHandlerCreator));
    }

    public static Builder<?> Builder() {
        return StorageLiveFileProvider.Builder((AFileSystem)Storage.DefaultFileSystem());
    }

    public static Builder<?> Builder(AFileSystem fileSystem) {
        return new Builder.Default((AFileSystem)X.notNull((Object)fileSystem));
    }

    public static interface Builder<B extends Builder<?>>
    extends StorageFileProvider.Builder<B> {
        @Override
        public StorageLiveFileProvider createFileProvider();

        public static class Default
        extends StorageFileProvider.Builder.Abstract<Default>
        implements Builder<Default> {
            Default(AFileSystem fileSystem) {
                super(fileSystem);
            }

            @Override
            protected ADirectory getBaseDirectory() {
                if (this.directory() != null) {
                    return this.directory();
                }
                return this.fileSystem().ensureRoot(Defaults.defaultStorageDirectory());
            }

            @Override
            public StorageLiveFileProvider createFileProvider() {
                return StorageLiveFileProvider.New(this.getBaseDirectory(), this.getDeletionDirectory(), this.getTruncationDirectory(), this.getDirectoryStructureProvider(), this.getFileNameProvider(), this.getTypeDictionaryFileHandler());
            }
        }
    }

    public static final class Default
    extends StorageFileProvider.Abstract
    implements StorageLiveFileProvider {
        Default(ADirectory baseDirectory, ADirectory deletionDirectory, ADirectory truncationDirectory, StorageDirectoryStructureProvider structureProvider, StorageFileNameProvider fileNameProvider, PersistenceTypeDictionaryFileHandler.Creator fileHandlerCreator) {
            super(baseDirectory, deletionDirectory, truncationDirectory, structureProvider, fileNameProvider, fileHandlerCreator);
        }

        @Override
        public String getStorageLocationIdentifier() {
            return this.baseDirectory().toPathString();
        }
    }

    public static interface Defaults {
        public static String defaultStorageDirectory() {
            return "storage";
        }
    }
}

