/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.math.XMath;
import one.microstream.storage.exceptions.StorageException;

public interface StorageObjectIdMarkQueue {
    public void enqueue(long var1);

    public void enqueueBulk(long[] var1, int var2);

    public int getNext(long[] var1);

    public boolean hasElements();

    public void advanceTail(int var1);

    public void reset();

    public long size();

    public static interface Creator {
        public StorageObjectIdMarkQueue createOidMarkQueue(int var1);

        public static final class Default
        implements Creator {
            @Override
            public StorageObjectIdMarkQueue createOidMarkQueue(int segmentLength) {
                return new one.microstream.storage.types.StorageObjectIdMarkQueue$Default(segmentLength);
            }
        }
    }

    public static final class Default
    implements StorageObjectIdMarkQueue {
        private final Segment root;
        private Segment head;
        private Segment tail;
        long size;

        @Override
        public final long size() {
            return this.size;
        }

        Default(int segmentLength) {
            this.root = new Segment(XMath.positive((int)segmentLength), null);
            this.reset();
        }

        @Override
        public final synchronized void reset() {
            this.tail = this.root.next = this.root;
            this.head = this.root.next;
            this.root.next.clear();
            this.size = 0L;
        }

        @Override
        public synchronized int getNext(long[] buffer) {
            return this.tail.getNext(buffer);
        }

        @Override
        public synchronized void advanceTail(int amount) {
            if (this.tail.advanceLowIndex(amount)) {
                this.tail = this.tail.advanceTail();
            }
            this.size -= (long)amount;
        }

        @Override
        public final synchronized void enqueue(long objectId) {
            if (this.head.enqueue(objectId)) {
                this.head = this.head.advanceHead();
            }
            ++this.size;
            this.notifyAll();
        }

        @Override
        public synchronized void enqueueBulk(long[] oids, int size) {
            Segment head = this.head;
            int index = 0;
            while (index < size) {
                index = head.enqueueBulk(oids, index, size);
                if (!head.isFull()) continue;
                head = head.advanceHead();
            }
            this.head = head;
            this.size += (long)size;
            this.notifyAll();
        }

        @Override
        public synchronized boolean hasElements() {
            return this.head != this.tail || this.head.hasElements();
        }

        static final class Segment {
            private final long[] objectIds;
            private final int length;
            private int lowIndex;
            private int highIndex;
            Segment next;

            Segment(int length, Segment next) {
                this.length = XMath.positive((int)length);
                this.objectIds = new long[this.length];
                this.next = next;
            }

            final Segment advanceTail() {
                this.clear();
                return this.next;
            }

            final Segment advanceHead() {
                return this.next.highIndex == 0 ? this.next : (this.next = new Segment(this.length, this.next));
            }

            final boolean isFull() {
                return this.highIndex >= this.length;
            }

            final boolean hasElements() {
                return this.lowIndex < this.highIndex;
            }

            final void clear() {
                this.highIndex = 0;
                this.lowIndex = 0;
            }

            final int getNext(long[] buffer) {
                if (this.lowIndex >= this.highIndex) {
                    return 0;
                }
                int copyLength = Math.min(this.highIndex - this.lowIndex, buffer.length);
                System.arraycopy(this.objectIds, this.lowIndex, buffer, 0, copyLength);
                return copyLength;
            }

            final boolean advanceLowIndex(int amount) {
                if (this.lowIndex + amount > this.highIndex) {
                    throw new StorageException("Inconsistent OidMarkQueue low index advance");
                }
                return (this.lowIndex += amount) == this.length;
            }

            final boolean enqueue(long objectId) {
                this.objectIds[this.highIndex] = objectId;
                return ++this.highIndex >= this.length;
            }

            final int enqueueBulk(long[] objectIds, int offset, int bound) {
                int copyLength = Math.min(bound - offset, this.length - this.highIndex);
                System.arraycopy(objectIds, offset, this.objectIds, this.highIndex, copyLength);
                this.highIndex += copyLength;
                return offset + copyLength;
            }
        }
    }
}

