/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.storage.exceptions.StorageExceptionRequest;
import one.microstream.storage.types.StorageDataChunkValidator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityTypeExportFileProvider;
import one.microstream.storage.types.StorageEntityTypeExportStatistics;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageRawFileStatistics;
import one.microstream.storage.types.StorageRequestTask;
import one.microstream.storage.types.StorageTaskBroker;

public interface StorageRequestAcceptor {
    public void storeData(Binary var1) throws StorageExceptionRequest, InterruptedException;

    public Binary queryByObjectIds(PersistenceIdSet[] var1) throws StorageExceptionRequest, InterruptedException;

    public Binary queryByTypeIds(PersistenceIdSet var1) throws StorageExceptionRequest, InterruptedException;

    public Binary recallRoots() throws StorageExceptionRequest, InterruptedException;

    public boolean issueGarbageCollection(long var1) throws InterruptedException;

    public boolean issueFileCheck(long var1) throws InterruptedException;

    public boolean issueCacheCheck(long var1, StorageEntityCacheEvaluator var3) throws InterruptedException;

    default public StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider exportFileProvider) throws InterruptedException {
        return this.exportTypes(exportFileProvider, null);
    }

    public StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider var1, Predicate<? super StorageEntityTypeHandler> var2) throws InterruptedException;

    public void exportChannels(StorageLiveFileProvider var1, boolean var2) throws InterruptedException;

    public void importFiles(XGettingEnum<AFile> var1) throws InterruptedException;

    public StorageRawFileStatistics createStatistics() throws InterruptedException;

    public static interface Creator {
        public StorageRequestAcceptor createRequestAcceptor(StorageDataChunkValidator var1, StorageTaskBroker var2);

        public static final class Default
        implements Creator {
            @Override
            public StorageRequestAcceptor createRequestAcceptor(StorageDataChunkValidator dataChunkValidator, StorageTaskBroker taskBroker) {
                return new one.microstream.storage.types.StorageRequestAcceptor$Default(dataChunkValidator, taskBroker);
            }
        }
    }

    public static final class Default
    implements StorageRequestAcceptor {
        private final StorageTaskBroker taskBroker;
        private final StorageDataChunkValidator prevalidatorDataChunk;

        public Default(StorageDataChunkValidator dataChunkValidator, StorageTaskBroker taskBroker) {
            this.prevalidatorDataChunk = (StorageDataChunkValidator)X.notNull((Object)dataChunkValidator);
            this.taskBroker = (StorageTaskBroker)X.notNull((Object)taskBroker);
        }

        private static <T extends StorageRequestTask> T waitOnTask(T task) throws InterruptedException {
            task.waitOnCompletion();
            return task;
        }

        @Override
        public final void storeData(Binary data) throws InterruptedException {
            this.prevalidatorDataChunk.validateDataChunk(data);
            Default.waitOnTask(this.taskBroker.enqueueStoreTask(data));
        }

        @Override
        public final Binary queryByObjectIds(PersistenceIdSet[] loadOids) throws InterruptedException {
            return Default.waitOnTask(this.taskBroker.enqueueLoadTaskByOids(loadOids)).result();
        }

        @Override
        public Binary queryByTypeIds(PersistenceIdSet loadTids) throws StorageExceptionRequest, InterruptedException {
            return Default.waitOnTask(this.taskBroker.enqueueLoadTaskByTids(loadTids)).result();
        }

        @Override
        public Binary recallRoots() throws StorageExceptionRequest, InterruptedException {
            return Default.waitOnTask(this.taskBroker.enqueueRootsLoadTask()).result();
        }

        @Override
        public boolean issueGarbageCollection(long nanoTimeBudget) throws InterruptedException {
            return Default.waitOnTask(this.taskBroker.issueGarbageCollection(nanoTimeBudget)).result();
        }

        @Override
        public boolean issueCacheCheck(long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) throws InterruptedException {
            return Default.waitOnTask(this.taskBroker.issueCacheCheck(nanoTimeBudget, entityEvaluator)).result();
        }

        @Override
        public boolean issueFileCheck(long nanoTimeBudget) throws InterruptedException {
            return Default.waitOnTask(this.taskBroker.issueFileCheck(nanoTimeBudget)).result();
        }

        @Override
        public final StorageEntityTypeExportStatistics exportTypes(StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) throws InterruptedException {
            return Default.waitOnTask(this.taskBroker.enqueueExportTypesTask(exportFileProvider, isExportType)).result();
        }

        @Override
        public final void exportChannels(StorageLiveFileProvider fileProvider, boolean performGarbageCollection) throws InterruptedException {
            Default.waitOnTask(this.taskBroker.enqueueExportChannelsTask(fileProvider, performGarbageCollection));
        }

        @Override
        public StorageRawFileStatistics createStatistics() throws InterruptedException {
            return Default.waitOnTask(this.taskBroker.enqueueCreateRawFileStatisticsTask()).result();
        }

        @Override
        public void importFiles(XGettingEnum<AFile> importFiles) throws InterruptedException {
            Default.waitOnTask(this.taskBroker.enqueueImportFromFilesTask(importFiles));
        }
    }
}

