/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.afs.types.AFile;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.persistence.types.PersistenceIdSet;
import one.microstream.storage.types.StorageChannelTaskInitialize;
import one.microstream.storage.types.StorageChannelTaskShutdown;
import one.microstream.storage.types.StorageDataFileEvaluator;
import one.microstream.storage.types.StorageEntityCacheEvaluator;
import one.microstream.storage.types.StorageEntityTypeExportFileProvider;
import one.microstream.storage.types.StorageEntityTypeHandler;
import one.microstream.storage.types.StorageLiveFileProvider;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageOperationController;
import one.microstream.storage.types.StorageRequestTaskCacheCheck;
import one.microstream.storage.types.StorageRequestTaskCreateStatistics;
import one.microstream.storage.types.StorageRequestTaskExportChannels;
import one.microstream.storage.types.StorageRequestTaskExportEntitiesByType;
import one.microstream.storage.types.StorageRequestTaskFileCheck;
import one.microstream.storage.types.StorageRequestTaskImportData;
import one.microstream.storage.types.StorageRequestTaskLoadByOids;
import one.microstream.storage.types.StorageRequestTaskLoadByTids;
import one.microstream.storage.types.StorageRequestTaskLoadRoots;
import one.microstream.storage.types.StorageRequestTaskStoreEntities;
import one.microstream.storage.types.StorageTimestampProvider;

public interface StorageRequestTaskCreator {
    public StorageChannelTaskInitialize createInitializationTask(int var1, StorageOperationController var2);

    public StorageRequestTaskStoreEntities createSaveTask(Binary var1);

    public StorageRequestTaskLoadByOids createLoadTaskByOids(PersistenceIdSet[] var1);

    public StorageRequestTaskLoadRoots createRootsLoadTask(int var1);

    public StorageRequestTaskLoadByTids createLoadTaskByTids(PersistenceIdSet var1, int var2);

    default public StorageRequestTaskExportEntitiesByType createExportTypesTask(int channelCount, StorageEntityTypeExportFileProvider exportFileProvider) {
        return this.createExportTypesTask(channelCount, exportFileProvider, null);
    }

    public StorageRequestTaskExportEntitiesByType createExportTypesTask(int var1, StorageEntityTypeExportFileProvider var2, Predicate<? super StorageEntityTypeHandler> var3);

    public StorageRequestTaskExportChannels createTaskExportChannels(int var1, StorageLiveFileProvider var2);

    public StorageRequestTaskCreateStatistics createCreateRawFileStatisticsTask(int var1);

    public StorageRequestTaskFileCheck createFullFileCheckTask(int var1, long var2);

    public StorageRequestTaskCacheCheck createFullCacheCheckTask(int var1, long var2, StorageEntityCacheEvaluator var4);

    public StorageRequestTaskImportData createImportFromFilesTask(int var1, StorageDataFileEvaluator var2, StorageObjectIdRangeEvaluator var3, XGettingEnum<AFile> var4);

    public StorageChannelTaskShutdown createShutdownTask(int var1, StorageOperationController var2);

    public static final class Default
    implements StorageRequestTaskCreator {
        private final StorageTimestampProvider timestampProvider;

        public Default(StorageTimestampProvider timestampProvider) {
            this.timestampProvider = (StorageTimestampProvider)X.notNull((Object)timestampProvider);
        }

        @Override
        public StorageChannelTaskInitialize createInitializationTask(int channelCount, StorageOperationController operationController) {
            return new StorageChannelTaskInitialize.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageChannelTaskShutdown createShutdownTask(int channelCount, StorageOperationController operationController) {
            return new StorageChannelTaskShutdown.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, operationController);
        }

        @Override
        public StorageRequestTaskStoreEntities createSaveTask(Binary data) {
            return new StorageRequestTaskStoreEntities.Default(this.timestampProvider.currentNanoTimestamp(), data);
        }

        @Override
        public StorageRequestTaskLoadByOids createLoadTaskByOids(PersistenceIdSet[] loadOids) {
            return new StorageRequestTaskLoadByOids.Default(this.timestampProvider.currentNanoTimestamp(), loadOids);
        }

        @Override
        public StorageRequestTaskLoadRoots createRootsLoadTask(int channelCount) {
            return new StorageRequestTaskLoadRoots.Default(this.timestampProvider.currentNanoTimestamp(), channelCount);
        }

        @Override
        public StorageRequestTaskLoadByTids createLoadTaskByTids(PersistenceIdSet loadTids, int channelCount) {
            return new StorageRequestTaskLoadByTids.Default(this.timestampProvider.currentNanoTimestamp(), loadTids, channelCount);
        }

        @Override
        public StorageRequestTaskExportEntitiesByType createExportTypesTask(int channelCount, StorageEntityTypeExportFileProvider exportFileProvider, Predicate<? super StorageEntityTypeHandler> isExportType) {
            return new StorageRequestTaskExportEntitiesByType.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, exportFileProvider, isExportType);
        }

        @Override
        public StorageRequestTaskExportChannels createTaskExportChannels(int channelCount, StorageLiveFileProvider fileProvider) {
            return new StorageRequestTaskExportChannels.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, fileProvider);
        }

        @Override
        public StorageRequestTaskCreateStatistics createCreateRawFileStatisticsTask(int channelCount) {
            return new StorageRequestTaskCreateStatistics.Default(this.timestampProvider.currentNanoTimestamp(), channelCount);
        }

        @Override
        public StorageRequestTaskFileCheck createFullFileCheckTask(int channelCount, long nanoTimeBudget) {
            return new StorageRequestTaskFileCheck.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, nanoTimeBudget);
        }

        @Override
        public StorageRequestTaskCacheCheck createFullCacheCheckTask(int channelCount, long nanoTimeBudget, StorageEntityCacheEvaluator entityEvaluator) {
            return new StorageRequestTaskCacheCheck.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, nanoTimeBudget, entityEvaluator);
        }

        @Override
        public StorageRequestTaskImportData createImportFromFilesTask(int channelCount, StorageDataFileEvaluator fileEvaluator, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<AFile> importFiles) {
            return new StorageRequestTaskImportData.Default(this.timestampProvider.currentNanoTimestamp(), channelCount, objectIdRangeEvaluator, importFiles);
        }
    }
}

