/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.concurrency.XThreads;
import one.microstream.persistence.binary.types.Binary;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionImportFailed;
import one.microstream.storage.types.DisruptionCollectorExecuting;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelFile;
import one.microstream.storage.types.StorageChannelImportBatch;
import one.microstream.storage.types.StorageChannelImportEntity;
import one.microstream.storage.types.StorageChannelSynchronizingTask;
import one.microstream.storage.types.StorageChannelTaskStoreEntities;
import one.microstream.storage.types.StorageDataFileItemIterator;
import one.microstream.storage.types.StorageEntityCache;
import one.microstream.storage.types.StorageEntityType;
import one.microstream.storage.types.StorageImportSourceFile;
import one.microstream.storage.types.StorageObjectIdRangeEvaluator;
import one.microstream.storage.types.StorageRequestTask;

public interface StorageRequestTaskImportData
extends StorageRequestTask {

    public static final class ChannelItem {
        final ImportBatch headBatch = new ImportBatch();
        ImportBatch tailBatch;
        ImportEntity tailEntity;

        ChannelItem resetChains() {
            this.tailBatch = this.headBatch;
            this.headBatch.next = null;
            this.headBatch.batchNext = null;
            this.tailEntity = null;
            return this;
        }
    }

    public static final class Default
    extends StorageChannelSynchronizingTask.AbstractCompletingTask<Void>
    implements StorageRequestTaskImportData,
    StorageChannelTaskStoreEntities {
        private static final int SOURCE_FILE_WAIT_TIME_MS = 100;
        private final XGettingEnum<AFile> importFiles;
        private final StorageEntityCache.Default[] entityCaches;
        private final StorageObjectIdRangeEvaluator objectIdRangeEvaluator;
        private final SourceFileSlice[] sourceFileHeads;
        private final SourceFileSlice[] sourceFileTails;
        private volatile boolean complete;
        private volatile long maxObjectId;
        private Thread readThread;

        Default(long timestamp, int channelCount, StorageObjectIdRangeEvaluator objectIdRangeEvaluator, XGettingEnum<AFile> importFiles) {
            super(timestamp, channelCount);
            this.importFiles = importFiles;
            this.objectIdRangeEvaluator = objectIdRangeEvaluator;
            this.entityCaches = new StorageEntityCache.Default[channelCount];
            this.sourceFileTails = Default.createSourceFileSlices(channelCount);
            this.sourceFileHeads = (SourceFileSlice[])this.sourceFileTails.clone();
        }

        private static SourceFileSlice[] createSourceFileSlices(int channelCount) {
            SourceFileSlice[] sourceFileTails = new SourceFileSlice[channelCount];
            int i = 0;
            while (i < channelCount) {
                sourceFileTails[i] = new SourceFileSlice(i, null, null);
                ++i;
            }
            return sourceFileTails;
        }

        private boolean entityCacheCollectionNotComplete() {
            StorageEntityCache.Default[] defaultArray = this.entityCaches;
            int n = this.entityCaches.length;
            int n2 = 0;
            while (n2 < n) {
                StorageEntityCache.Default entityCache = defaultArray[n2];
                if (entityCache == null) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private synchronized void ensureReaderThread() {
            if (this.readThread != null || this.entityCacheCollectionNotComplete()) {
                return;
            }
            this.readThread = XThreads.start(this::readFiles);
        }

        final void readFiles() {
            ItemReader itemReader = new ItemReader(this.entityCaches, this.sourceFileHeads);
            StorageDataFileItemIterator iterator = StorageDataFileItemIterator.New(StorageDataFileItemIterator.BufferProvider.New(), itemReader);
            for (AFile file : this.importFiles) {
                try {
                    itemReader.setSourceFile(file);
                    AFS.execute((AFile)file, rf -> iterator.iterateStoredItems((AReadableFile)rf));
                    itemReader.completeCurrentSourceFile();
                }
                catch (Exception e) {
                    throw new StorageExceptionImportFailed("Exception while reading import file " + file, e);
                }
            }
            this.complete = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final Void internalProcessBy(StorageChannel channel) {
            StorageEntityCache.Default[] defaultArray = this.entityCaches;
            synchronized (this.entityCaches) {
                block11: {
                    this.entityCaches[channel.channelIndex()] = channel.prepareImportData();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    this.ensureReaderThread();
                    SourceFileSlice currentSourceFile = this.sourceFileTails[channel.channelIndex()];
                    try {
                        while (true) {
                            SourceFileSlice sourceFileSlice = currentSourceFile;
                            synchronized (sourceFileSlice) {
                                while (currentSourceFile.next == null) {
                                    if (this.complete) {
                                        break block11;
                                    }
                                    currentSourceFile.wait(100L);
                                }
                                currentSourceFile = currentSourceFile.next;
                            }
                            channel.importData(currentSourceFile);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new StorageException(e);
                    }
                }
                return null;
            }
        }

        @Override
        protected final void succeed(StorageChannel channel, Void result) {
            this.objectIdRangeEvaluator.evaluateObjectIdRange(0L, this.maxObjectId);
            channel.commitImportData(this.timestamp());
        }

        @Override
        protected void postCompletionSuccess(StorageChannel channel, Void result) throws InterruptedException {
            this.cleanUpResources();
        }

        @Override
        protected final void fail(StorageChannel channel, Void result) {
            this.cleanUpResources();
            channel.rollbackImportData(this.problemForChannel(channel));
        }

        private void cleanUpResources() {
            DisruptionCollectorExecuting<SourceFileSlice> closer = DisruptionCollectorExecuting.New(fc -> {
                boolean bl = fc.close();
            });
            SourceFileSlice[] sourceFileSliceArray = this.sourceFileTails;
            int n = this.sourceFileTails.length;
            int n2 = 0;
            while (n2 < n) {
                SourceFileSlice s;
                SourceFileSlice file = s = sourceFileSliceArray[n2];
                while ((file = file.next) != null) {
                    closer.executeOn(file);
                }
                ++n2;
            }
            if (closer.hasDisruptions()) {
                throw new StorageException((Throwable)closer.toMultiCauseException());
            }
        }

        static final class ItemReader
        implements StorageDataFileItemIterator.ItemProcessor {
            private final StorageEntityCache.Default[] entityCaches;
            private final SourceFileSlice[] sourceFileHeads;
            private final ChannelItem[] channelItems;
            private final int channelHash;
            private AFile file;
            private int currentBatchChannel;
            private long currentSourceFilePosition;
            private long maxObjectId;

            public ItemReader(StorageEntityCache.Default[] entityCaches, SourceFileSlice[] sourceFileHeads) {
                this.entityCaches = entityCaches;
                this.sourceFileHeads = sourceFileHeads;
                this.channelHash = sourceFileHeads.length - 1;
                this.channelItems = (ChannelItem[])XArrays.fill((Object[])new ChannelItem[sourceFileHeads.length], () -> new ChannelItem().resetChains());
            }

            @Override
            public boolean accept(long address, long availableItemLength) {
                long length = Binary.getEntityLengthRawValue((long)address);
                if (length < 0L) {
                    this.currentSourceFilePosition += (long)X.checkArrayRange((long)(-length));
                    this.currentBatchChannel = -1;
                    return true;
                }
                if (availableItemLength < (long)Binary.entityHeaderLength()) {
                    return false;
                }
                int intLength = X.checkArrayRange((long)length);
                long objectId = Binary.getEntityObjectIdRawValue((long)address);
                int channelIndex = (int)objectId & this.channelHash;
                StorageEntityType.Default type = this.entityCaches[channelIndex].validateEntity(intLength, Binary.getEntityTypeIdRawValue((long)address), objectId);
                if (channelIndex != this.currentBatchChannel) {
                    this.currentBatchChannel = channelIndex;
                    this.startNewBatch(intLength, objectId, type);
                } else {
                    this.addToCurrentBatch(intLength, objectId, type);
                }
                if (objectId >= this.maxObjectId) {
                    this.maxObjectId = objectId;
                }
                this.currentSourceFilePosition += (long)intLength;
                return true;
            }

            private void startNewBatch(int length, long objectId, StorageEntityType.Default type) {
                ChannelItem item = this.channelItems[this.currentBatchChannel];
                item.tailBatch = item.tailBatch.batchNext = new ImportBatch(this.currentSourceFilePosition, length, objectId, type);
                item.tailEntity = item.tailBatch.batchNext;
            }

            private void addToCurrentBatch(int length, long objectId, StorageEntityType.Default type) {
                ChannelItem item = this.channelItems[this.currentBatchChannel];
                item.tailEntity = item.tailEntity.next = new ImportEntity(length, objectId, type);
                item.tailBatch.batchLength += (long)length;
            }

            final void setSourceFile(AFile file) {
                this.currentBatchChannel = -1;
                this.currentSourceFilePosition = 0L;
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void completeCurrentSourceFile() {
                SourceFileSlice[] sourceFileHeads = this.sourceFileHeads;
                ChannelItem[] channelItems = this.channelItems;
                int i = 0;
                while (i < sourceFileHeads.length) {
                    SourceFileSlice oldSourceFileHead = sourceFileHeads[i];
                    ChannelItem currentItem = channelItems[i];
                    sourceFileHeads[i] = sourceFileHeads[i].next = new SourceFileSlice(i, this.file, currentItem.headBatch.batchNext);
                    currentItem.resetChains();
                    SourceFileSlice sourceFileSlice = oldSourceFileHead;
                    synchronized (sourceFileSlice) {
                        oldSourceFileHead.notifyAll();
                    }
                    ++i;
                }
            }
        }
    }

    public static final class ImportBatch
    extends ImportEntity
    implements StorageChannelImportBatch {
        long batchOffset;
        long batchLength;
        ImportBatch batchNext;

        ImportBatch() {
            super(0, 0L, null);
        }

        ImportBatch(long batchOffset, int entityLength, long objectId, StorageEntityType.Default type) {
            super(entityLength, objectId, type);
            this.batchOffset = batchOffset;
            this.batchLength = entityLength;
        }

        @Override
        public long fileOffset() {
            return this.batchOffset;
        }

        @Override
        public final long fileLength() {
            return this.batchLength;
        }

        @Override
        public final void iterateEntities(Consumer<? super StorageChannelImportEntity> iterator) {
            ImportEntity e = this.first();
            while (e != null) {
                iterator.accept(e);
                e = e.next;
            }
        }

        @Override
        public final ImportEntity first() {
            return this.type != null ? this : this.batchNext;
        }

        public final String toString() {
            return "batch[" + this.length + "]" + (this.batchNext == null ? "" : " " + this.batchNext.toString());
        }
    }

    public static class ImportEntity
    implements StorageChannelImportEntity {
        final int length;
        final long objectId;
        final StorageEntityType.Default type;
        ImportEntity next;

        ImportEntity(int length, long objectId, StorageEntityType.Default type) {
            this.length = length;
            this.objectId = objectId;
            this.type = type;
        }

        @Override
        public final int length() {
            return this.length;
        }

        @Override
        public final StorageEntityType.Default type() {
            return this.type;
        }

        @Override
        public final long objectId() {
            return this.objectId;
        }

        @Override
        public final StorageChannelImportEntity next() {
            return this.next;
        }
    }

    public static final class SourceFileSlice
    extends StorageChannelFile.Abstract
    implements StorageImportSourceFile {
        final ImportBatch headBatch;
        SourceFileSlice next;

        SourceFileSlice(int channelIndex, AFile file, ImportBatch headBatch) {
            super(file, channelIndex);
            this.headBatch = headBatch;
        }

        @Override
        public final void iterateBatches(Consumer<? super StorageChannelImportBatch> iterator) {
            ImportBatch batch = this.headBatch;
            while (batch != null) {
                iterator.accept(batch);
                batch = batch.batchNext;
            }
        }

        @Override
        public String toString() {
            return String.valueOf(Integer.toString(this.channelIndex())) + " " + (this.file() == null ? "<Dummy>" : String.valueOf(this.file().toPathString()) + " " + this.headBatch);
        }
    }
}

