/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.persistence.binary.types.ChunksBuffer;
import one.microstream.storage.exceptions.StorageExceptionRequest;
import one.microstream.storage.types.StorageChannel;
import one.microstream.storage.types.StorageChannelTask;
import one.microstream.storage.types.StorageRequestTask;

public interface StorageRequestTaskLoad
extends StorageRequestTask {
    public ChunksBuffer result() throws StorageExceptionRequest;

    public static abstract class Abstract
    extends StorageChannelTask.Abstract<ChunksBuffer>
    implements StorageRequestTaskLoad {
        private final ChunksBuffer[] result;

        protected Abstract(long timestamp, int channelCount) {
            super(timestamp, channelCount);
            this.result = new ChunksBuffer[channelCount];
        }

        protected final ChunksBuffer[] resultArray() {
            return this.result;
        }

        @Override
        protected void complete(StorageChannel channel, ChunksBuffer result) throws InterruptedException {
            this.result[channel.channelIndex()] = result;
            this.incrementCompletionProgress();
        }

        @Override
        public final ChunksBuffer result() throws StorageExceptionRequest {
            if (this.hasProblems()) {
                throw new StorageExceptionRequest(this.problems());
            }
            return this.result[0];
        }
    }
}

