/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.AFS;
import one.microstream.afs.types.AFile;
import one.microstream.afs.types.AReadableFile;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.types.StorageTransactionsAnalysis;
import one.microstream.storage.types.StorageTransactionsEntryType;

public interface StorageTransactionsEntries {
    public XGettingSequence<Entry> entries();

    public static StorageTransactionsEntries parseFileContent(AReadableFile file) {
        if (!file.exists()) {
            return StorageTransactionsEntries.New();
        }
        BulkList entries = BulkList.New();
        StorageTransactionsAnalysis.Logic.processInputFile(file, new EntryCollector((XCollection<Entry>)entries));
        return StorageTransactionsEntries.New((XGettingSequence<Entry>)entries);
    }

    public static StorageTransactionsEntries parseFile(AFile file) {
        return (StorageTransactionsEntries)AFS.apply((AFile)file, rf -> StorageTransactionsEntries.parseFileContent(rf));
    }

    public static StorageTransactionsEntries New() {
        return new Default((XGettingSequence<Entry>)X.empty());
    }

    public static StorageTransactionsEntries New(XGettingSequence<Entry> entries) {
        return new Default((XGettingSequence<Entry>)((XGettingSequence)X.notNull(entries)));
    }

    public static final class Default
    implements StorageTransactionsEntries {
        final XGettingSequence<Entry> entries;

        Default(XGettingSequence<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public final XGettingSequence<Entry> entries() {
            return this.entries;
        }
    }

    public static interface Entry {
        public StorageTransactionsEntryType type();

        public long timestamp();

        public long fileLength();

        public long targetFileNumber();

        public Long sourceFileNumber();

        public Long specialOffset();

        public long lengthChange();

        public void setLengthChange(long var1);

        public static Entry New(StorageTransactionsEntryType type, long timestamp, long fileLength, long targetFileNumber, Long sourceFileNumber, Long specialOffset) {
            return new Default(type, timestamp, fileLength, targetFileNumber, sourceFileNumber, specialOffset);
        }

        public static final class Default
        implements Entry {
            private final StorageTransactionsEntryType type;
            private final long timestamp;
            private final long fileLength;
            private final long targetFileNumber;
            private final Long sourceFileNumber;
            private final Long specialOffset;
            private long lengthChange;

            Default(StorageTransactionsEntryType type, long timestamp, long fileLength, long targetFileNumber, Long sourceFileNumber, Long specialOffset) {
                this.type = type;
                this.timestamp = timestamp;
                this.fileLength = fileLength;
                this.targetFileNumber = targetFileNumber;
                this.sourceFileNumber = sourceFileNumber;
                this.specialOffset = specialOffset;
            }

            @Override
            public final StorageTransactionsEntryType type() {
                return this.type;
            }

            @Override
            public final long timestamp() {
                return this.timestamp;
            }

            @Override
            public final long fileLength() {
                return this.fileLength;
            }

            @Override
            public final long targetFileNumber() {
                return this.targetFileNumber;
            }

            @Override
            public final Long sourceFileNumber() {
                return this.sourceFileNumber;
            }

            @Override
            public final Long specialOffset() {
                return this.specialOffset;
            }

            @Override
            public long lengthChange() {
                return this.lengthChange;
            }

            @Override
            public void setLengthChange(long lengthChange) {
                this.lengthChange = lengthChange;
            }

            public final String toString() {
                return (Object)((Object)this.type) + " time=" + this.timestamp + ", fileLength=" + this.fileLength;
            }
        }
    }

    public static final class EntryCollector
    implements StorageTransactionsAnalysis.EntryIterator {
        private final XCollection<Entry> entries;
        private long currentFileNumber = 0L;
        private long currentFileLength;

        EntryCollector(XCollection<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public boolean accept(long address, long availableEntryLength) {
            if (availableEntryLength < 0L) {
                return true;
            }
            switch (StorageTransactionsAnalysis.Logic.getEntryType(address)) {
                case 0: {
                    return this.parseEntryFileCreation(address, availableEntryLength);
                }
                case 1: {
                    return this.parseEntryStore(address, availableEntryLength);
                }
                case 2: {
                    return this.parseEntryTransfer(address, availableEntryLength);
                }
                case 3: {
                    return this.parseEntryFileTruncation(address, availableEntryLength);
                }
                case 4: {
                    return this.parseEntryFileDeletion(address, availableEntryLength);
                }
            }
            throw new StorageException("Unknown transactions entry type: " + StorageTransactionsAnalysis.Logic.getEntryType(address));
        }

        private boolean parseEntryFileCreation(long address, long availableEntryLength) {
            if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_FILE_CREATION) {
                return false;
            }
            Entry e = Entry.New(StorageTransactionsEntryType.FILE_CREATION, StorageTransactionsAnalysis.Logic.getEntryTimestamp(address), StorageTransactionsAnalysis.Logic.getFileLength(address), StorageTransactionsAnalysis.Logic.getFileNumber(address), this.currentFileNumber, null);
            this.currentFileNumber = e.targetFileNumber();
            this.currentFileLength = 0L;
            this.addEntry(e);
            return true;
        }

        private void addEntry(Entry e) {
            e.setLengthChange(e.fileLength() - this.currentFileLength);
            this.currentFileLength = e.fileLength();
            this.entries.add((Object)e);
        }

        private boolean parseEntryStore(long address, long availableEntryLength) {
            if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_STORE) {
                return false;
            }
            Entry e = Entry.New(StorageTransactionsEntryType.DATA_STORE, StorageTransactionsAnalysis.Logic.getEntryTimestamp(address), StorageTransactionsAnalysis.Logic.getFileLength(address), this.currentFileNumber, null, null);
            this.addEntry(e);
            return true;
        }

        private boolean parseEntryTransfer(long address, long availableEntryLength) {
            if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_TRANSFER) {
                return false;
            }
            Entry e = Entry.New(StorageTransactionsEntryType.DATA_TRANSFER, StorageTransactionsAnalysis.Logic.getEntryTimestamp(address), StorageTransactionsAnalysis.Logic.getFileLength(address), this.currentFileNumber, StorageTransactionsAnalysis.Logic.getFileNumber(address), StorageTransactionsAnalysis.Logic.getSpecialOffset(address));
            this.addEntry(e);
            return true;
        }

        private boolean parseEntryFileTruncation(long address, long availableEntryLength) {
            if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_FILE_TRUNCATION) {
                return false;
            }
            Entry e = Entry.New(StorageTransactionsEntryType.FILE_TRUNCATION, StorageTransactionsAnalysis.Logic.getEntryTimestamp(address), StorageTransactionsAnalysis.Logic.getFileLength(address), StorageTransactionsAnalysis.Logic.getFileNumber(address), null, StorageTransactionsAnalysis.Logic.getSpecialOffset(address));
            this.addEntry(e);
            return true;
        }

        private boolean parseEntryFileDeletion(long address, long availableEntryLength) {
            if (availableEntryLength < (long)StorageTransactionsAnalysis.Logic.LENGTH_FILE_DELETION) {
                return false;
            }
            Entry e = Entry.New(StorageTransactionsEntryType.FILE_DELETION, StorageTransactionsAnalysis.Logic.getEntryTimestamp(address), StorageTransactionsAnalysis.Logic.getFileLength(address), StorageTransactionsAnalysis.Logic.getFileNumber(address), null, null);
            this.entries.add((Object)e);
            return true;
        }
    }
}

