/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import java.util.function.Consumer;
import one.microstream.collections.HashMapIdObject;
import one.microstream.collections.types.XGettingTable;
import one.microstream.persistence.exceptions.PersistenceExceptionTypeHandlerConsistencyUnhandledTypeId;
import one.microstream.persistence.types.PersistenceTypeDefinition;
import one.microstream.persistence.types.PersistenceTypeDefinitionRegistrationObserver;
import one.microstream.persistence.types.PersistenceTypeDescription;
import one.microstream.persistence.types.PersistenceTypeDictionary;
import one.microstream.persistence.types.PersistenceTypeDictionaryView;
import one.microstream.persistence.types.PersistenceTypeLineage;
import one.microstream.storage.exceptions.StorageException;
import one.microstream.storage.exceptions.StorageExceptionConsistency;
import one.microstream.storage.exceptions.StorageExceptionInitialization;
import one.microstream.storage.types.StorageEntityTypeHandler;

public interface StorageTypeDictionary
extends PersistenceTypeDictionary,
PersistenceTypeDefinitionRegistrationObserver {
    public <P extends Consumer<? super StorageEntityTypeHandler>> P iterateTypeHandlers(P var1);

    public StorageEntityTypeHandler lookupTypeHandler(long var1);

    default public StorageEntityTypeHandler lookupTypeHandlerChecked(long typeId) {
        StorageEntityTypeHandler typeHandler = this.lookupTypeHandler(typeId);
        if (typeHandler != null) {
            return typeHandler;
        }
        throw new StorageException("TypeId not resolvable via type dictionary: " + typeId);
    }

    public void validateEntityTypeId(long var1);

    public StorageEntityTypeHandler validateEntity(long var1, long var3, long var5);

    public void validate(PersistenceTypeDictionary var1);

    public StorageTypeDictionary initialize(PersistenceTypeDictionary var1);

    public StorageTypeDictionary setTypeDescriptionRegistrationObserver(PersistenceTypeDefinitionRegistrationObserver var1);

    public static final class Default
    implements StorageTypeDictionary {
        private final HashMapIdObject<StorageEntityTypeHandler> registry = HashMapIdObject.New();
        private final boolean switchByteOrder;
        private PersistenceTypeDictionary dictionary;

        public Default(boolean switchByteOrder) {
            this.switchByteOrder = switchByteOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void deriveHandler(PersistenceTypeDefinition typeDefinition) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                this.registry.put(typeDefinition.typeId(), (Object)new StorageEntityTypeHandler.Default(typeDefinition, this.switchByteOrder));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final <P extends Consumer<? super StorageEntityTypeHandler>> P iterateTypeHandlers(P procedure) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                this.registry.iterateValues(procedure);
            }
            return procedure;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final StorageEntityTypeHandler lookupTypeHandler(long typeId) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                return (StorageEntityTypeHandler)this.registry.get(typeId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean registerTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                return this.dictionary.registerTypeDefinition(typeDefinition);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerRuntimeTypeDefinition(PersistenceTypeDefinition typeDefinition) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                return this.dictionary.registerRuntimeTypeDefinition(typeDefinition);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerRuntimeTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                return this.dictionary.registerRuntimeTypeDefinitions(typeDefinitions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean registerTypeDefinitions(Iterable<? extends PersistenceTypeDefinition> typeDefinitions) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                return this.dictionary.registerTypeDefinitions(typeDefinitions);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void validate(PersistenceTypeDictionary typeDictionary) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                for (PersistenceTypeDefinition typeDesc : typeDictionary.allTypeDefinitions().values()) {
                    if (PersistenceTypeDescription.equalStructure((PersistenceTypeDescription)typeDesc, (PersistenceTypeDescription)((PersistenceTypeDescription)this.registry.get(typeDesc.typeId())))) continue;
                    throw new StorageException("Invalid type description: " + typeDesc.toTypeIdentifier());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void validateEntityTypeId(long typeId) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                if (this.registry.get(typeId) == null) {
                    throw new PersistenceExceptionTypeHandlerConsistencyUnhandledTypeId(typeId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final StorageEntityTypeHandler validateEntity(long length, long typeId, long objectId) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                StorageEntityTypeHandler typeHandler = this.lookupTypeHandler(typeId);
                if (typeHandler == null) {
                    throw new StorageException("Unknown type id " + typeId + " of entity with oid " + objectId + " and length " + length);
                }
                typeHandler.validateEntityGuaranteedType(length, objectId);
                return typeHandler;
            }
        }

        public XGettingTable<Long, PersistenceTypeDefinition> allTypeDefinitions() {
            return this.dictionary.allTypeDefinitions();
        }

        public final PersistenceTypeDefinition lookupTypeByName(String typeName) {
            return this.dictionary.lookupTypeByName(typeName);
        }

        public final PersistenceTypeDefinition lookupTypeById(long typeId) {
            return this.dictionary.lookupTypeById(typeId);
        }

        public final long determineHighestTypeId() {
            return this.dictionary.determineHighestTypeId();
        }

        @Override
        public final StorageTypeDictionary setTypeDescriptionRegistrationObserver(PersistenceTypeDefinitionRegistrationObserver observer) {
            if (observer != this) {
                throw new StorageExceptionConsistency("Inconsistent " + PersistenceTypeDefinitionRegistrationObserver.class.getSimpleName());
            }
            return this;
        }

        public final PersistenceTypeDefinitionRegistrationObserver getTypeDescriptionRegistrationObserver() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StorageTypeDictionary initialize(PersistenceTypeDictionary typeDictionary) {
            HashMapIdObject<StorageEntityTypeHandler> hashMapIdObject = this.registry;
            synchronized (hashMapIdObject) {
                if (this.dictionary != null) {
                    if (this.dictionary == typeDictionary) {
                        return this;
                    }
                    throw new StorageExceptionInitialization("Type dictionary already initialized.");
                }
                for (PersistenceTypeDefinition td : typeDictionary.allTypeDefinitions().values()) {
                    this.deriveHandler(td);
                }
                this.dictionary = typeDictionary;
                return this;
            }
        }

        public void observeTypeDefinitionRegistration(PersistenceTypeDefinition typeDefinition) {
            this.deriveHandler(typeDefinition);
        }

        public XGettingTable<String, ? extends PersistenceTypeLineage> typeLineages() {
            return this.dictionary.typeLineages();
        }

        public boolean isEmpty() {
            return this.registry.isEmpty();
        }

        public PersistenceTypeLineage ensureTypeLineage(Class<?> type) {
            return this.dictionary.ensureTypeLineage(type);
        }

        public PersistenceTypeLineage lookupTypeLineage(Class<?> type) {
            return this.dictionary.lookupTypeLineage(type);
        }

        public PersistenceTypeLineage lookupTypeLineage(String typeName) {
            return this.dictionary.lookupTypeLineage(typeName);
        }

        public PersistenceTypeDictionaryView view() {
            return this.dictionary.view();
        }
    }
}

