/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.storage.types;

import one.microstream.X;
import one.microstream.afs.types.WriteController;
import one.microstream.persistence.types.PersistenceWriteController;
import one.microstream.storage.exceptions.StorageExceptionBackupDisabled;
import one.microstream.storage.exceptions.StorageExceptionDeletionDirectoryDisabled;
import one.microstream.storage.exceptions.StorageExceptionFileCleanupDisabled;
import one.microstream.storage.exceptions.StorageExceptionFileDeletionDisabled;

public interface StorageWriteController
extends PersistenceWriteController {
    default public void validateIsFileCleanupEnabled() {
        if (this.isFileCleanupEnabled()) {
            return;
        }
        throw new StorageExceptionFileCleanupDisabled("File Cleanup is not enabled.");
    }

    public boolean isFileCleanupEnabled();

    default public void validateIsBackupEnabled() {
        if (this.isBackupEnabled()) {
            return;
        }
        throw new StorageExceptionBackupDisabled("Backup is not enabled.");
    }

    public boolean isBackupEnabled();

    default public void validateIsDeletionDirectoryEnabled() {
        if (this.isDeletionDirectoryEnabled()) {
            return;
        }
        throw new StorageExceptionDeletionDirectoryDisabled("Deletion directory is not enabled.");
    }

    public boolean isDeletionDirectoryEnabled();

    default public void validateIsFileDeletionEnabled() {
        if (this.isFileDeletionEnabled()) {
            return;
        }
        throw new StorageExceptionFileDeletionDisabled("File deletion is not enabled.");
    }

    public boolean isFileDeletionEnabled();

    public static StorageWriteController Wrap(WriteController writeController) {
        return new Wrapper((WriteController)X.notNull((Object)writeController));
    }

    public static final class Wrapper
    implements StorageWriteController {
        private final WriteController writeController;

        Wrapper(WriteController writeController) {
            this.writeController = writeController;
        }

        public final void validateIsWritable() {
            this.writeController.validateIsWritable();
        }

        public final boolean isWritable() {
            return this.writeController.isWritable();
        }

        public final void validateIsStoringEnabled() {
            this.validateIsWritable();
        }

        public final boolean isStoringEnabled() {
            return this.isWritable();
        }

        @Override
        public final boolean isFileCleanupEnabled() {
            return this.isWritable();
        }

        @Override
        public final boolean isBackupEnabled() {
            return this.isWritable();
        }

        @Override
        public final boolean isDeletionDirectoryEnabled() {
            return this.isWritable();
        }

        @Override
        public final boolean isFileDeletionEnabled() {
            return this.isWritable();
        }
    }
}

